/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jsr77.managedobject;

import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.dmr.ModelNode;

public class ModelReader {
    private final ModelController controller;
    private volatile ModelNode deploymentModel;

    public ModelReader(ModelController controller) {
        this.controller = controller;
    }

    ModelNode getDeploymentModel() {
        if (this.deploymentModel == null) {
            ModelNode operation = new ModelNode();
            operation.get("operation").set("read-resource");
            operation.get("recursive").set(true);
            operation.get("address").set(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"deployment")}).toModelNode());
            this.deploymentModel = this.execute(operation);
        }
        return this.deploymentModel;
    }

    ModelNode execute(ModelNode operation) {
        ModelNode result = this.controller.execute(operation, OperationMessageHandler.logging, ModelController.OperationTransactionControl.COMMIT, null);
        if (result.hasDefined("failure-description")) {
            throw new RuntimeException(result.get("failure-description").toString());
        }
        return result.require("result");
    }

    void setDeploymentModel(ModelNode deploymentModel) {
        this.deploymentModel = deploymentModel;
    }
}

