/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.cl;

import org.jboss.aesh.cl.CommandLine;
import org.jboss.aesh.cl.CommandLineParser;
import org.jboss.aesh.cl.ParsedCompleteObject;
import org.jboss.aesh.cl.ParsedOption;
import org.jboss.aesh.util.Parser;

public class CommandLineCompletionParser {
    private CommandLineParser parser;

    public CommandLineCompletionParser(CommandLineParser parser) {
        this.parser = parser;
    }

    public ParsedCompleteObject findCompleteObject(String line) {
        if (Parser.findIfWordEndWithSpace(line)) {
            return new ParsedCompleteObject(true);
        }
        String lastWord = Parser.findEscapedSpaceWordCloseToEnd(line);
        if (lastWord.startsWith("-")) {
            String secLastWord = Parser.findEscapedSpaceWordCloseToEnd(line.substring(0, line.length() - lastWord.length()));
            if (secLastWord.startsWith("-")) {
                return this.findCompleteObjectValue(line);
            }
            if (lastWord.equals("-")) {
                return new ParsedCompleteObject(true, "", 1);
            }
            if (lastWord.equals("--")) {
                return new ParsedCompleteObject(true, "", 2);
            }
            return new ParsedCompleteObject(true, Parser.trimOptionName(lastWord), lastWord.length());
        }
        return this.findCompleteObjectValue(line);
    }

    private ParsedCompleteObject findCompleteObjectValue(String line) {
        CommandLine cl = this.parser.parse(line, true);
        if (cl.getArguments().isEmpty()) {
            ParsedOption po = cl.getOptions().get(cl.getOptions().size() - 1);
            return new ParsedCompleteObject(po.getLongName().isEmpty() ? po.getName() : po.getLongName(), po.getValue(), po.getType(), true);
        }
        return new ParsedCompleteObject("", cl.getArguments().get(cl.getArguments().size() - 1), this.parser.getParameters().get(0).getArgumentType(), false);
    }
}

