/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.deployers.ra.processors;

import java.io.Closeable;
import java.io.InputStream;
import java.util.Locale;
import org.jboss.as.connector.deployers.Util;
import org.jboss.as.connector.logging.ConnectorMessages;
import org.jboss.as.connector.metadata.xmldescriptors.IronJacamarXmlDescriptor;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.jca.common.api.metadata.ironjacamar.IronJacamar;
import org.jboss.jca.common.metadata.ironjacamar.v11.IronJacamarParser;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;

public class IronJacamarDeploymentParsingProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        boolean resolveProperties;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ResourceRoot resourceRoot = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        VirtualFile deploymentRoot = resourceRoot.getRoot();
        IronJacamarXmlDescriptor xmlDescriptor = IronJacamarDeploymentParsingProcessor.process(deploymentRoot, resolveProperties = Util.shouldResolveJBoss(deploymentUnit));
        if (xmlDescriptor != null) {
            deploymentUnit.putAttachment(IronJacamarXmlDescriptor.ATTACHMENT_KEY, (Object)xmlDescriptor);
        }
    }

    public static IronJacamarXmlDescriptor process(VirtualFile deploymentRoot, boolean resolveProperties) throws DeploymentUnitProcessingException {
        IronJacamarXmlDescriptor xmlDescriptor;
        block9: {
            xmlDescriptor = null;
            if (deploymentRoot == null || !deploymentRoot.exists()) {
                return null;
            }
            String deploymentRootName = deploymentRoot.getName().toLowerCase(Locale.ENGLISH);
            VirtualFile serviceXmlFile = null;
            if (deploymentRootName.endsWith(".rar")) {
                serviceXmlFile = deploymentRoot.getChild("/META-INF/ironjacamar.xml");
            }
            if (serviceXmlFile == null || !serviceXmlFile.exists()) {
                return null;
            }
            InputStream xmlStream = null;
            org.jboss.jca.common.api.metadata.ironjacamar.v11.IronJacamar result = null;
            try {
                xmlStream = serviceXmlFile.openStream();
                IronJacamarParser ironJacamarParser = new IronJacamarParser();
                ironJacamarParser.setSystemPropertiesResolved(resolveProperties);
                result = ironJacamarParser.parse(xmlStream);
                if (result != null) {
                    xmlDescriptor = new IronJacamarXmlDescriptor((IronJacamar)result);
                    break block9;
                }
                throw ConnectorMessages.MESSAGES.failedToParseServiceXml(serviceXmlFile);
            }
            catch (Exception e) {
                throw ConnectorMessages.MESSAGES.failedToParseServiceXml(e, serviceXmlFile);
            }
            finally {
                VFSUtils.safeClose((Closeable)xmlStream);
            }
        }
        return xmlDescriptor;
    }

    public void undeploy(DeploymentUnit context) {
    }
}

