/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.services.workmanager;

import java.util.concurrent.Executor;
import org.jboss.as.clustering.jgroups.ChannelFactory;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.jca.core.api.workmanager.DistributedWorkManager;
import org.jboss.jca.core.api.workmanager.WorkManager;
import org.jboss.jca.core.spi.transaction.xa.XATerminator;
import org.jboss.jca.core.spi.workmanager.transport.Transport;
import org.jboss.jca.core.tx.jbossts.XATerminatorImpl;
import org.jboss.jca.core.workmanager.WorkManagerCoordinator;
import org.jboss.jca.core.workmanager.transport.remote.jgroups.JGroupsTransport;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.threads.BlockingExecutor;
import org.jboss.tm.JBossXATerminator;
import org.jgroups.JChannel;

public final class DistributedWorkManagerService
implements Service<DistributedWorkManager> {
    private final DistributedWorkManager value;
    private final InjectedValue<Executor> executorShort = new InjectedValue();
    private final InjectedValue<Executor> executorLong = new InjectedValue();
    private final InjectedValue<JBossXATerminator> xaTerminator = new InjectedValue();
    private final InjectedValue<ChannelFactory> jGroupsChannelFactory = new InjectedValue();
    private final String jgroupsChannelName;
    private final Long requestTimeout;

    public DistributedWorkManagerService(DistributedWorkManager value, String jgroupsChannelName, Long requestTimeout) {
        ConnectorLogger.ROOT_LOGGER.debugf("Building WorkManager", new Object[0]);
        this.value = value;
        this.jgroupsChannelName = jgroupsChannelName;
        this.requestTimeout = requestTimeout;
    }

    public DistributedWorkManager getValue() throws IllegalStateException {
        return ConnectorServices.notNull(this.value);
    }

    public void start(StartContext context) throws StartException {
        ConnectorLogger.ROOT_LOGGER.debugf("Starting JCA DistributedWorkManager: ", this.value.getName());
        JGroupsTransport transport = new JGroupsTransport();
        try {
            transport.setChannel((JChannel)((ChannelFactory)this.jGroupsChannelFactory.getValue()).createChannel(this.jgroupsChannelName));
            if (this.jgroupsChannelName != null) {
                transport.setClusterName(this.jgroupsChannelName);
            }
            if (this.requestTimeout != null) {
                transport.setTimeout(this.requestTimeout.longValue());
            }
            this.value.setTransport((Transport)transport);
        }
        catch (Exception e) {
            ConnectorLogger.ROOT_LOGGER.trace("failed to start JGroups channel", e);
            throw ConnectorLogger.ROOT_LOGGER.failedToStartJGroupsChannel(this.jgroupsChannelName, this.value.getName());
        }
        BlockingExecutor longRunning = (BlockingExecutor)this.executorLong.getOptionalValue();
        if (longRunning != null) {
            this.value.setLongRunningThreadPool(longRunning);
            this.value.setShortRunningThreadPool((BlockingExecutor)this.executorShort.getValue());
        } else {
            this.value.setLongRunningThreadPool((BlockingExecutor)this.executorShort.getValue());
            this.value.setShortRunningThreadPool((BlockingExecutor)this.executorShort.getValue());
        }
        this.value.setXATerminator((XATerminator)new XATerminatorImpl((JBossXATerminator)this.xaTerminator.getValue()));
        WorkManagerCoordinator.getInstance().registerWorkManager((WorkManager)this.value);
        try {
            transport.startup();
        }
        catch (Throwable throwable) {
            ConnectorLogger.ROOT_LOGGER.trace("failed to start DWM transport:", throwable);
            throw ConnectorLogger.ROOT_LOGGER.failedToStartDWMTransport(this.value.getName());
        }
        ConnectorLogger.ROOT_LOGGER.debugf("Started JCA DistributedWorkManager: ", this.value.getName());
    }

    public void stop(StopContext context) {
        ConnectorLogger.ROOT_LOGGER.debugf("Stopping JCA DistributedWorkManager: ", this.value.getName());
        this.value.prepareShutdown();
        try {
            this.value.getTransport().shutdown();
        }
        catch (Throwable throwable) {
            ConnectorLogger.ROOT_LOGGER.trace("failed to stop DWM transport:", throwable);
        }
        this.value.shutdown();
        WorkManagerCoordinator.getInstance().unregisterWorkManager((WorkManager)this.value);
        ConnectorLogger.ROOT_LOGGER.debugf("Stopped JCA DistributedWorkManager: ", this.value.getName());
    }

    public Injector<Executor> getExecutorShortInjector() {
        return this.executorShort;
    }

    public Injector<Executor> getExecutorLongInjector() {
        return this.executorLong;
    }

    public Injector<JBossXATerminator> getXaTerminatorInjector() {
        return this.xaTerminator;
    }

    public Injector<ChannelFactory> getJGroupsChannelFactoryInjector() {
        return this.jGroupsChannelFactory;
    }
}

