/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.picketlink.idm;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import javax.naming.directory.Attribute;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import org.picketlink.idm.IDMLog;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.config.LDAPIdentityStoreConfiguration;
import org.picketlink.idm.credential.Password;
import org.picketlink.idm.ldap.internal.LDAPIdentityStore;
import org.picketlink.idm.ldap.internal.LDAPOperationManager;
import org.picketlink.idm.ldap.internal.LDAPPlainTextPasswordCredentialHandler;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.basic.BasicModel;
import org.picketlink.idm.model.basic.User;
import org.picketlink.idm.spi.IdentityContext;

public class LDAPKeycloakCredentialHandler
extends LDAPPlainTextPasswordCredentialHandler {
    private static Method GET_BINDING_DN_METHOD = LDAPKeycloakCredentialHandler.getMethodOnLDAPStore("getBindingDN", AttributedType.class);
    private static Method GET_OPERATION_MANAGER_METHOD = LDAPKeycloakCredentialHandler.getMethodOnLDAPStore("getOperationManager", new Class[0]);
    private String userAccountControlAfterPasswordUpdate;

    public void setup(LDAPIdentityStore store) {
        if (((LDAPIdentityStoreConfiguration)store.getConfig()).isActiveDirectory() || Boolean.getBoolean("keycloak.ldap.ad.skipUserAccountControlAfterPasswordUpdate")) {
            String userAccountControlProp = System.getProperty("keycloak.ldap.ad.userAccountControlAfterPasswordUpdate");
            this.userAccountControlAfterPasswordUpdate = userAccountControlProp != null ? userAccountControlProp : "512";
            IDMLog.CREDENTIAL_LOGGER.info((Object)("Will use userAccountControl=" + this.userAccountControlAfterPasswordUpdate + " after password update of user in Active Directory"));
        }
    }

    protected Account getAccount(IdentityContext context, String loginName) {
        IdentityManager identityManager = this.getIdentityManager(context);
        if (IDMLog.CREDENTIAL_LOGGER.isDebugEnabled()) {
            IDMLog.CREDENTIAL_LOGGER.debugf("Trying to find account [%s] using default account type [%s]", (Object)loginName, User.class);
        }
        return BasicModel.getUser((IdentityManager)identityManager, (String)loginName);
    }

    public void update(IdentityContext context, Account account, Password password, LDAPIdentityStore store, Date effectiveDate, Date expiryDate) {
        super.update(context, account, password, store, effectiveDate, expiryDate);
        if (this.userAccountControlAfterPasswordUpdate != null) {
            ModificationItem[] mods = new ModificationItem[1];
            BasicAttribute mod0 = new BasicAttribute("userAccountControl", this.userAccountControlAfterPasswordUpdate);
            mods[0] = new ModificationItem(2, mod0);
            try {
                String bindingDN = (String)GET_BINDING_DN_METHOD.invoke((Object)store, account);
                LDAPOperationManager operationManager = (LDAPOperationManager)GET_OPERATION_MANAGER_METHOD.invoke((Object)store, new Object[0]);
                operationManager.modifyAttribute(bindingDN, (Attribute)mod0);
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException(iae);
            }
            catch (InvocationTargetException ite) {
                Throwable cause = ite.getTargetException() != null ? ite.getTargetException() : ite;
                throw new RuntimeException(cause);
            }
        }
    }

    private static Method getMethodOnLDAPStore(String methodName, Class ... classes) {
        try {
            Method m = LDAPIdentityStore.class.getDeclaredMethod(methodName, classes);
            m.setAccessible(true);
            return m;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

