/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.connectionmanager.pool.mcp;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.jca.core.connectionmanager.pool.mcp.ManagedConnectionPoolStatistics;
import org.jboss.jca.core.connectionmanager.pool.mcp.SecurityActions;

public class ManagedConnectionPoolStatisticsImpl
implements ManagedConnectionPoolStatistics {
    private static final long serialVersionUID = 6L;
    private static final String ACTIVE_COUNT = "ActiveCount";
    private static final String AVAILABLE_COUNT = "AvailableCount";
    private static final String AVERAGE_BLOCKING_TIME = "AverageBlockingTime";
    private static final String AVERAGE_CREATION_TIME = "AverageCreationTime";
    private static final String AVERAGE_GET_TIME = "AverageGetTime";
    private static final String BLOCKING_FAILURE_COUNT = "BlockingFailureCount";
    private static final String CREATED_COUNT = "CreatedCount";
    private static final String DESTROYED_COUNT = "DestroyedCount";
    private static final String IDLE_COUNT = "IdleCount";
    private static final String IN_USE_COUNT = "InUseCount";
    private static final String MAX_CREATION_TIME = "MaxCreationTime";
    private static final String MAX_GET_TIME = "MaxGetTime";
    private static final String MAX_USED_COUNT = "MaxUsedCount";
    private static final String MAX_WAIT_COUNT = "MaxWaitCount";
    private static final String MAX_WAIT_TIME = "MaxWaitTime";
    private static final String TIMED_OUT = "TimedOut";
    private static final String TOTAL_BLOCKING_TIME = "TotalBlockingTime";
    private static final String TOTAL_BLOCKING_TIME_INVOCATIONS = "TotalBlockingTimeInvocations";
    private static final String TOTAL_CREATION_TIME = "TotalCreationTime";
    private static final String TOTAL_GET_TIME = "TotalGetTime";
    private static final String TOTAL_GET_TIME_INVOCATIONS = "TotalGetTimeInvocations";
    private static final String WAIT_COUNT = "WaitCount";
    private int maxPoolSize;
    private transient Set<String> names;
    private transient Map<String, Class> types;
    private transient Map<Locale, ResourceBundle> rbs;
    private transient AtomicBoolean enabled;
    private transient AtomicInteger createdCount;
    private transient AtomicInteger destroyedCount;
    private transient AtomicInteger maxUsedCount;
    private transient AtomicLong maxCreationTime;
    private transient AtomicLong maxGetTime;
    private transient AtomicInteger maxWaitCount;
    private transient AtomicLong maxWaitTime;
    private transient AtomicInteger timedOut;
    private transient AtomicLong totalBlockingTime;
    private transient AtomicLong totalBlockingTimeInvocations;
    private transient AtomicLong totalCreationTime;
    private transient AtomicLong totalGetTime;
    private transient AtomicLong totalGetTimeInvocations;
    private transient AtomicInteger inUseCount;
    private transient AtomicInteger blockingFailureCount;
    private transient AtomicInteger waitCount;

    public ManagedConnectionPoolStatisticsImpl(int maxPoolSize) {
        this.init(maxPoolSize);
    }

    private void init(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
        HashSet<String> n = new HashSet<String>();
        HashMap<String, Class<Number>> t = new HashMap<String, Class<Number>>();
        n.add(ACTIVE_COUNT);
        t.put(ACTIVE_COUNT, Integer.TYPE);
        n.add(AVAILABLE_COUNT);
        t.put(AVAILABLE_COUNT, Integer.TYPE);
        n.add(AVERAGE_BLOCKING_TIME);
        t.put(AVERAGE_BLOCKING_TIME, Long.TYPE);
        n.add(AVERAGE_CREATION_TIME);
        t.put(AVERAGE_CREATION_TIME, Long.TYPE);
        n.add(AVERAGE_GET_TIME);
        t.put(AVERAGE_GET_TIME, Long.TYPE);
        n.add(BLOCKING_FAILURE_COUNT);
        t.put(BLOCKING_FAILURE_COUNT, Integer.TYPE);
        n.add(CREATED_COUNT);
        t.put(CREATED_COUNT, Integer.TYPE);
        n.add(DESTROYED_COUNT);
        t.put(DESTROYED_COUNT, Integer.TYPE);
        n.add(IDLE_COUNT);
        t.put(IDLE_COUNT, Integer.TYPE);
        n.add(IN_USE_COUNT);
        t.put(IN_USE_COUNT, Integer.TYPE);
        n.add(MAX_CREATION_TIME);
        t.put(MAX_CREATION_TIME, Long.TYPE);
        n.add(MAX_GET_TIME);
        t.put(MAX_GET_TIME, Long.TYPE);
        n.add(MAX_USED_COUNT);
        t.put(MAX_USED_COUNT, Integer.TYPE);
        n.add(MAX_WAIT_COUNT);
        t.put(MAX_WAIT_COUNT, Integer.TYPE);
        n.add(MAX_WAIT_TIME);
        t.put(MAX_WAIT_TIME, Long.TYPE);
        n.add(TIMED_OUT);
        t.put(TIMED_OUT, Integer.TYPE);
        n.add(TOTAL_BLOCKING_TIME);
        t.put(TOTAL_BLOCKING_TIME, Long.TYPE);
        n.add(TOTAL_CREATION_TIME);
        t.put(TOTAL_CREATION_TIME, Long.TYPE);
        n.add(TOTAL_GET_TIME);
        t.put(TOTAL_GET_TIME, Long.TYPE);
        n.add(WAIT_COUNT);
        t.put(WAIT_COUNT, Integer.TYPE);
        this.names = Collections.unmodifiableSet(n);
        this.types = Collections.unmodifiableMap(t);
        ResourceBundle defaultResourceBundle = ResourceBundle.getBundle("poolstatistics", Locale.US, SecurityActions.getClassLoader(ManagedConnectionPoolStatisticsImpl.class));
        this.rbs = new HashMap<Locale, ResourceBundle>(1);
        this.rbs.put(Locale.US, defaultResourceBundle);
        this.enabled = new AtomicBoolean(true);
        this.createdCount = new AtomicInteger(0);
        this.destroyedCount = new AtomicInteger(0);
        this.maxCreationTime = new AtomicLong(Long.MIN_VALUE);
        this.maxGetTime = new AtomicLong(Long.MIN_VALUE);
        this.maxUsedCount = new AtomicInteger(Integer.MIN_VALUE);
        this.maxWaitCount = new AtomicInteger(Integer.MIN_VALUE);
        this.maxWaitTime = new AtomicLong(Long.MIN_VALUE);
        this.timedOut = new AtomicInteger(0);
        this.totalBlockingTime = new AtomicLong(0L);
        this.totalBlockingTimeInvocations = new AtomicLong(0L);
        this.totalCreationTime = new AtomicLong(0L);
        this.totalGetTime = new AtomicLong(0L);
        this.totalGetTimeInvocations = new AtomicLong(0L);
        this.inUseCount = new AtomicInteger(0);
        this.blockingFailureCount = new AtomicInteger(0);
        this.waitCount = new AtomicInteger(0);
    }

    public Set<String> getNames() {
        return this.names;
    }

    public Class getType(String name) {
        return this.types.get(name);
    }

    public String getDescription(String name) {
        return this.getDescription(name, Locale.US);
    }

    public String getDescription(String name, Locale locale) {
        ResourceBundle newResourceBundle;
        ResourceBundle rb = this.rbs.get(locale);
        if (rb == null && (newResourceBundle = ResourceBundle.getBundle("poolstatistics", locale, SecurityActions.getClassLoader(ManagedConnectionPoolStatisticsImpl.class))) != null) {
            this.rbs.put(locale, newResourceBundle);
        }
        if (rb == null) {
            rb = this.rbs.get(Locale.US);
        }
        if (rb != null) {
            return rb.getString(name);
        }
        return "";
    }

    public Object getValue(String name) {
        if (ACTIVE_COUNT.equals(name)) {
            return this.getActiveCount();
        }
        if (AVAILABLE_COUNT.equals(name)) {
            return this.getAvailableCount();
        }
        if (AVERAGE_BLOCKING_TIME.equals(name)) {
            return this.getAverageBlockingTime();
        }
        if (AVERAGE_CREATION_TIME.equals(name)) {
            return this.getAverageCreationTime();
        }
        if (AVERAGE_GET_TIME.equals(name)) {
            return this.getAverageGetTime();
        }
        if (BLOCKING_FAILURE_COUNT.equals(name)) {
            return this.getBlockingFailureCount();
        }
        if (CREATED_COUNT.equals(name)) {
            return this.getCreatedCount();
        }
        if (DESTROYED_COUNT.equals(name)) {
            return this.getDestroyedCount();
        }
        if (IDLE_COUNT.equals(name)) {
            return this.getIdleCount();
        }
        if (IN_USE_COUNT.equals(name)) {
            return this.getInUseCount();
        }
        if (MAX_CREATION_TIME.equals(name)) {
            return this.getMaxCreationTime();
        }
        if (MAX_GET_TIME.equals(name)) {
            return this.getMaxGetTime();
        }
        if (MAX_USED_COUNT.equals(name)) {
            return this.getMaxUsedCount();
        }
        if (MAX_WAIT_COUNT.equals(name)) {
            return this.getMaxWaitCount();
        }
        if (MAX_WAIT_TIME.equals(name)) {
            return this.getMaxWaitTime();
        }
        if (TIMED_OUT.equals(name)) {
            return this.getTimedOut();
        }
        if (TOTAL_BLOCKING_TIME.equals(name)) {
            return this.getTotalBlockingTime();
        }
        if (TOTAL_CREATION_TIME.equals(name)) {
            return this.getTotalCreationTime();
        }
        if (TOTAL_GET_TIME.equals(name)) {
            return this.getTotalGetTime();
        }
        if (WAIT_COUNT.equals(name)) {
            return this.getWaitCount();
        }
        return null;
    }

    public boolean isEnabled() {
        return this.enabled.get();
    }

    public void setEnabled(boolean v) {
        this.enabled.set(v);
        this.clear();
    }

    public int getActiveCount() {
        if (!this.enabled.get()) {
            return 0;
        }
        return this.createdCount.get() - this.destroyedCount.get();
    }

    public int getAvailableCount() {
        if (!this.enabled.get()) {
            return 0;
        }
        return this.maxPoolSize - this.inUseCount.get();
    }

    public long getAverageBlockingTime() {
        if (!this.enabled.get()) {
            return 0L;
        }
        return this.totalBlockingTimeInvocations.get() != 0L ? this.totalBlockingTime.get() / this.totalBlockingTimeInvocations.get() : 0L;
    }

    public long getAverageCreationTime() {
        if (!this.enabled.get()) {
            return 0L;
        }
        return this.createdCount.get() != 0 ? this.totalCreationTime.get() / (long)this.createdCount.get() : 0L;
    }

    public long getAverageGetTime() {
        if (!this.enabled.get()) {
            return 0L;
        }
        return this.totalGetTimeInvocations.get() != 0L ? this.totalGetTime.get() / this.totalGetTimeInvocations.get() : 0L;
    }

    public int getBlockingFailureCount() {
        if (!this.enabled.get()) {
            return 0;
        }
        return this.blockingFailureCount.get();
    }

    public void deltaBlockingFailureCount() {
        if (this.enabled.get()) {
            this.blockingFailureCount.incrementAndGet();
        }
    }

    public int getCreatedCount() {
        if (!this.enabled.get()) {
            return 0;
        }
        return this.createdCount.get();
    }

    public void deltaCreatedCount() {
        if (this.enabled.get()) {
            this.createdCount.incrementAndGet();
        }
    }

    public int getDestroyedCount() {
        if (!this.enabled.get()) {
            return 0;
        }
        return this.destroyedCount.get();
    }

    public void deltaDestroyedCount() {
        if (this.enabled.get()) {
            this.destroyedCount.incrementAndGet();
        }
    }

    public int getIdleCount() {
        if (!this.enabled.get()) {
            return 0;
        }
        return this.getActiveCount() - this.getInUseCount();
    }

    public int getInUseCount() {
        if (!this.enabled.get()) {
            return 0;
        }
        return this.inUseCount.get();
    }

    public void setInUsedCount(int v) {
        if (this.enabled.get()) {
            this.inUseCount.set(v);
            this.setMaxUsedCount(v);
        }
    }

    public int getMaxUsedCount() {
        if (!this.enabled.get()) {
            return 0;
        }
        return this.maxUsedCount.get() != Integer.MIN_VALUE ? this.maxUsedCount.get() : 0;
    }

    public void setMaxUsedCount(int v) {
        if (this.enabled.get() && v > this.maxUsedCount.get()) {
            this.maxUsedCount.set(v);
        }
    }

    public int getMaxWaitCount() {
        if (!this.enabled.get()) {
            return 0;
        }
        return this.maxWaitCount.get() != Integer.MIN_VALUE ? this.maxWaitCount.get() : 0;
    }

    public void setMaxWaitCount(int v) {
        if (this.enabled.get() && v > this.maxWaitCount.get()) {
            this.maxWaitCount.set(v);
        }
    }

    public long getMaxCreationTime() {
        if (!this.enabled.get()) {
            return 0L;
        }
        return this.maxCreationTime.get() != Long.MIN_VALUE ? this.maxCreationTime.get() : 0L;
    }

    public long getMaxGetTime() {
        if (!this.enabled.get()) {
            return 0L;
        }
        return this.maxGetTime.get() != Long.MIN_VALUE ? this.maxGetTime.get() : 0L;
    }

    public long getMaxWaitTime() {
        if (!this.enabled.get()) {
            return 0L;
        }
        return this.maxWaitTime.get() != Long.MIN_VALUE ? this.maxWaitTime.get() : 0L;
    }

    public int getTimedOut() {
        if (!this.enabled.get()) {
            return 0;
        }
        return this.timedOut.get();
    }

    public void deltaTimedOut() {
        if (this.enabled.get()) {
            this.timedOut.incrementAndGet();
        }
    }

    public long getTotalBlockingTime() {
        if (!this.enabled.get()) {
            return 0L;
        }
        return this.totalBlockingTime.get();
    }

    public void deltaTotalBlockingTime(long delta) {
        if (this.enabled.get() && delta > 0L) {
            this.totalBlockingTime.addAndGet(delta);
            this.totalBlockingTimeInvocations.incrementAndGet();
            if (delta > this.maxWaitTime.get()) {
                this.maxWaitTime.set(delta);
            }
        }
    }

    @Override
    public long getTotalBlockingInvocations() {
        if (!this.enabled.get()) {
            return 0L;
        }
        return this.totalBlockingTimeInvocations.get();
    }

    public long getTotalCreationTime() {
        if (!this.enabled.get()) {
            return 0L;
        }
        return this.totalCreationTime.get();
    }

    public void deltaTotalCreationTime(long delta) {
        if (this.enabled.get() && delta > 0L) {
            this.totalCreationTime.addAndGet(delta);
            if (delta > this.maxCreationTime.get()) {
                this.maxCreationTime.set(delta);
            }
        }
    }

    public long getTotalGetTime() {
        if (!this.enabled.get()) {
            return 0L;
        }
        return this.totalGetTime.get();
    }

    public void deltaTotalGetTime(long delta) {
        if (this.enabled.get() && delta > 0L) {
            this.totalGetTime.addAndGet(delta);
            this.totalGetTimeInvocations.incrementAndGet();
            if (delta > this.maxGetTime.get()) {
                this.maxGetTime.set(delta);
            }
        }
    }

    @Override
    public long getTotalGetInvocations() {
        if (!this.enabled.get()) {
            return 0L;
        }
        return this.totalGetTimeInvocations.get();
    }

    public int getWaitCount() {
        if (!this.enabled.get()) {
            return 0;
        }
        return this.waitCount.get();
    }

    public void deltaWaitCount() {
        if (this.enabled.get()) {
            this.waitCount.incrementAndGet();
        }
    }

    public void clear() {
        this.createdCount.set(0);
        this.destroyedCount.set(0);
        this.maxCreationTime.set(Long.MIN_VALUE);
        this.maxGetTime.set(Long.MIN_VALUE);
        this.maxUsedCount.set(Integer.MIN_VALUE);
        this.maxWaitCount.set(Integer.MIN_VALUE);
        this.maxWaitTime.set(Long.MIN_VALUE);
        this.timedOut.set(0);
        this.totalBlockingTime.set(0L);
        this.totalBlockingTimeInvocations.set(0L);
        this.totalCreationTime.set(0L);
        this.totalGetTime.set(0L);
        this.totalGetTimeInvocations.set(0L);
        this.inUseCount.set(0);
        this.blockingFailureCount.set(0);
        this.waitCount.set(0);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.maxPoolSize);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init(in.readInt());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ManagedConnectionPoolStatistics@").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append("[");
        sb.append("Enabled=").append(this.isEnabled());
        sb.append(",");
        sb.append(ACTIVE_COUNT).append("=").append(this.getActiveCount());
        sb.append(",");
        sb.append(AVAILABLE_COUNT).append("=").append(this.getAvailableCount());
        sb.append(",");
        sb.append(AVERAGE_BLOCKING_TIME).append("=").append(this.getAverageBlockingTime());
        sb.append(",");
        sb.append(AVERAGE_CREATION_TIME).append("=").append(this.getAverageCreationTime());
        sb.append(",");
        sb.append(AVERAGE_GET_TIME).append("=").append(this.getAverageCreationTime());
        sb.append(",");
        sb.append(BLOCKING_FAILURE_COUNT).append("=").append(this.getBlockingFailureCount());
        sb.append(",");
        sb.append(CREATED_COUNT).append("=").append(this.getCreatedCount());
        sb.append(",");
        sb.append(DESTROYED_COUNT).append("=").append(this.getDestroyedCount());
        sb.append(",");
        sb.append(IDLE_COUNT).append("=").append(this.getIdleCount());
        sb.append(",");
        sb.append(IN_USE_COUNT).append("=").append(this.getInUseCount());
        sb.append(",");
        sb.append(MAX_CREATION_TIME).append("=").append(this.getMaxCreationTime());
        sb.append(",");
        sb.append(MAX_GET_TIME).append("=").append(this.getMaxGetTime());
        sb.append(",");
        sb.append(MAX_USED_COUNT).append("=").append(this.getMaxUsedCount());
        sb.append(",");
        sb.append(MAX_WAIT_COUNT).append("=").append(this.getMaxWaitCount());
        sb.append(",");
        sb.append(MAX_WAIT_TIME).append("=").append(this.getMaxWaitTime());
        sb.append(",");
        sb.append(TIMED_OUT).append("=").append(this.getTimedOut());
        sb.append(",");
        sb.append(TOTAL_BLOCKING_TIME).append("=").append(this.getTotalBlockingTime());
        sb.append(",");
        sb.append(TOTAL_BLOCKING_TIME_INVOCATIONS).append("=").append(this.totalBlockingTimeInvocations.get());
        sb.append(",");
        sb.append(TOTAL_CREATION_TIME).append("=").append(this.getTotalCreationTime());
        sb.append(",");
        sb.append(TOTAL_GET_TIME).append("=").append(this.getTotalGetTime());
        sb.append(",");
        sb.append(TOTAL_GET_TIME_INVOCATIONS).append("=").append(this.totalGetTimeInvocations.get());
        sb.append(",");
        sb.append(WAIT_COUNT).append("=").append(this.getWaitCount());
        sb.append("]");
        return sb.toString();
    }
}

