/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.jberet.services;

import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.enterprise.inject.spi.BeanManager;
import javax.transaction.TransactionManager;
import org.jberet.spi.ArtifactFactory;
import org.jberet.spi.BatchEnvironment;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.jberet.BatchEnvironmentFactory;
import org.wildfly.jberet.WildFlyArtifactFactory;
import org.wildfly.jberet._private.WildFlyBatchLogger;
import org.wildfly.jberet._private.WildFlyBatchMessages;
import org.wildfly.jberet.services.ClassLoaderContextHandle;
import org.wildfly.jberet.services.ContextHandle;
import org.wildfly.jberet.services.NamespaceContextHandle;
import org.wildfly.jberet.services.SecurityContextHandle;
import org.wildfly.security.manager.WildFlySecurityManager;

public class BatchEnvironmentService
implements Service<BatchEnvironment> {
    private final InjectedValue<BeanManager> beanManagerInjector = new InjectedValue();
    private final InjectedValue<ExecutorService> executorServiceInjector = new InjectedValue();
    private final InjectedValue<TransactionManager> transactionManagerInjector = new InjectedValue();
    private BatchEnvironment batchEnvironment = null;
    private Properties properties = null;
    private ClassLoader classLoader = null;

    public synchronized void start(StartContext context) throws StartException {
        WildFlyBatchLogger.LOGGER.debugf("Creating batch environment; %s", this.classLoader);
        WildFlyBatchEnvironment batchEnvironment = new WildFlyBatchEnvironment(this.classLoader, (BeanManager)this.beanManagerInjector.getOptionalValue(), (ExecutorService)this.executorServiceInjector.getValue(), (TransactionManager)this.transactionManagerInjector.getOptionalValue(), this.properties);
        BatchEnvironmentFactory.getInstance().add(this.classLoader, batchEnvironment);
        this.batchEnvironment = batchEnvironment;
    }

    public synchronized void stop(StopContext context) {
        WildFlyBatchLogger.LOGGER.debugf("Removing batch environment; %s", this.classLoader);
        BatchEnvironmentFactory.getInstance().remove(this.classLoader);
        this.properties = null;
        this.classLoader = null;
        this.batchEnvironment = null;
    }

    public synchronized BatchEnvironment getValue() throws IllegalStateException, IllegalArgumentException {
        return this.batchEnvironment;
    }

    public synchronized void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public InjectedValue<BeanManager> getBeanManagerInjector() {
        return this.beanManagerInjector;
    }

    public InjectedValue<ExecutorService> getExecutorServiceInjector() {
        return this.executorServiceInjector;
    }

    public synchronized void setProperties(Properties properties) {
        this.properties = properties;
    }

    public InjectedValue<TransactionManager> getTransactionManagerInjector() {
        return this.transactionManagerInjector;
    }

    private static class WildFlyBatchEnvironment
    implements BatchEnvironment {
        private final ArtifactFactory artifactFactory;
        private final ExecutorService executorService;
        private final TransactionManager transactionManager;
        private final Properties properties;
        private final ClassLoader classLoader;

        WildFlyBatchEnvironment(ClassLoader classLoader, BeanManager beanManager, ExecutorService executorService, TransactionManager transactionManager, Properties properties) {
            this.classLoader = classLoader;
            this.artifactFactory = beanManager == null ? null : new WildFlyArtifactFactory(beanManager);
            this.executorService = executorService;
            this.transactionManager = transactionManager;
            this.properties = properties;
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public ArtifactFactory getArtifactFactory() {
            if (this.artifactFactory == null) {
                throw WildFlyBatchMessages.MESSAGES.serviceNotInstalled("BeanManager");
            }
            return this.artifactFactory;
        }

        public Future<?> submitTask(final Runnable task) {
            final ContextHandle contextHandle = this.createContextHandle();
            return this.executorService.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ContextHandle.Handle handle = contextHandle.setup();
                    try {
                        task.run();
                    }
                    finally {
                        handle.tearDown();
                    }
                }
            });
        }

        public <T> Future<T> submitTask(final Runnable task, T result) {
            final ContextHandle contextHandle = this.createContextHandle();
            return this.executorService.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ContextHandle.Handle handle = contextHandle.setup();
                    try {
                        task.run();
                    }
                    finally {
                        handle.tearDown();
                    }
                }
            }, result);
        }

        public <T> Future<T> submitTask(final Callable<T> task) {
            final ContextHandle contextHandle = this.createContextHandle();
            return this.executorService.submit(new Callable<T>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public T call() throws Exception {
                    ContextHandle.Handle handle = contextHandle.setup();
                    try {
                        Object v = task.call();
                        return v;
                    }
                    finally {
                        handle.tearDown();
                    }
                }
            });
        }

        public TransactionManager getTransactionManager() {
            if (this.transactionManager == null) {
                throw WildFlyBatchMessages.MESSAGES.serviceNotInstalled("TransactionManager");
            }
            return this.transactionManager;
        }

        public Properties getBatchConfigurationProperties() {
            return this.properties;
        }

        private ContextHandle createContextHandle() {
            ClassLoader tccl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
            ClassLoaderContextHandle classLoaderContextHandle = tccl == null ? new ClassLoaderContextHandle(this.classLoader) : new ClassLoaderContextHandle(tccl);
            return new ContextHandle.ChainedContextHandle(classLoaderContextHandle, new NamespaceContextHandle(), new SecurityContextHandle());
        }
    }
}

