/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.invoker;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.TransactionConfiguration;
import org.infinispan.context.Flag;
import org.infinispan.transaction.LockingMode;
import org.jboss.as.clustering.infinispan.invoker.CacheInvoker;

public interface Locator<K, V> {
    public V findValue(K var1);

    public static class LockingFindOperation<K, V>
    extends FindOperation<K, V> {
        public LockingFindOperation(K key) {
            super(key);
        }

        @Override
        public V invoke(Cache<K, V> cache) {
            TransactionConfiguration transaction = cache.getCacheConfiguration().transaction();
            if (transaction.transactionMode().isTransactional() && transaction.lockingMode() == LockingMode.PESSIMISTIC) {
                return super.invoke(cache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_WRITE_LOCK}));
            }
            return super.invoke(cache);
        }
    }

    public static class FindOperation<K, V>
    implements CacheInvoker.Operation<K, V, V> {
        final K key;

        public FindOperation(K key) {
            this.key = key;
        }

        @Override
        public V invoke(Cache<K, V> cache) {
            return (V)cache.get(this.key);
        }
    }
}

