/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.interceptors;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;

public class ShutDownInterceptorFactory
implements InterceptorFactory {
    private static final int SHUTDOWN_FLAG = Integer.MIN_VALUE;
    private static final int INVERSE_SHUTDOWN_FLAG = Integer.MAX_VALUE;
    private static final AtomicIntegerFieldUpdater<ShutDownInterceptorFactory> updater = AtomicIntegerFieldUpdater.newUpdater(ShutDownInterceptorFactory.class, "invocationCount");
    private volatile int invocationCount;
    private final Object lock = new Object();
    private Interceptor interceptor = new Interceptor(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object processInvocation(InterceptorContext context) throws Exception {
            Object object;
            int value;
            int oldValue;
            do {
                if (((oldValue = ShutDownInterceptorFactory.this.invocationCount) & Integer.MIN_VALUE) != 0) {
                    throw EjbMessages.MESSAGES.componentIsShuttingDown();
                }
                value = oldValue + 1;
            } while (!updater.compareAndSet(ShutDownInterceptorFactory.this, oldValue, value));
            try {
                object = context.proceed();
            }
            catch (Throwable throwable) {
                do {
                    boolean shutDown = ((oldValue = ShutDownInterceptorFactory.this.invocationCount) & Integer.MIN_VALUE) != 0;
                    int oldCount = oldValue & Integer.MAX_VALUE;
                    value = oldCount - 1;
                    if (!shutDown) continue;
                    value |= Integer.MIN_VALUE;
                } while (!updater.compareAndSet(ShutDownInterceptorFactory.this, oldValue, value));
                if (value == Integer.MIN_VALUE) {
                    Object object2 = ShutDownInterceptorFactory.this.lock;
                    synchronized (object2) {
                        ShutDownInterceptorFactory.this.lock.notifyAll();
                    }
                }
                throw throwable;
            }
            do {
                boolean shutDown = ((oldValue = ShutDownInterceptorFactory.this.invocationCount) & Integer.MIN_VALUE) != 0;
                int oldCount = oldValue & Integer.MAX_VALUE;
                value = oldCount - 1;
                if (!shutDown) continue;
                value |= Integer.MIN_VALUE;
            } while (!updater.compareAndSet(ShutDownInterceptorFactory.this, oldValue, value));
            if (value == Integer.MIN_VALUE) {
                Object object3 = ShutDownInterceptorFactory.this.lock;
                synchronized (object3) {
                    ShutDownInterceptorFactory.this.lock.notifyAll();
                }
            }
            return object;
        }
    };

    public Interceptor create(InterceptorFactoryContext context) {
        return this.interceptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        int value;
        int oldValue;
        do {
            if ((oldValue = this.invocationCount) != (value = Integer.MIN_VALUE | oldValue)) continue;
            return;
        } while (!updater.compareAndSet(this, oldValue, value));
        Object object = this.lock;
        synchronized (object) {
            value = this.invocationCount;
            while (value != Integer.MIN_VALUE) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                value = this.invocationCount;
                if ((value & Integer.MIN_VALUE) != 0) continue;
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        int value;
        int oldValue;
        do {
            if ((oldValue = this.invocationCount) != (value = Integer.MAX_VALUE & oldValue)) continue;
            return;
        } while (!updater.compareAndSet(this, oldValue, value));
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }
}

