/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.undertow.servlet.spec.ServletOutputStreamImpl;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Locale;
import javax.servlet.DispatcherType;

public class ServletPrintWriter {
    private static final char[] EMPTY_CHAR = new char[0];
    private final ServletOutputStreamImpl outputStream;
    private final String charset;
    private CharsetEncoder charsetEncoder;
    private boolean error = false;
    private boolean closed = false;
    private char[] underflow;

    public ServletPrintWriter(ServletOutputStreamImpl outputStream, String charset) throws UnsupportedEncodingException {
        this.charset = charset;
        this.outputStream = outputStream;
        if (!charset.equalsIgnoreCase("utf-8") && !charset.equalsIgnoreCase("iso-8859-1")) {
            this.createEncoder();
        }
    }

    private void createEncoder() {
        this.charsetEncoder = Charset.forName(this.charset).newEncoder();
        this.charsetEncoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.charsetEncoder.onMalformedInput(CodingErrorAction.REPLACE);
    }

    public void flush() {
        try {
            this.outputStream.flush();
        }
        catch (IOException e) {
            this.error = true;
        }
    }

    public void close() {
        if (this.outputStream.getServletRequestContext().getOriginalRequest().getDispatcherType() == DispatcherType.INCLUDE) {
            return;
        }
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            CharBuffer buffer;
            boolean done = false;
            if (this.underflow == null) {
                buffer = CharBuffer.wrap(EMPTY_CHAR);
            } else {
                buffer = CharBuffer.wrap(this.underflow);
                this.underflow = null;
            }
            if (this.charsetEncoder != null) {
                do {
                    ByteBuffer out;
                    if ((out = this.outputStream.underlyingBuffer()) == null) {
                        this.error = true;
                        return;
                    }
                    CoderResult result = this.charsetEncoder.encode(buffer, out, true);
                    if (result.isOverflow()) {
                        this.outputStream.flushInternal();
                        if (out.remaining() != 0) continue;
                        this.outputStream.close();
                        this.error = true;
                        return;
                    }
                    done = true;
                } while (!done);
            }
            this.outputStream.close();
        }
        catch (IOException e) {
            this.error = true;
        }
    }

    public boolean checkError() {
        return this.error;
    }

    public void write(CharBuffer input) {
        ByteBuffer buffer = this.outputStream.underlyingBuffer();
        if (buffer == null) {
            this.error = true;
            return;
        }
        try {
            CharBuffer cb;
            if (!buffer.hasRemaining()) {
                this.outputStream.flushInternal();
                if (!buffer.hasRemaining()) {
                    this.error = true;
                    return;
                }
            }
            if (this.charsetEncoder == null) {
                int remaining = buffer.remaining();
                boolean ok = true;
                while (input.hasRemaining()) {
                    char c;
                    if (!buffer.hasRemaining()) {
                        this.outputStream.flushInternal();
                    }
                    if ((c = input.get()) > '\u007f') {
                        ok = false;
                        input.position(input.position() - 1);
                        break;
                    }
                    buffer.put((byte)c);
                }
                this.outputStream.updateWritten(remaining - buffer.remaining());
                if (ok) {
                    return;
                }
                this.createEncoder();
            }
            if (this.underflow == null) {
                cb = input;
            } else {
                char[] newArray = new char[this.underflow.length + input.remaining()];
                System.arraycopy(this.underflow, 0, newArray, 0, this.underflow.length);
                input.get(newArray, this.underflow.length, input.remaining());
                cb = CharBuffer.wrap(newArray);
                this.underflow = null;
            }
            int last = -1;
            while (cb.hasRemaining()) {
                int remaining = buffer.remaining();
                CoderResult result = this.charsetEncoder.encode(cb, buffer, false);
                this.outputStream.updateWritten(remaining - buffer.remaining());
                if (result.isOverflow() || !buffer.hasRemaining()) {
                    this.outputStream.flushInternal();
                    if (!buffer.hasRemaining()) {
                        this.error = true;
                        return;
                    }
                }
                if (result.isUnderflow()) {
                    this.underflow = new char[cb.remaining()];
                    cb.get(this.underflow);
                    return;
                }
                if (result.isError()) {
                    this.error = true;
                    return;
                }
                if (result.isUnmappable()) {
                    this.error = true;
                    return;
                }
                if (last == cb.remaining()) {
                    this.underflow = new char[cb.remaining()];
                    cb.get(this.underflow);
                    return;
                }
                last = cb.remaining();
            }
        }
        catch (IOException e) {
            this.error = true;
        }
    }

    public void write(int c) {
        CharBuffer cb = CharBuffer.wrap(Character.toString((char)c));
        this.write(cb);
    }

    public void write(char[] buf, int off, int len) {
        CharBuffer cb = CharBuffer.wrap(buf, off, len);
        this.write(cb);
    }

    public void write(char[] buf) {
        CharBuffer cb = CharBuffer.wrap(buf);
        this.write(cb);
    }

    public void write(String s, int off, int len) {
        CharBuffer cb = CharBuffer.wrap(s, off, off + len);
        this.write(cb);
    }

    public void write(String s) {
        CharBuffer cb = CharBuffer.wrap(s);
        this.write(cb);
    }

    public void print(boolean b) {
        CharBuffer cb = CharBuffer.wrap(Boolean.toString(b));
        this.write(cb);
    }

    public void print(char c) {
        CharBuffer cb = CharBuffer.wrap(Character.toString(c));
        this.write(cb);
    }

    public void print(int i) {
        CharBuffer cb = CharBuffer.wrap(Integer.toString(i));
        this.write(cb);
    }

    public void print(long l) {
        CharBuffer cb = CharBuffer.wrap(Long.toString(l));
        this.write(cb);
    }

    public void print(float f) {
        CharBuffer cb = CharBuffer.wrap(Float.toString(f));
        this.write(cb);
    }

    public void print(double d) {
        CharBuffer cb = CharBuffer.wrap(Double.toString(d));
        this.write(cb);
    }

    public void print(char[] s) {
        CharBuffer cb = CharBuffer.wrap(s);
        this.write(cb);
    }

    public void print(String s) {
        CharBuffer cb = CharBuffer.wrap(s == null ? "null" : s);
        this.write(cb);
    }

    public void print(Object obj) {
        CharBuffer cb = CharBuffer.wrap(obj == null ? "null" : obj.toString());
        this.write(cb);
    }

    public void println() {
        this.print('\n');
    }

    public void println(boolean b) {
        this.print(b);
        this.print('\n');
    }

    public void println(char c) {
        this.print(c);
        this.print('\n');
    }

    public void println(int i) {
        this.print(i);
        this.print('\n');
    }

    public void println(long l) {
        this.print(l);
        this.print('\n');
    }

    public void println(float f) {
        this.print(f);
        this.print('\n');
    }

    public void println(double d) {
        this.print(d);
        this.print('\n');
    }

    public void println(char[] s) {
        this.print(s);
        this.print('\n');
    }

    public void println(String s) {
        this.print(s);
        this.print('\n');
    }

    public void println(Object obj) {
        this.print(obj);
        this.print('\n');
    }

    public void printf(String format, Object ... args) {
        this.print(String.format(format, args));
    }

    public void printf(Locale l, String format, Object ... args) {
        this.print(String.format(l, format, args));
    }

    public void format(String format, Object ... args) {
        this.printf(format, args);
    }

    public void format(Locale l, String format, Object ... args) {
        this.printf(l, format, args);
    }

    public void append(CharSequence csq) {
        if (csq == null) {
            this.write("null");
        } else {
            this.write(csq.toString());
        }
    }

    public void append(CharSequence csq, int start, int end) {
        CharSequence cs = csq == null ? "null" : csq;
        this.write(cs.subSequence(start, end).toString());
    }

    public void append(char c) {
        this.write(c);
    }
}

