/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.mongo.impl.context;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.keycloak.connections.mongo.api.MongoIdentifiableEntity;
import org.keycloak.connections.mongo.api.MongoStore;
import org.keycloak.connections.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.connections.mongo.api.context.MongoTask;

public class TransactionMongoStoreInvocationContext
implements MongoStoreInvocationContext {
    private Map<String, MongoIdentifiableEntity> loadedObjects = new HashMap<String, MongoIdentifiableEntity>();
    private Map<MongoIdentifiableEntity, Set<MongoTask>> pendingUpdateTasks = new HashMap<MongoIdentifiableEntity, Set<MongoTask>>();
    private final MongoStore mongoStore;

    public TransactionMongoStoreInvocationContext(MongoStore mongoStore) {
        this.mongoStore = mongoStore;
    }

    @Override
    public void addCreatedEntity(MongoIdentifiableEntity entity) {
        this.addLoadedEntity(entity);
    }

    @Override
    public void addLoadedEntity(MongoIdentifiableEntity entity) {
        this.loadedObjects.put(entity.getId(), entity);
    }

    @Override
    public <T extends MongoIdentifiableEntity> T getLoadedEntity(Class<T> type, String id) {
        return (T)this.loadedObjects.get(id);
    }

    @Override
    public void addUpdateTask(MongoIdentifiableEntity entityToUpdate, MongoTask task) {
        if (!this.loadedObjects.containsValue(entityToUpdate)) {
            throw new IllegalStateException("Entity " + entityToUpdate + " not found in loaded objects");
        }
        Set<MongoTask> currentObjectTasks = this.pendingUpdateTasks.get(entityToUpdate);
        if (currentObjectTasks == null) {
            currentObjectTasks = new LinkedHashSet<MongoTask>();
            this.pendingUpdateTasks.put(entityToUpdate, currentObjectTasks);
        } else if (task.isFullUpdate()) {
            currentObjectTasks.clear();
        } else {
            for (MongoTask current : currentObjectTasks) {
                if (!current.isFullUpdate()) continue;
                return;
            }
        }
        currentObjectTasks.add(task);
    }

    @Override
    public void addRemovedEntity(MongoIdentifiableEntity entity) {
        this.pendingUpdateTasks.remove(entity);
        this.loadedObjects.remove(entity.getId());
        entity.afterRemove(this);
    }

    @Override
    public void beforeDBSearch(Class<? extends MongoIdentifiableEntity> entityType) {
        HashSet<MongoIdentifiableEntity> toRemove = new HashSet<MongoIdentifiableEntity>();
        for (MongoIdentifiableEntity currentEntity : this.pendingUpdateTasks.keySet()) {
            if (!currentEntity.getClass().equals(entityType)) continue;
            Set<MongoTask> mongoTasks = this.pendingUpdateTasks.get(currentEntity);
            for (MongoTask currentTask : mongoTasks) {
                currentTask.execute();
            }
            toRemove.add(currentEntity);
        }
        for (MongoIdentifiableEntity entity : toRemove) {
            this.pendingUpdateTasks.remove(entity);
        }
    }

    @Override
    public void begin() {
        this.loadedObjects.clear();
        this.pendingUpdateTasks.clear();
    }

    @Override
    public void commit() {
        for (Set<MongoTask> mongoTasks : this.pendingUpdateTasks.values()) {
            for (MongoTask currentTask : mongoTasks) {
                currentTask.execute();
            }
        }
        this.loadedObjects.clear();
        this.pendingUpdateTasks.clear();
    }

    @Override
    public void rollback() {
        this.loadedObjects.clear();
        this.pendingUpdateTasks.clear();
    }

    @Override
    public MongoStore getMongoStore() {
        return this.mongoStore;
    }
}

