/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.taxonomy.directory;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.lucene.facet.taxonomy.TaxonomyWriter;
import org.apache.lucene.facet.taxonomy.directory.Consts;
import org.apache.lucene.facet.taxonomy.directory.ParentArray;
import org.apache.lucene.facet.taxonomy.writercache.TaxonomyWriterCache;
import org.apache.lucene.facet.taxonomy.writercache.cl2o.Cl2oTaxonomyWriterCache;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LogByteSizeMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TieredMergePolicy;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryTaxonomyWriter
implements TaxonomyWriter {
    public static final String INDEX_CREATE_TIME = "index.create.time";
    private IndexWriter indexWriter;
    private int nextID;
    private char delimiter = (char)63305;
    private SinglePositionTokenStream parentStream = new SinglePositionTokenStream("p");
    private Field parentStreamField;
    private Field fullPathField;
    private TaxonomyWriterCache cache;
    private boolean cacheIsComplete;
    private IndexReader reader;
    private int cacheMisses;
    private final String createTime;
    private boolean alreadyCalledFillCache = false;
    private int cacheMissesUntilFill = 11;
    private ParentArray parentArray;

    private static Map<String, String> readCommitData(Directory dir) throws IOException {
        SegmentInfos infos = new SegmentInfos();
        infos.read(dir);
        return infos.getUserData();
    }

    public void setDelimiter(char delimiter) {
        this.ensureOpen();
        this.delimiter = delimiter;
    }

    public static void unlock(Directory directory) throws IOException {
        IndexWriter.unlock((Directory)directory);
    }

    public DirectoryTaxonomyWriter(Directory directory, IndexWriterConfig.OpenMode openMode, TaxonomyWriterCache cache) throws IOException {
        Map<String, String> commitData;
        this.createTime = !IndexReader.indexExists((Directory)directory) || openMode == IndexWriterConfig.OpenMode.CREATE ? Long.toString(System.nanoTime()) : ((commitData = DirectoryTaxonomyWriter.readCommitData(directory)) != null ? commitData.get(INDEX_CREATE_TIME) : null);
        IndexWriterConfig config = this.createIndexWriterConfig(openMode);
        this.indexWriter = this.openIndexWriter(directory, config);
        assert (!(this.indexWriter.getConfig().getMergePolicy() instanceof TieredMergePolicy)) : "for preserving category docids, merging none-adjacent segments is not allowed";
        this.reader = null;
        this.parentStreamField = new Field("$payloads$", (TokenStream)this.parentStream);
        this.parentStreamField.setOmitNorms(true);
        this.fullPathField = new Field("$full_path$", "", Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS);
        this.fullPathField.setIndexOptions(FieldInfo.IndexOptions.DOCS_ONLY);
        this.nextID = this.indexWriter.maxDoc();
        if (cache == null) {
            cache = DirectoryTaxonomyWriter.defaultTaxonomyWriterCache();
        }
        this.cache = cache;
        if (this.nextID == 0) {
            this.cacheIsComplete = true;
            this.addCategory(new CategoryPath());
            this.refreshReader();
        } else {
            this.cacheIsComplete = false;
        }
        this.cacheMisses = 0;
    }

    protected IndexWriter openIndexWriter(Directory directory, IndexWriterConfig config) throws IOException {
        return new IndexWriter(directory, config);
    }

    protected IndexWriterConfig createIndexWriterConfig(IndexWriterConfig.OpenMode openMode) {
        return new IndexWriterConfig(Version.LUCENE_36, (Analyzer)new KeywordAnalyzer()).setOpenMode(openMode).setMergePolicy((MergePolicy)new LogByteSizeMergePolicy());
    }

    protected IndexReader openReader() throws IOException {
        return IndexReader.open((IndexWriter)this.indexWriter, (boolean)true);
    }

    public DirectoryTaxonomyWriter(Directory directory, IndexWriterConfig.OpenMode openMode) throws CorruptIndexException, LockObtainFailedException, IOException {
        this(directory, openMode, DirectoryTaxonomyWriter.defaultTaxonomyWriterCache());
    }

    public static TaxonomyWriterCache defaultTaxonomyWriterCache() {
        return new Cl2oTaxonomyWriterCache(1024, 0.15f, 3);
    }

    public DirectoryTaxonomyWriter(Directory d) throws CorruptIndexException, LockObtainFailedException, IOException {
        this(d, IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
    }

    @Override
    public synchronized void close() throws CorruptIndexException, IOException {
        if (this.indexWriter != null) {
            this.indexWriter.commit(this.combinedCommitData(null));
            this.doClose();
        }
    }

    private void doClose() throws CorruptIndexException, IOException {
        this.indexWriter.close();
        this.indexWriter = null;
        this.closeResources();
    }

    public int getCacheMemoryUsage() {
        this.ensureOpen();
        if (this.cache == null || !(this.cache instanceof Cl2oTaxonomyWriterCache)) {
            return 0;
        }
        return ((Cl2oTaxonomyWriterCache)this.cache).getMemoryUsage();
    }

    protected synchronized void closeResources() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
        if (this.cache != null) {
            this.cache.close();
            this.cache = null;
        }
    }

    protected int findCategory(CategoryPath categoryPath) throws IOException {
        TermDocs docs;
        int res = this.cache.get(categoryPath);
        if (res >= 0) {
            return res;
        }
        if (this.cacheIsComplete) {
            return -1;
        }
        ++this.cacheMisses;
        if (this.perhapsFillCache()) {
            return this.cache.get(categoryPath);
        }
        if (this.reader == null) {
            this.reader = this.openReader();
        }
        if (!(docs = this.reader.termDocs(Consts.FULL_TERM.createTerm(categoryPath.toString(this.delimiter)))).next()) {
            return -1;
        }
        this.addToCache(categoryPath, docs.doc());
        return docs.doc();
    }

    private int findCategory(CategoryPath categoryPath, int prefixLen) throws IOException {
        TermDocs docs;
        int res = this.cache.get(categoryPath, prefixLen);
        if (res >= 0) {
            return res;
        }
        if (this.cacheIsComplete) {
            return -1;
        }
        ++this.cacheMisses;
        if (this.perhapsFillCache()) {
            return this.cache.get(categoryPath, prefixLen);
        }
        if (this.reader == null) {
            this.reader = this.openReader();
        }
        if (!(docs = this.reader.termDocs(Consts.FULL_TERM.createTerm(categoryPath.toString(this.delimiter, prefixLen)))).next()) {
            return -1;
        }
        this.addToCache(categoryPath, prefixLen, docs.doc());
        return docs.doc();
    }

    @Override
    public synchronized int addCategory(CategoryPath categoryPath) throws IOException {
        this.ensureOpen();
        int res = this.findCategory(categoryPath);
        if (res < 0) {
            res = this.internalAddCategory(categoryPath, categoryPath.length());
        }
        return res;
    }

    private int internalAddCategory(CategoryPath categoryPath, int length) throws CorruptIndexException, IOException {
        int parent;
        if (length > 1) {
            parent = this.findCategory(categoryPath, length - 1);
            if (parent < 0) {
                parent = this.internalAddCategory(categoryPath, length - 1);
            }
        } else {
            parent = length == 1 ? 0 : -1;
        }
        int id = this.addCategoryDocument(categoryPath, length, parent);
        return id;
    }

    protected final void ensureOpen() {
        if (this.indexWriter == null) {
            throw new AlreadyClosedException("The taxonomy writer has already been closed");
        }
    }

    protected synchronized int addCategoryDocument(CategoryPath categoryPath, int length, int parent) throws CorruptIndexException, IOException {
        this.parentStream.set(parent + 1);
        Document d = new Document();
        d.add((Fieldable)this.parentStreamField);
        this.fullPathField.setValue(categoryPath.toString(this.delimiter, length));
        d.add((Fieldable)this.fullPathField);
        this.indexWriter.addDocument(d);
        int id = this.nextID++;
        this.addToCache(categoryPath, length, id);
        this.getParentArray().add(id, parent);
        return id;
    }

    private void addToCache(CategoryPath categoryPath, int id) throws CorruptIndexException, IOException {
        if (this.cache.put(categoryPath, id)) {
            this.refreshReader();
            this.cacheIsComplete = false;
        }
    }

    private void addToCache(CategoryPath categoryPath, int prefixLen, int id) throws CorruptIndexException, IOException {
        if (this.cache.put(categoryPath, prefixLen, id)) {
            this.refreshReader();
            this.cacheIsComplete = false;
        }
    }

    private synchronized void refreshReader() throws IOException {
        IndexReader r2;
        if (this.reader != null && (r2 = IndexReader.openIfChanged((IndexReader)this.reader)) != null) {
            this.reader.close();
            this.reader = r2;
        }
    }

    public synchronized void commit() throws CorruptIndexException, IOException {
        this.ensureOpen();
        this.indexWriter.commit(this.combinedCommitData(null));
        this.refreshReader();
    }

    private Map<String, String> combinedCommitData(Map<String, String> userData) {
        HashMap<String, String> m = new HashMap<String, String>();
        if (userData != null) {
            m.putAll(userData);
        }
        if (this.createTime != null) {
            m.put(INDEX_CREATE_TIME, this.createTime);
        }
        return m;
    }

    public synchronized void commit(Map<String, String> commitUserData) throws CorruptIndexException, IOException {
        this.ensureOpen();
        this.indexWriter.commit(this.combinedCommitData(commitUserData));
        this.refreshReader();
    }

    public synchronized void prepareCommit() throws CorruptIndexException, IOException {
        this.ensureOpen();
        this.indexWriter.prepareCommit(this.combinedCommitData(null));
    }

    public synchronized void prepareCommit(Map<String, String> commitUserData) throws CorruptIndexException, IOException {
        this.ensureOpen();
        this.indexWriter.prepareCommit(this.combinedCommitData(commitUserData));
    }

    @Override
    public synchronized int getSize() {
        this.ensureOpen();
        return this.indexWriter.maxDoc();
    }

    public void setCacheMissesUntilFill(int i) {
        this.ensureOpen();
        this.cacheMissesUntilFill = i;
    }

    private boolean perhapsFillCache() throws IOException {
        if (this.cacheMisses < this.cacheMissesUntilFill) {
            return false;
        }
        if (this.alreadyCalledFillCache) {
            return false;
        }
        this.alreadyCalledFillCache = true;
        if (this.reader == null) {
            this.reader = this.openReader();
        }
        if (!this.cache.hasRoom(this.reader.numDocs())) {
            return false;
        }
        CategoryPath cp = new CategoryPath();
        TermDocs td = this.reader.termDocs();
        String field = Consts.FULL_TERM.field();
        TermEnum terms = this.reader.terms(Consts.FULL_TERM);
        if (terms.term() != null) {
            Term t;
            while ((t = terms.term()).field() == field) {
                td.seek(t);
                td.next();
                cp.clear();
                cp.add(t.text(), this.delimiter);
                this.cache.put(cp, td.doc());
                if (terms.next()) continue;
            }
        }
        this.cacheIsComplete = true;
        this.reader.close();
        this.reader = null;
        return true;
    }

    private synchronized ParentArray getParentArray() throws IOException {
        if (this.parentArray == null) {
            if (this.reader == null) {
                this.reader = this.openReader();
            }
            this.parentArray = new ParentArray();
            this.parentArray.refresh(this.reader);
        }
        return this.parentArray;
    }

    @Override
    public int getParent(int ordinal) throws IOException {
        this.ensureOpen();
        if (ordinal >= this.getSize()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.getParentArray().getArray()[ordinal];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTaxonomy(Directory taxoDir, OrdinalMap map) throws IOException {
        this.ensureOpen();
        IndexReader r = IndexReader.open((Directory)taxoDir);
        try {
            Term term;
            int size = r.numDocs();
            OrdinalMap ordinalMap = map;
            ordinalMap.setSize(size);
            CategoryPath cp = new CategoryPath();
            TermEnum te = r.terms(Consts.FULL_TERM);
            TermDocs docs = r.termDocs();
            while (te.next() && (term = te.term()).field() == "$full_path$") {
                cp.clear();
                cp.add(term.text(), '\uf749');
                int ordinal = this.addCategory(cp);
                docs.seek(term);
                docs.next();
                ordinalMap.addMapping(docs.doc(), ordinal);
            }
            ordinalMap.addMapping(0, 0);
            ordinalMap.addDone();
        }
        finally {
            r.close();
        }
    }

    public void rollback() throws IOException {
        this.ensureOpen();
        this.indexWriter.rollback();
        this.doClose();
    }

    public static final class DiskOrdinalMap
    implements OrdinalMap {
        File tmpfile;
        DataOutputStream out;
        int[] map = null;

        public DiskOrdinalMap(File tmpfile) throws FileNotFoundException {
            this.tmpfile = tmpfile;
            this.out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(tmpfile)));
        }

        public void addMapping(int origOrdinal, int newOrdinal) throws IOException {
            this.out.writeInt(origOrdinal);
            this.out.writeInt(newOrdinal);
        }

        public void setSize(int taxonomySize) throws IOException {
            this.out.writeInt(taxonomySize);
        }

        public void addDone() throws IOException {
            if (this.out != null) {
                this.out.close();
                this.out = null;
            }
        }

        public int[] getMap() throws IOException {
            if (this.map != null) {
                return this.map;
            }
            this.addDone();
            DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(this.tmpfile)));
            this.map = new int[in.readInt()];
            for (int i = 0; i < this.map.length; ++i) {
                int newordinal;
                int origordinal = in.readInt();
                this.map[origordinal] = newordinal = in.readInt();
            }
            in.close();
            if (!this.tmpfile.delete()) {
                this.tmpfile.deleteOnExit();
            }
            return this.map;
        }
    }

    public static final class MemoryOrdinalMap
    implements OrdinalMap {
        int[] map;

        public void setSize(int taxonomySize) {
            this.map = new int[taxonomySize];
        }

        public void addMapping(int origOrdinal, int newOrdinal) {
            this.map[origOrdinal] = newOrdinal;
        }

        public void addDone() {
        }

        public int[] getMap() {
            return this.map;
        }
    }

    public static interface OrdinalMap {
        public void setSize(int var1) throws IOException;

        public void addMapping(int var1, int var2) throws IOException;

        public void addDone() throws IOException;

        public int[] getMap() throws IOException;
    }

    private static class SinglePositionTokenStream
    extends TokenStream {
        private CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        private PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
        private boolean returned;

        public SinglePositionTokenStream(String word) {
            this.termAtt.setEmpty().append(word);
            this.returned = true;
        }

        public void set(int val) {
            this.posIncrAtt.setPositionIncrement(val);
            this.returned = false;
        }

        public boolean incrementToken() throws IOException {
            if (this.returned) {
                return false;
            }
            this.returned = true;
            return true;
        }
    }
}

