/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.encoding;

import io.undertow.predicate.Predicate;
import io.undertow.predicate.Predicates;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.encoding.AllowedContentEncodings;
import io.undertow.server.handlers.encoding.ContentEncodingProvider;
import io.undertow.server.handlers.encoding.EncodingMapping;
import io.undertow.util.CopyOnWriteMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.QValueParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ContentEncodingRepository {
    public static final String IDENTITY = "identity";
    private final Map<String, EncodingMapping> encodingMap = new CopyOnWriteMap<String, EncodingMapping>();

    public AllowedContentEncodings getContentEncodings(HttpServerExchange exchange) {
        HeaderValues res = exchange.getRequestHeaders().get(Headers.ACCEPT_ENCODING);
        if (res == null || res.isEmpty()) {
            return null;
        }
        ArrayList<EncodingMapping> resultingMappings = new ArrayList<EncodingMapping>();
        List<List<QValueParser.QValueResult>> found = QValueParser.parse(res);
        for (List<QValueParser.QValueResult> result : found) {
            ArrayList<EncodingMapping> available = new ArrayList<EncodingMapping>();
            boolean includesIdentity = false;
            boolean isQValue0 = false;
            for (QValueParser.QValueResult value : result) {
                EncodingMapping encoding;
                if (value.getValue().equals("*")) {
                    includesIdentity = true;
                    encoding = new EncodingMapping(IDENTITY, ContentEncodingProvider.IDENTITY, 0, Predicates.truePredicate());
                } else {
                    encoding = this.encodingMap.get(value.getValue());
                }
                if (value.isQValueZero()) {
                    isQValue0 = true;
                }
                if (encoding == null) continue;
                available.add(encoding);
            }
            if (isQValue0) {
                if (!resultingMappings.isEmpty()) continue;
                if (includesIdentity) {
                    return new AllowedContentEncodings(exchange, Collections.<EncodingMapping>emptyList());
                }
                return null;
            }
            if (available.isEmpty()) continue;
            Collections.sort(available, Collections.reverseOrder());
            resultingMappings.addAll(available);
        }
        if (!resultingMappings.isEmpty()) {
            return new AllowedContentEncodings(exchange, resultingMappings);
        }
        return null;
    }

    public synchronized ContentEncodingRepository addEncodingHandler(String encoding, ContentEncodingProvider encoder, int priority) {
        this.addEncodingHandler(encoding, encoder, priority, Predicates.truePredicate());
        return this;
    }

    public synchronized ContentEncodingRepository addEncodingHandler(String encoding, ContentEncodingProvider encoder, int priority, Predicate enabledPredicate) {
        this.encodingMap.put(encoding, new EncodingMapping(encoding, encoder, priority, enabledPredicate));
        return this;
    }

    public synchronized ContentEncodingRepository removeEncodingHandler(String encoding) {
        this.encodingMap.remove(encoding);
        return this;
    }
}

