/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection.producer;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Collection;
import java.util.List;
import javax.enterprise.inject.spi.AnnotatedMethod;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.injection.producer.Instantiator;
import org.jboss.weld.injection.producer.LifecycleCallbackInvoker;
import org.jboss.weld.interceptor.util.InterceptionUtils;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.security.GetAccessibleCopyOfMember;
import org.jboss.weld.util.BeanMethods;

public class DefaultLifecycleCallbackInvoker<T>
implements LifecycleCallbackInvoker<T> {
    private static final Function<AnnotatedMethod<?>, Method> ACCESSIBLE_METHOD_FUNCTION = new Function<AnnotatedMethod<?>, Method>(){

        public Method apply(AnnotatedMethod<?> method) {
            return AccessController.doPrivileged(new GetAccessibleCopyOfMember<Method>(method.getJavaMember()));
        }
    };
    private final List<Method> accessiblePostConstructMethods;
    private final List<Method> accessiblePreDestroyMethods;

    public DefaultLifecycleCallbackInvoker(EnhancedAnnotatedType<T> type) {
        this.accessiblePostConstructMethods = this.initMethodList(BeanMethods.getPostConstructMethods(type));
        this.accessiblePreDestroyMethods = this.initMethodList(BeanMethods.getPreDestroyMethods(type));
    }

    private List<Method> initMethodList(List<? extends AnnotatedMethod<?>> methods) {
        return ImmutableList.copyOf((Collection)Lists.transform(methods, ACCESSIBLE_METHOD_FUNCTION));
    }

    @Override
    public void postConstruct(T instance, Instantiator<T> instantiator) {
        if (instantiator != null && instantiator.hasInterceptorSupport()) {
            InterceptionUtils.executePostConstruct(instance);
        } else {
            this.invokeMethods(this.accessiblePostConstructMethods, instance);
        }
    }

    @Override
    public void preDestroy(T instance, Instantiator<T> instantiator) {
        if (instantiator != null && instantiator.hasInterceptorSupport()) {
            InterceptionUtils.executePredestroy(instance);
        } else {
            this.invokeMethods(this.accessiblePreDestroyMethods, instance);
        }
    }

    private void invokeMethods(List<Method> methods, T instance) {
        for (Method method : methods) {
            try {
                method.invoke(instance, new Object[0]);
            }
            catch (Exception e) {
                throw BeanLogger.LOG.invocationError(method, instance, e);
            }
        }
    }

    @Override
    public boolean hasPreDestroyMethods() {
        return !this.accessiblePreDestroyMethods.isEmpty();
    }

    @Override
    public boolean hasPostConstructMethods() {
        return !this.accessiblePostConstructMethods.isEmpty();
    }
}

