/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.social;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;

public class UriBuilder {
    private StringBuilder sb;
    private char sep;

    public static UriBuilder create(String path) {
        StringBuilder sb = new StringBuilder();
        sb.append(path);
        UriBuilder builder = new UriBuilder();
        builder.sb = sb;
        return builder;
    }

    public UriBuilder setQueryParam(String name, String value) {
        try {
            if (this.sep == '?') {
                this.sb.append(this.sep);
                this.sep = (char)38;
            } else {
                this.sb.append(this.sep);
            }
            this.sb.append(URLEncoder.encode(name, "UTF-8"));
            this.sb.append("=");
            this.sb.append(URLEncoder.encode(value, "UTF-8"));
            return this;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public URI build() {
        try {
            return new URI(this.sb.toString());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

