/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.ds.v11;

import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.jca.common.api.metadata.Defaults;
import org.jboss.jca.common.api.metadata.common.FlushStrategy;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.ds.DataSource;
import org.jboss.jca.common.api.metadata.ds.DataSources;
import org.jboss.jca.common.api.metadata.ds.DsSecurity;
import org.jboss.jca.common.api.metadata.ds.Statement;
import org.jboss.jca.common.api.metadata.ds.TimeOut;
import org.jboss.jca.common.api.metadata.ds.TransactionIsolation;
import org.jboss.jca.common.api.metadata.ds.Validation;
import org.jboss.jca.common.api.metadata.ds.XaDataSource;
import org.jboss.jca.common.api.metadata.ds.v11.DataSource;
import org.jboss.jca.common.api.metadata.ds.v11.DsPool;
import org.jboss.jca.common.api.metadata.ds.v11.DsXaPool;
import org.jboss.jca.common.api.metadata.ds.v11.XaDataSource;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.MetadataParser;
import org.jboss.jca.common.metadata.ParserException;
import org.jboss.jca.common.metadata.ds.v11.DataSourceImpl;
import org.jboss.jca.common.metadata.ds.v11.DsPoolImpl;
import org.jboss.jca.common.metadata.ds.v11.DsXaPoolImpl;
import org.jboss.jca.common.metadata.ds.v11.XADataSourceImpl;

public class DsParser
extends org.jboss.jca.common.metadata.ds.v10.DsParser
implements MetadataParser<DataSources> {
    @Override
    protected XaDataSource parseXADataSource(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        TransactionIsolation transactionIsolation = null;
        HashMap<String, String> xaDataSourceProperty = new HashMap<String, String>();
        TimeOut timeOutSettings = null;
        DsSecurity securitySettings = null;
        Statement statementSettings = null;
        Validation validationSettings = null;
        String urlDelimiter = null;
        String urlSelectorStrategyClassName = null;
        String newConnectionSql = null;
        DsXaPool xaPool = null;
        Recovery recovery = null;
        String xaDataSourceClass = null;
        String driver = null;
        Boolean useJavaContext = Defaults.USE_JAVA_CONTEXT;
        String poolName = null;
        Boolean enabled = Defaults.ENABLED;
        String jndiName = null;
        Boolean spy = Defaults.SPY;
        Boolean useCcm = Defaults.USE_CCM;
        block27: for (XaDataSource.Attribute attribute : XaDataSource.Attribute.values()) {
            switch (attribute) {
                case ENABLED: {
                    enabled = this.attributeAsBoolean(reader, attribute.getLocalName(), true);
                    continue block27;
                }
                case JNDI_NAME: {
                    jndiName = this.attributeAsString(reader, attribute.getLocalName());
                    continue block27;
                }
                case POOL_NAME: {
                    poolName = this.attributeAsString(reader, attribute.getLocalName());
                    continue block27;
                }
                case USE_JAVA_CONTEXT: {
                    useJavaContext = this.attributeAsBoolean(reader, attribute.getLocalName(), true);
                    continue block27;
                }
                case SPY: {
                    spy = this.attributeAsBoolean(reader, attribute.getLocalName(), false);
                    continue block27;
                }
                case USE_CCM: {
                    useCcm = this.attributeAsBoolean(reader, attribute.getLocalName(), true);
                    continue block27;
                }
            }
        }
        while (reader.hasNext()) {
            block8 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSources.Tag.forName((String)reader.getLocalName()) == DataSources.Tag.XA_DATASOURCE) {
                        return new XADataSourceImpl(transactionIsolation, timeOutSettings, securitySettings, statementSettings, validationSettings, urlDelimiter, urlSelectorStrategyClassName, useJavaContext, poolName, enabled, jndiName, spy, useCcm, xaDataSourceProperty, xaDataSourceClass, driver, newConnectionSql, xaPool, recovery);
                    }
                    if (XaDataSource.Tag.forName((String)reader.getLocalName()) != XaDataSource.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (XaDataSource.Tag.forName((String)reader.getLocalName())) {
                        case XA_DATASOURCE_PROPERTY: {
                            this.parseConfigProperty(xaDataSourceProperty, reader);
                            break block8;
                        }
                        case XA_DATASOURCE_CLASS: {
                            xaDataSourceClass = this.elementAsString(reader);
                            break block8;
                        }
                        case DRIVER: {
                            driver = this.elementAsString(reader);
                            break block8;
                        }
                        case XA_POOL: {
                            xaPool = this.parseXaPool(reader);
                            break block8;
                        }
                        case NEW_CONNECTION_SQL: {
                            newConnectionSql = this.elementAsString(reader);
                            break block8;
                        }
                        case URL_DELIMITER: {
                            urlDelimiter = this.elementAsString(reader);
                            break block8;
                        }
                        case URL_SELECTOR_STRATEGY_CLASS_NAME: {
                            urlSelectorStrategyClassName = this.elementAsString(reader);
                            break block8;
                        }
                        case TRANSACTION_ISOLATION: {
                            String str = this.elementAsString(reader);
                            transactionIsolation = TransactionIsolation.forName((String)str);
                            if (transactionIsolation != null) break block8;
                            transactionIsolation = TransactionIsolation.customLevel((String)str);
                            break block8;
                        }
                        case SECURITY: {
                            securitySettings = this.parseDsSecurity(reader);
                            break block8;
                        }
                        case STATEMENT: {
                            statementSettings = this.parseStatementSettings(reader);
                            break block8;
                        }
                        case TIMEOUT: {
                            timeOutSettings = this.parseTimeOutSettings(reader);
                            break block8;
                        }
                        case VALIDATION: {
                            validationSettings = this.parseValidationSetting(reader);
                            break block8;
                        }
                        case RECOVERY: {
                            recovery = this.parseRecovery(reader);
                            break block8;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    @Override
    protected DataSource parseDataSource(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        String connectionUrl = null;
        String driverClass = null;
        String dataSourceClass = null;
        String driver = null;
        TransactionIsolation transactionIsolation = null;
        HashMap<String, String> connectionProperties = new HashMap<String, String>();
        TimeOut timeOutSettings = null;
        DsSecurity securitySettings = null;
        Statement statementSettings = null;
        Validation validationSettings = null;
        String urlDelimiter = null;
        String urlSelectorStrategyClassName = null;
        String newConnectionSql = null;
        DsPool pool = null;
        Boolean useJavaContext = Defaults.USE_JAVA_CONTEXT;
        String poolName = null;
        Boolean enabled = Defaults.ENABLED;
        String jndiName = null;
        Boolean spy = Defaults.SPY;
        Boolean useCcm = Defaults.USE_CCM;
        Boolean jta = Defaults.JTA;
        block29: for (DataSource.Attribute attribute : DataSource.Attribute.values()) {
            switch (attribute) {
                case ENABLED: {
                    enabled = this.attributeAsBoolean(reader, attribute.getLocalName(), true);
                    continue block29;
                }
                case JNDI_NAME: {
                    jndiName = this.attributeAsString(reader, attribute.getLocalName());
                    continue block29;
                }
                case POOL_NAME: {
                    poolName = this.attributeAsString(reader, attribute.getLocalName());
                    continue block29;
                }
                case USE_JAVA_CONTEXT: {
                    useJavaContext = this.attributeAsBoolean(reader, attribute.getLocalName(), true);
                    continue block29;
                }
                case SPY: {
                    spy = this.attributeAsBoolean(reader, attribute.getLocalName(), false);
                    continue block29;
                }
                case USE_CCM: {
                    useCcm = this.attributeAsBoolean(reader, attribute.getLocalName(), true);
                    continue block29;
                }
                case JTA: {
                    jta = this.attributeAsBoolean(reader, attribute.getLocalName(), true);
                    continue block29;
                }
            }
        }
        while (reader.hasNext()) {
            block9 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSources.Tag.forName((String)reader.getLocalName()) == DataSources.Tag.DATASOURCE) {
                        return new DataSourceImpl(connectionUrl, driverClass, dataSourceClass, driver, transactionIsolation, connectionProperties, timeOutSettings, securitySettings, statementSettings, validationSettings, urlDelimiter, urlSelectorStrategyClassName, newConnectionSql, useJavaContext, poolName, enabled, jndiName, spy, useCcm, jta, pool);
                    }
                    if (DataSource.Tag.forName((String)reader.getLocalName()) != DataSource.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (DataSource.Tag.forName((String)reader.getLocalName())) {
                        case CONNECTION_PROPERTY: {
                            this.parseConfigProperty(connectionProperties, reader);
                            break block9;
                        }
                        case CONNECTION_URL: {
                            connectionUrl = this.elementAsString(reader);
                            break block9;
                        }
                        case DRIVER_CLASS: {
                            driverClass = this.elementAsString(reader);
                            break block9;
                        }
                        case DATASOURCE_CLASS: {
                            dataSourceClass = this.elementAsString(reader);
                            break block9;
                        }
                        case DRIVER: {
                            driver = this.elementAsString(reader);
                            break block9;
                        }
                        case POOL: {
                            pool = this.parsePool(reader);
                            break block9;
                        }
                        case NEW_CONNECTION_SQL: {
                            newConnectionSql = this.elementAsString(reader);
                            break block9;
                        }
                        case URL_DELIMITER: {
                            urlDelimiter = this.elementAsString(reader);
                            break block9;
                        }
                        case URL_SELECTOR_STRATEGY_CLASS_NAME: {
                            urlSelectorStrategyClassName = this.elementAsString(reader);
                            break block9;
                        }
                        case TRANSACTION_ISOLATION: {
                            String str = this.elementAsString(reader);
                            transactionIsolation = TransactionIsolation.forName((String)str);
                            if (transactionIsolation != null) break block9;
                            transactionIsolation = TransactionIsolation.customLevel((String)str);
                            break block9;
                        }
                        case SECURITY: {
                            securitySettings = this.parseDsSecurity(reader);
                            break block9;
                        }
                        case STATEMENT: {
                            statementSettings = this.parseStatementSettings(reader);
                            break block9;
                        }
                        case TIMEOUT: {
                            timeOutSettings = this.parseTimeOutSettings(reader);
                            break block9;
                        }
                        case VALIDATION: {
                            validationSettings = this.parseValidationSetting(reader);
                            break block9;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected DsPool parsePool(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        Integer minPoolSize = Defaults.MIN_POOL_SIZE;
        Integer maxPoolSize = Defaults.MAX_POOL_SIZE;
        Boolean prefill = Defaults.PREFILL;
        Boolean useStrictMin = Defaults.USE_STRICT_MIN;
        FlushStrategy flushStrategy = Defaults.FLUSH_STRATEGY;
        Boolean allowMultipleUsers = Defaults.ALLOW_MULTIPLE_USERS;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName((String)reader.getLocalName()) == DataSource.Tag.POOL) {
                        return new DsPoolImpl(minPoolSize, maxPoolSize, prefill, useStrictMin, flushStrategy, allowMultipleUsers);
                    }
                    if (DsPool.Tag.forName((String)reader.getLocalName()) != DsPool.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (DsPool.Tag.forName((String)reader.getLocalName())) {
                        case MAX_POOL_SIZE: {
                            maxPoolSize = this.elementAsInteger(reader);
                            break block0;
                        }
                        case MIN_POOL_SIZE: {
                            minPoolSize = this.elementAsInteger(reader);
                            break block0;
                        }
                        case PREFILL: {
                            prefill = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case USE_STRICT_MIN: {
                            useStrictMin = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case FLUSH_STRATEGY: {
                            flushStrategy = this.elementAsFlushStrategy(reader);
                            break block0;
                        }
                        case ALLOW_MULTIPLE_USERS: {
                            allowMultipleUsers = Boolean.TRUE;
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected DsXaPool parseXaPool(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        Integer minPoolSize = Defaults.MIN_POOL_SIZE;
        Integer maxPoolSize = Defaults.MAX_POOL_SIZE;
        Boolean prefill = Defaults.PREFILL;
        FlushStrategy flushStrategy = Defaults.FLUSH_STRATEGY;
        Boolean allowMultipleUsers = Defaults.ALLOW_MULTIPLE_USERS;
        Boolean interleaving = Defaults.INTERLEAVING;
        Boolean isSameRmOverride = Defaults.IS_SAME_RM_OVERRIDE;
        Boolean padXid = Defaults.PAD_XID;
        Boolean noTxSeparatePool = Defaults.NO_TX_SEPARATE_POOL;
        Boolean wrapXaDataSource = Defaults.WRAP_XA_RESOURCE;
        Boolean useStrictMin = Defaults.USE_STRICT_MIN;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (XaDataSource.Tag.forName((String)reader.getLocalName()) == XaDataSource.Tag.XA_POOL) {
                        return new DsXaPoolImpl(minPoolSize, maxPoolSize, prefill, useStrictMin, flushStrategy, isSameRmOverride, interleaving, padXid, wrapXaDataSource, noTxSeparatePool, allowMultipleUsers);
                    }
                    if (DsXaPool.Tag.forName((String)reader.getLocalName()) != DsXaPool.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (DsXaPool.Tag.forName((String)reader.getLocalName())) {
                        case MAX_POOL_SIZE: {
                            maxPoolSize = this.elementAsInteger(reader);
                            break block0;
                        }
                        case MIN_POOL_SIZE: {
                            minPoolSize = this.elementAsInteger(reader);
                            break block0;
                        }
                        case INTERLEAVING: {
                            interleaving = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case IS_SAME_RM_OVERRIDE: {
                            isSameRmOverride = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case NO_TX_SEPARATE_POOLS: {
                            noTxSeparatePool = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case PAD_XID: {
                            padXid = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case WRAP_XA_RESOURCE: {
                            wrapXaDataSource = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case PREFILL: {
                            prefill = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case USE_STRICT_MIN: {
                            useStrictMin = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case FLUSH_STRATEGY: {
                            flushStrategy = this.elementAsFlushStrategy(reader);
                            break block0;
                        }
                        case ALLOW_MULTIPLE_USERS: {
                            allowMultipleUsers = Boolean.TRUE;
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    public static enum Tag {
        UNKNOWN(null),
        DATASOURCES("datasources");

        private String name;
        private static final Map<String, Tag> MAP;

        private Tag(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        Tag value(String v) {
            this.name = v;
            return this;
        }

        public static Tag forName(String localName) {
            Tag element = MAP.get(localName);
            return element == null ? UNKNOWN.value(localName) : element;
        }

        static {
            HashMap<String, Tag> map = new HashMap<String, Tag>();
            for (Tag element : Tag.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }
}

