/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.tcp.frames;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.apache.cxf.binding.soap.tcp.DataCodingUtils;
import org.apache.cxf.binding.soap.tcp.frames.SoapTcpFrame;
import org.apache.cxf.binding.soap.tcp.frames.SoapTcpFrameContentDescription;
import org.apache.cxf.binding.soap.tcp.frames.SoapTcpFrameHeader;

public final class SoapTcpMessage {
    private List<SoapTcpFrame> frames = new ArrayList<SoapTcpFrame>();

    private SoapTcpMessage() {
    }

    public static SoapTcpMessage createSoapTcpMessage(SoapTcpFrame frame) {
        SoapTcpMessage soapTcpMessage = new SoapTcpMessage();
        soapTcpMessage.getFrames().add(frame);
        return soapTcpMessage;
    }

    public static SoapTcpMessage createSoapTcpMessage(List<SoapTcpFrame> frames) {
        SoapTcpMessage soapTcpMessage = new SoapTcpMessage();
        soapTcpMessage.getFrames().addAll(frames);
        return soapTcpMessage;
    }

    public static SoapTcpMessage createSoapTcpMessage(String message, int channelId) {
        SoapTcpMessage soapTcpMessage = new SoapTcpMessage();
        try {
            byte[] msgContent = message.getBytes("UTF-8");
            int numOfFrames = (int)Math.ceil((float)msgContent.length / 4096.0f);
            if (numOfFrames > 1) {
                int offset = 0;
                byte[] payload = new byte[4096];
                for (int i = 1; i <= numOfFrames; ++i) {
                    if (i == numOfFrames) {
                        payload = new byte[msgContent.length % 4096];
                    }
                    for (int j = 0; j < payload.length; ++j) {
                        payload[j] = msgContent[offset + j];
                    }
                    SoapTcpFrame frame = null;
                    frame = i == 1 ? SoapTcpMessage.createSoapTcpFrame(1, payload, channelId) : (i < numOfFrames ? SoapTcpMessage.createSoapTcpFrame(2, payload, channelId) : SoapTcpMessage.createSoapTcpFrame(3, payload, channelId));
                    soapTcpMessage.frames.add(frame);
                    offset += 4096;
                }
            } else {
                soapTcpMessage.frames.add(SoapTcpMessage.createSoapTcpFrame(0, msgContent, channelId));
            }
            return soapTcpMessage;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static SoapTcpMessage createErrorMessage(int code, int subCode, String description, int channelId) {
        SoapTcpMessage soapTcpMessage = new SoapTcpMessage();
        SoapTcpFrame frame = new SoapTcpFrame();
        SoapTcpFrameHeader header = new SoapTcpFrameHeader();
        header.setChannelId(channelId);
        header.setFrameType(4);
        frame.setHeader(header);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            DataCodingUtils.writeInts4((OutputStream)baos, code, subCode);
            byte[] strByteArray = description.getBytes("UTF-8");
            DataCodingUtils.writeInt8(baos, strByteArray.length);
            baos.write(strByteArray);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        frame.setPayload(baos.toByteArray());
        soapTcpMessage.getFrames().add(frame);
        return soapTcpMessage;
    }

    public void setChannelId(int channelId) {
        for (SoapTcpFrame frame : this.frames) {
            frame.setChannelId(channelId);
        }
    }

    public int getChannelId() {
        if (this.frames.size() > 0) {
            return this.frames.get(0).getChannelId();
        }
        return -1;
    }

    public void setFrames(List<SoapTcpFrame> frames) {
        this.frames = frames;
    }

    public List<SoapTcpFrame> getFrames() {
        return this.frames;
    }

    public String getContent() {
        StringBuilder result = new StringBuilder();
        try {
            for (SoapTcpFrame frame : this.frames) {
                result.append(new String(frame.getPayload(), "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return result.toString();
    }

    public InputStream getContentAsStream() {
        int buffLength = 0;
        for (SoapTcpFrame frame : this.frames) {
            buffLength += frame.getPayload().length;
        }
        byte[] buffer = new byte[buffLength];
        int index = 0;
        byte[] payload = null;
        for (SoapTcpFrame frame : this.frames) {
            payload = frame.getPayload();
            for (int i = 0; i < payload.length; ++i) {
                buffer[index] = payload[i];
                ++index;
            }
        }
        return new ByteArrayInputStream(buffer);
    }

    private static SoapTcpFrame createSoapTcpFrame(int frameType, byte[] payload, int channelId) {
        SoapTcpFrame frame = new SoapTcpFrame();
        SoapTcpFrameHeader header = new SoapTcpFrameHeader();
        SoapTcpFrameContentDescription contentDesc = null;
        if (frameType == 0 || frameType == 1) {
            contentDesc = new SoapTcpFrameContentDescription();
            contentDesc.setContentId(0);
            Hashtable<Integer, String> parameters = new Hashtable<Integer, String>();
            parameters.put(0, "utf-8");
            contentDesc.setParameters(parameters);
        }
        header.setChannelId(channelId);
        header.setFrameType(frameType);
        header.setContentDescription(contentDesc);
        frame.setHeader(header);
        frame.setPayload(payload);
        return frame;
    }
}

