/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.deployment;

import java.io.IOException;
import java.util.Arrays;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.HashUtil;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.DomainControllerMessages;
import org.jboss.as.domain.controller.operations.deployment.AbstractDeploymentHandler;
import org.jboss.as.domain.controller.operations.deployment.DeploymentUploadUtil;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.repository.HostFileRepository;
import org.jboss.as.server.controller.resources.DeploymentAttributes;
import org.jboss.as.server.deployment.DeploymentHandlerUtils;
import org.jboss.dmr.ModelNode;

public class DeploymentFullReplaceHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "full-replace-deployment";
    private final ContentRepository contentRepository;
    private final HostFileRepository fileRepository;

    public DeploymentFullReplaceHandler(ContentRepository contentRepository) {
        this.contentRepository = contentRepository;
        this.fileRepository = null;
    }

    public DeploymentFullReplaceHandler(HostFileRepository fileRepository) {
        this.contentRepository = null;
        this.fileRepository = fileRepository;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        byte[] newHash;
        ModelNode correctedOperation = operation.clone();
        for (AttributeDefinition def : DeploymentAttributes.FULL_REPLACE_DEPLOYMENT_ATTRIBUTES.values()) {
            def.validateAndSet(operation, correctedOperation);
        }
        final String name = DeploymentAttributes.NAME.resolveModelAttribute(context, correctedOperation).asString();
        PathElement deploymentPath = PathElement.pathElement((String)"deployment", (String)name);
        String runtimeName = correctedOperation.hasDefined("runtime-name") ? DeploymentAttributes.RUNTIME_NAME.resolveModelAttribute(context, correctedOperation).asString() : name;
        ModelNode content = correctedOperation.require("content").clone();
        ModelNode deploymentModel = context.readResourceForUpdate(PathAddress.pathAddress((PathElement[])new PathElement[]{deploymentPath})).getModel();
        ModelNode replacedContent = deploymentModel.get("content").get(0);
        final byte[] replacedHash = replacedContent.hasDefined(DeploymentAttributes.CONTENT_HASH.getName()) ? DeploymentAttributes.CONTENT_HASH.resolveModelAttribute(context, replacedContent).asBytes() : null;
        ModelNode contentItemNode = content.require(0);
        if (contentItemNode.hasDefined("hash")) {
            newHash = contentItemNode.require("hash").asBytes();
            if (this.contentRepository != null) {
                if (!this.contentRepository.hasContent(newHash)) {
                    throw AbstractDeploymentHandler.createFailureException(DomainControllerMessages.MESSAGES.noDeploymentContentWithHash(HashUtil.bytesToHexString((byte[])newHash)));
                }
            } else {
                this.fileRepository.getDeploymentFiles(newHash);
            }
        } else if (DeploymentHandlerUtils.hasValidContentAdditionParameterDefined((ModelNode)contentItemNode)) {
            if (this.contentRepository == null) {
                throw AbstractDeploymentHandler.createFailureException(DomainControllerMessages.MESSAGES.slaveCannotAcceptUploads());
            }
            try {
                newHash = DeploymentUploadUtil.storeContentAndTransformOperation(context, correctedOperation, this.contentRepository);
            }
            catch (IOException e) {
                throw AbstractDeploymentHandler.createFailureException(e.toString());
            }
            contentItemNode = new ModelNode();
            contentItemNode.get("hash").set(newHash);
            content = new ModelNode();
            content.add(contentItemNode);
        } else {
            newHash = null;
        }
        deploymentModel.get("runtime-name").set(runtimeName);
        deploymentModel.get("content").set(content);
        Resource root = context.readResource(PathAddress.EMPTY_ADDRESS);
        if (root.hasChild(PathElement.pathElement((String)"server-group"))) {
            for (Resource.ResourceEntry serverGroupResource : root.getChildren("server-group")) {
                Resource deploymentResource = serverGroupResource.getChild(deploymentPath);
                if (deploymentResource == null) continue;
                deploymentResource.getModel().get("runtime-name").set(runtimeName);
            }
        }
        context.completeStep(new OperationContext.ResultHandler(){

            public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                if (resultAction == OperationContext.ResultAction.KEEP) {
                    if (!(replacedHash == null || newHash != null && Arrays.equals(replacedHash, newHash))) {
                        if (DeploymentFullReplaceHandler.this.contentRepository != null) {
                            DeploymentFullReplaceHandler.this.contentRepository.removeContent(replacedHash, (Object)name);
                        } else {
                            DeploymentFullReplaceHandler.this.fileRepository.deleteDeployment(replacedHash);
                        }
                    }
                    if (newHash != null && DeploymentFullReplaceHandler.this.contentRepository != null) {
                        DeploymentFullReplaceHandler.this.contentRepository.addContentReference(newHash, (Object)name);
                    }
                } else if (!(newHash == null || replacedHash != null && Arrays.equals(replacedHash, newHash))) {
                    if (DeploymentFullReplaceHandler.this.contentRepository != null) {
                        DeploymentFullReplaceHandler.this.contentRepository.removeContent(newHash, (Object)name);
                    } else {
                        DeploymentFullReplaceHandler.this.fileRepository.deleteDeployment(newHash);
                    }
                }
            }
        });
    }
}

