/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.discovery;

import java.util.Map;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.host.controller.discovery.DiscoveryOption;
import org.jboss.as.host.controller.discovery.StaticDiscoveryResourceDefinition;
import org.jboss.dmr.ModelNode;

public class StaticDiscovery
implements DiscoveryOption {
    private final String remoteDcHost;
    private final int remoteDcPort;

    public StaticDiscovery(Map<String, ModelNode> properties) {
        ModelNode hostNode = properties.get("host");
        this.remoteDcHost = hostNode == null || !hostNode.isDefined() ? null : hostNode.asString();
        ModelNode portNode = properties.get("port");
        this.remoteDcPort = portNode == null || !portNode.isDefined() ? -1 : portNode.asInt();
    }

    @Override
    public void allowDiscovery(String host, int port) {
    }

    @Override
    public void discover() {
        try {
            StaticDiscoveryResourceDefinition.HOST.getValidator().validateParameter(StaticDiscoveryResourceDefinition.HOST.getName(), new ModelNode(this.remoteDcHost));
            StaticDiscoveryResourceDefinition.PORT.getValidator().validateParameter(StaticDiscoveryResourceDefinition.PORT.getName(), new ModelNode(this.remoteDcPort));
        }
        catch (OperationFailedException e) {
            throw new IllegalStateException(e.getFailureDescription().asString());
        }
    }

    @Override
    public void cleanUp() {
    }

    @Override
    public String getRemoteDomainControllerHost() {
        return this.remoteDcHost;
    }

    @Override
    public int getRemoteDomainControllerPort() {
        return this.remoteDcPort;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{host=" + this.remoteDcHost + ",port=" + this.remoteDcPort + '}';
    }
}

