/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import java.util.Locale;
import org.hornetq.api.jms.management.JMSServerControl;
import org.hornetq.core.server.HornetQServer;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.messaging.HornetQActivationService;
import org.jboss.as.messaging.MessagingDescriptions;
import org.jboss.as.messaging.MessagingMessages;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public class JMSServerControlHandler
extends AbstractRuntimeOnlyHandler {
    public static final JMSServerControlHandler INSTANCE = new JMSServerControlHandler();
    public static final String LIST_CONNECTIONS_AS_JSON = "list-connections-as-json";
    public static final String LIST_CONSUMERS_AS_JSON = "list-consumers-as-json";
    public static final String LIST_ALL_CONSUMERS_AS_JSON = "list-all-consumers-as-json";
    public static final String LIST_TARGET_DESTINATIONS = "list-target-destinations";
    public static final String GET_LAST_SENT_MESSAGE_ID = "get-last-sent-message-id";
    public static final String GET_SESSION_CREATION_TIME = "get-session-creation-time";
    public static final String LIST_SESSIONS_AS_JSON = "list-sessions-as-json";
    public static final String LIST_PREPARED_TRANSACTION_JMS_DETAILS_AS_JSON = "list-prepared-transaction-jms-details-as-json";
    public static final String LIST_PREPARED_TRANSACTION_JMS_DETAILS_AS_HTML = "list-prepared-transaction-jms-details-as-html";
    public static final String JMS_SERVER = "jms-server";
    public static final String ADDRESS_NAME = "address-name";
    public static final String CONNECTION_ID = "connection-id";
    public static final String SESSION_ID = "session-id";
    private final ParametersValidator connectionIdValidator = new ParametersValidator();
    private final ParametersValidator sessionIdValidator = new ParametersValidator();
    private final ParametersValidator lastSentValidator = new ParametersValidator();

    private JMSServerControlHandler() {
        StringLengthValidator stringLengthValidator = new StringLengthValidator(1);
        this.connectionIdValidator.registerValidator(CONNECTION_ID, (ParameterValidator)stringLengthValidator);
        this.sessionIdValidator.registerValidator(SESSION_ID, (ParameterValidator)stringLengthValidator);
        this.lastSentValidator.registerValidator(SESSION_ID, (ParameterValidator)stringLengthValidator);
        this.lastSentValidator.registerValidator(ADDRESS_NAME, (ParameterValidator)stringLengthValidator);
    }

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        block14: {
            if (HornetQActivationService.rollbackOperationIfServerNotActive(context, operation)) {
                return;
            }
            String operationName = operation.require("operation").asString();
            JMSServerControl serverControl = this.getServerControl(context, operation);
            if (serverControl == null) {
                PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
                throw ControllerMessages.MESSAGES.managementResourceNotFound(address);
            }
            try {
                if (LIST_CONNECTIONS_AS_JSON.equals(operationName)) {
                    String json = serverControl.listConnectionsAsJSON();
                    context.getResult().set(json);
                    break block14;
                }
                if (LIST_CONSUMERS_AS_JSON.equals(operationName)) {
                    this.connectionIdValidator.validate(operation);
                    String connectionID = operation.require(CONNECTION_ID).asString();
                    String json = serverControl.listConsumersAsJSON(connectionID);
                    context.getResult().set(json);
                    break block14;
                }
                if (LIST_ALL_CONSUMERS_AS_JSON.equals(operationName)) {
                    String json = serverControl.listAllConsumersAsJSON();
                    context.getResult().set(json);
                    break block14;
                }
                if (LIST_TARGET_DESTINATIONS.equals(operationName)) {
                    this.sessionIdValidator.validate(operation);
                    String sessionID = operation.require(SESSION_ID).asString();
                    String[] list = serverControl.listTargetDestinations(sessionID);
                    this.reportListOfString(context, list);
                    break block14;
                }
                if (GET_LAST_SENT_MESSAGE_ID.equals(operationName)) {
                    this.lastSentValidator.validate(operation);
                    String sessionID = operation.require(SESSION_ID).asString();
                    String addressName = operation.require(ADDRESS_NAME).asString();
                    String msgId = serverControl.getLastSentMessageID(sessionID, addressName);
                    context.getResult().set(msgId);
                    break block14;
                }
                if (GET_SESSION_CREATION_TIME.equals(operationName)) {
                    this.sessionIdValidator.validate(operation);
                    String sessionID = operation.require(SESSION_ID).asString();
                    String time = serverControl.getSessionCreationTime(sessionID);
                    context.getResult().set(time);
                    break block14;
                }
                if (LIST_SESSIONS_AS_JSON.equals(operationName)) {
                    this.connectionIdValidator.validate(operation);
                    String connectionID = operation.require(CONNECTION_ID).asString();
                    String json = serverControl.listSessionsAsJSON(connectionID);
                    context.getResult().set(json);
                    break block14;
                }
                if (LIST_PREPARED_TRANSACTION_JMS_DETAILS_AS_JSON.equals(operationName)) {
                    String json = serverControl.listPreparedTransactionDetailsAsJSON();
                    context.getResult().set(json);
                    break block14;
                }
                if (LIST_PREPARED_TRANSACTION_JMS_DETAILS_AS_HTML.equals(operationName)) {
                    String html = serverControl.listPreparedTransactionDetailsAsHTML();
                    context.getResult().set(html);
                    break block14;
                }
                throw MessagingMessages.MESSAGES.unsupportedOperation(operationName);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                context.getFailureDescription().set(e.getLocalizedMessage());
            }
        }
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }

    public void registerOperations(ManagementResourceRegistration registry) {
        registry.registerOperationHandler(LIST_CONNECTIONS_AS_JSON, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getNoArgSimpleReplyOperation(locale, JMSServerControlHandler.LIST_CONNECTIONS_AS_JSON, JMSServerControlHandler.JMS_SERVER, ModelType.STRING, true);
            }
        });
        registry.registerOperationHandler(LIST_CONSUMERS_AS_JSON, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getSingleParamSimpleReplyOperation(locale, JMSServerControlHandler.LIST_CONSUMERS_AS_JSON, JMSServerControlHandler.JMS_SERVER, JMSServerControlHandler.CONNECTION_ID, ModelType.STRING, false, ModelType.STRING, true);
            }
        });
        registry.registerOperationHandler(LIST_ALL_CONSUMERS_AS_JSON, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getNoArgSimpleReplyOperation(locale, JMSServerControlHandler.LIST_ALL_CONSUMERS_AS_JSON, JMSServerControlHandler.JMS_SERVER, ModelType.STRING, true);
            }
        });
        registry.registerOperationHandler(LIST_TARGET_DESTINATIONS, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getSingleParamSimpleListReplyOperation(locale, JMSServerControlHandler.LIST_TARGET_DESTINATIONS, JMSServerControlHandler.JMS_SERVER, JMSServerControlHandler.SESSION_ID, ModelType.STRING, false, ModelType.STRING, true);
            }
        });
        registry.registerOperationHandler(GET_LAST_SENT_MESSAGE_ID, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getGetLastSentMessageId(locale);
            }
        });
        registry.registerOperationHandler(GET_SESSION_CREATION_TIME, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getSingleParamSimpleReplyOperation(locale, JMSServerControlHandler.GET_SESSION_CREATION_TIME, JMSServerControlHandler.JMS_SERVER, JMSServerControlHandler.SESSION_ID, ModelType.STRING, false, ModelType.STRING, true);
            }
        });
        registry.registerOperationHandler(LIST_SESSIONS_AS_JSON, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getSingleParamSimpleReplyOperation(locale, JMSServerControlHandler.LIST_SESSIONS_AS_JSON, JMSServerControlHandler.JMS_SERVER, JMSServerControlHandler.CONNECTION_ID, ModelType.STRING, false, ModelType.STRING, true);
            }
        });
        registry.registerOperationHandler(LIST_PREPARED_TRANSACTION_JMS_DETAILS_AS_JSON, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getNoArgSimpleReplyOperation(locale, JMSServerControlHandler.LIST_PREPARED_TRANSACTION_JMS_DETAILS_AS_JSON, JMSServerControlHandler.JMS_SERVER, ModelType.STRING, true);
            }
        });
        registry.registerOperationHandler(LIST_PREPARED_TRANSACTION_JMS_DETAILS_AS_HTML, (OperationStepHandler)this, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return MessagingDescriptions.getNoArgSimpleReplyOperation(locale, JMSServerControlHandler.LIST_PREPARED_TRANSACTION_JMS_DETAILS_AS_HTML, JMSServerControlHandler.JMS_SERVER, ModelType.STRING, true);
            }
        });
    }

    private JMSServerControl getServerControl(OperationContext context, ModelNode operation) {
        ServiceName hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
        ServiceController hqService = context.getServiceRegistry(false).getService(hqServiceName);
        HornetQServer hqServer = (HornetQServer)HornetQServer.class.cast(hqService.getValue());
        return (JMSServerControl)JMSServerControl.class.cast(hqServer.getManagementService().getResource("jms.server"));
    }

    private void reportListOfString(OperationContext context, String[] list) {
        ModelNode result = context.getResult();
        result.setEmptyList();
        for (String tx : list) {
            result.add(tx);
        }
    }
}

