/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.lang.reflect.Method;
import javax.ejb.EJBObject;
import org.jboss.ejb.client.EJBClient;
import org.jboss.ejb.client.EJBClientContextIdentifier;
import org.jboss.ejb.client.EJBClientInterceptor;
import org.jboss.ejb.client.EJBClientInvocationContext;
import org.jboss.ejb.client.EJBLocator;

final class EJBObjectInterceptor
implements EJBClientInterceptor {
    EJBObjectInterceptor() {
    }

    @Override
    public void handleInvocation(EJBClientInvocationContext invocationContext) throws Exception {
        invocationContext.sendRequest();
    }

    @Override
    public Object handleInvocationResult(EJBClientInvocationContext invocationContext) throws Exception {
        Object originalResult = invocationContext.getResult();
        if (originalResult == null) {
            return originalResult;
        }
        if (!EJBClient.isEJBProxy(originalResult)) {
            return originalResult;
        }
        if (!this.isEJBObjectInvocation(invocationContext)) {
            return originalResult;
        }
        if (!this.isGetEJBHomeMethodInvocation(invocationContext)) {
            return originalResult;
        }
        Object ejbProxy = originalResult;
        EJBLocator<Object> ejbLocator = EJBClient.getLocatorFor(ejbProxy);
        EJBClientContextIdentifier ejbClientContextIdentifier = invocationContext.getInvocationHandler().getEjbClientContextIdentifier();
        return EJBClient.createProxy(ejbLocator, ejbClientContextIdentifier);
    }

    private boolean isEJBObjectInvocation(EJBClientInvocationContext invocationContext) {
        return invocationContext.getInvokedProxy() instanceof EJBObject;
    }

    private boolean isGetEJBHomeMethodInvocation(EJBClientInvocationContext invocationContext) {
        Method invokedMethod = invocationContext.getInvokedMethod();
        return invokedMethod.getName().equals("getEJBHome");
    }
}

