/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.spatial;

import java.util.Map;
import org.apache.lucene.document.Document;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.ParameterizedBridge;
import org.hibernate.search.spatial.SpatialFieldBridge;
import org.hibernate.search.spatial.impl.Point;
import org.hibernate.search.spatial.impl.SpatialHelper;

public class SpatialFieldBridgeByQuadTree
extends SpatialFieldBridge
implements ParameterizedBridge {
    public static final int DEFAULT_TOP_QUAD_TREE_LEVEL = 0;
    public static final int DEFAULT_BOTTOM_QUAD_TREE_LEVEL = 16;
    private int topQuadTreeLevel = 0;
    private int bottomQuadTreeLevel = 16;
    private boolean quadTreeIndex = true;
    private boolean numericFieldsIndex = true;

    public SpatialFieldBridgeByQuadTree() {
    }

    public SpatialFieldBridgeByQuadTree(int topQuadTreeLevel, int bottomQuadTreeLevel) {
        this.topQuadTreeLevel = topQuadTreeLevel;
        this.bottomQuadTreeLevel = bottomQuadTreeLevel;
    }

    public SpatialFieldBridgeByQuadTree(int topQuadTreeLevel, int bottomQuadTreeLevel, String latitudeField, String longitudeField) {
        this.topQuadTreeLevel = topQuadTreeLevel;
        this.bottomQuadTreeLevel = bottomQuadTreeLevel;
        this.latitudeField = latitudeField;
        this.longitudeField = longitudeField;
    }

    @Override
    public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
        if (value != null) {
            Double latitude = this.getLatitude(value);
            Double longitude = this.getLongitude(value);
            if (latitude != null && longitude != null) {
                if (this.quadTreeIndex) {
                    Point point = Point.fromDegrees(latitude, longitude);
                    for (int i = this.topQuadTreeLevel; i <= this.bottomQuadTreeLevel; ++i) {
                        luceneOptions.addFieldToDocument(SpatialHelper.formatFieldName(i, name), SpatialHelper.getQuadTreeCellId(point, i), document);
                    }
                }
                if (this.numericFieldsIndex) {
                    luceneOptions.addNumericFieldToDocument(SpatialHelper.formatLatitude(name), latitude, document);
                    luceneOptions.addNumericFieldToDocument(SpatialHelper.formatLongitude(name), longitude, document);
                }
            }
        }
    }

    public void setParameterValues(Map parameters) {
        Object numericFieldsIndex;
        Object quadTreeIndex;
        Object bottomQuadTreeLevel;
        Object topQuadTreeLevel = parameters.get("topQuadTreeLevel");
        if (topQuadTreeLevel instanceof Integer) {
            this.topQuadTreeLevel = (Integer)topQuadTreeLevel;
        }
        if ((bottomQuadTreeLevel = parameters.get("bottomQuadTreeLevel")) instanceof Integer) {
            this.bottomQuadTreeLevel = (Integer)bottomQuadTreeLevel;
        }
        if ((quadTreeIndex = parameters.get("quadTreeIndex")) instanceof Boolean) {
            this.quadTreeIndex = (Boolean)quadTreeIndex;
        }
        if ((numericFieldsIndex = parameters.get("numericFieldsIndex")) instanceof Boolean) {
            this.numericFieldsIndex = (Boolean)numericFieldsIndex;
        }
    }
}

