/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.spi.metadata.j2ee.serviceref;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jboss.wsf.spi.Loggers;
import org.jboss.wsf.spi.Messages;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainsMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedPortComponentRefMetaData;
import org.jboss.wsf.spi.serviceref.ServiceRefType;

public final class UnifiedServiceRefMetaData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient UnifiedVirtualFile vfsRoot;
    private ServiceRefType type;
    private String serviceRefName;
    private String serviceInterface;
    private String serviceRefType;
    private String wsdlFile;
    private String mappingFile;
    private QName serviceQName;
    private List<UnifiedPortComponentRefMetaData> portComponentRefs = new ArrayList<UnifiedPortComponentRefMetaData>(4);
    private List<UnifiedHandlerMetaData> handlers = new ArrayList<UnifiedHandlerMetaData>(4);
    private UnifiedHandlerChainsMetaData handlerChains;
    private String serviceImplClass;
    private String configName;
    private String configFile;
    private String wsdlOverride;
    private String handlerChain;
    private boolean isAddressingAnnotationSpecified;
    private boolean addressingEnabled;
    private boolean addressingRequired;
    private String addressingResponses = "ALL";
    private boolean isMtomAnnotationSpecified;
    private boolean mtomEnabled;
    private int mtomThreshold;
    private boolean isRespectBindingAnnotationSpecified;
    private boolean respectBindingEnabled;
    private Map<QName, String> deployedServiceAddresses = new HashMap<QName, String>();

    public UnifiedServiceRefMetaData(UnifiedVirtualFile vfRoot) {
        this.vfsRoot = vfRoot;
    }

    public UnifiedServiceRefMetaData() {
    }

    public void setAddressingAnnotationSpecified(boolean isAddressingAnnotationSpecified) {
        this.isAddressingAnnotationSpecified = isAddressingAnnotationSpecified;
    }

    public boolean isAddressingAnnotationSpecified() {
        return this.isAddressingAnnotationSpecified;
    }

    public void setAddressingEnabled(boolean addressingEnabled) {
        this.addressingEnabled = addressingEnabled;
    }

    public boolean isAddressingEnabled() {
        return this.addressingEnabled;
    }

    public void setAddressingRequired(boolean addressingRequired) {
        this.addressingRequired = addressingRequired;
    }

    public boolean isAddressingRequired() {
        return this.addressingRequired;
    }

    public void setAddressingResponses(String responsesTypes) {
        if (!("ANONYMOUS".equals(responsesTypes) || "NON_ANONYMOUS".equals(responsesTypes) || "ALL".equals(responsesTypes))) {
            throw Messages.MESSAGES.unsupportedAddressingResponseType(responsesTypes);
        }
        this.addressingResponses = responsesTypes;
    }

    public String getAddressingResponses() {
        return this.addressingResponses;
    }

    public void setMtomAnnotationSpecified(boolean isMtomAnnotationSpecified) {
        this.isMtomAnnotationSpecified = isMtomAnnotationSpecified;
    }

    public boolean isMtomAnnotationSpecified() {
        return this.isMtomAnnotationSpecified;
    }

    public void setMtomEnabled(boolean mtomEnabled) {
        this.mtomEnabled = mtomEnabled;
    }

    public boolean isMtomEnabled() {
        return this.mtomEnabled;
    }

    public void setMtomThreshold(int mtomThreshold) {
        this.mtomThreshold = mtomThreshold;
    }

    public int getMtomThreshold() {
        return this.mtomThreshold;
    }

    public void setRespectBindingAnnotationSpecified(boolean isRespectBindingAnnotationSpecified) {
        this.isRespectBindingAnnotationSpecified = isRespectBindingAnnotationSpecified;
    }

    public boolean isRespectBindingAnnotationSpecified() {
        return this.isRespectBindingAnnotationSpecified;
    }

    public void setRespectBindingEnabled(boolean respectBindingEnabled) {
        this.respectBindingEnabled = respectBindingEnabled;
    }

    public boolean isRespectBindingEnabled() {
        return this.respectBindingEnabled;
    }

    public UnifiedVirtualFile getVfsRoot() {
        return this.vfsRoot;
    }

    public void setVfsRoot(UnifiedVirtualFile vfsRoot) {
        this.vfsRoot = vfsRoot;
    }

    public ServiceRefType getType() {
        return this.type;
    }

    public void setType(ServiceRefType type) {
        this.type = type;
    }

    public String getServiceRefName() {
        return this.serviceRefName;
    }

    public void setServiceRefName(String serviceRefName) {
        this.serviceRefName = serviceRefName;
    }

    public String getMappingFile() {
        return this.mappingFile;
    }

    public void setMappingFile(String mappingFile) {
        this.mappingFile = mappingFile;
    }

    public URL getMappingLocation() {
        URL mappingURL = null;
        if (this.mappingFile != null) {
            if (this.vfsRoot != null) {
                try {
                    mappingURL = this.vfsRoot.findChild(this.mappingFile).toURL();
                }
                catch (Exception e) {
                    throw Messages.MESSAGES.cannotFindFile(e, this.mappingFile);
                }
            } else {
                mappingURL = UnifiedServiceRefMetaData.getContextClassLoader().getResource(this.mappingFile);
            }
        }
        return mappingURL;
    }

    public Collection<UnifiedPortComponentRefMetaData> getPortComponentRefs() {
        return this.portComponentRefs;
    }

    public UnifiedPortComponentRefMetaData getPortComponentRef(String seiName, QName portName) {
        UnifiedPortComponentRefMetaData matchingRef = null;
        for (UnifiedPortComponentRefMetaData ref : this.portComponentRefs) {
            if (!ref.matches(seiName, portName)) continue;
            if (matchingRef != null) {
                Loggers.METADATA_LOGGER.multipleMatchingPortComponentRef(seiName, portName);
            }
            matchingRef = ref;
        }
        return matchingRef;
    }

    public void addPortComponentRef(UnifiedPortComponentRefMetaData pcRef) {
        this.portComponentRefs.add(pcRef);
    }

    public List<UnifiedHandlerMetaData> getHandlers() {
        return this.handlers;
    }

    public void addHandler(UnifiedHandlerMetaData handler) {
        this.handlers.add(handler);
    }

    public String getServiceInterface() {
        return this.serviceInterface;
    }

    public void setServiceInterface(String serviceInterface) {
        this.serviceInterface = serviceInterface;
    }

    public String getServiceImplClass() {
        return this.serviceImplClass;
    }

    public void setServiceImplClass(String serviceImplClass) {
        this.serviceImplClass = serviceImplClass;
    }

    public QName getServiceQName() {
        return this.serviceQName;
    }

    public void setServiceQName(QName serviceQName) {
        this.serviceQName = serviceQName;
    }

    public String getServiceRefType() {
        return this.serviceRefType;
    }

    public void setServiceRefType(String serviceResType) {
        this.serviceRefType = serviceResType;
    }

    public String getWsdlFile() {
        return this.wsdlFile;
    }

    public void setWsdlFile(String wsdlFile) {
        this.wsdlFile = wsdlFile;
    }

    public URL getWsdlLocation() {
        URL wsdlLocation = null;
        if (this.wsdlOverride != null) {
            try {
                wsdlLocation = new URL(this.wsdlOverride);
            }
            catch (MalformedURLException e1) {
                if (this.vfsRoot != null) {
                    try {
                        wsdlLocation = this.vfsRoot.findChild(this.wsdlOverride).toURL();
                    }
                    catch (Exception e) {
                        throw Messages.MESSAGES.cannotFindFile(e, this.wsdlOverride);
                    }
                }
                wsdlLocation = UnifiedServiceRefMetaData.getContextClassLoader().getResource(this.wsdlOverride);
            }
        }
        if (wsdlLocation == null && this.wsdlFile != null) {
            try {
                wsdlLocation = new URL(this.wsdlFile);
            }
            catch (MalformedURLException e1) {
                if (this.vfsRoot != null) {
                    try {
                        wsdlLocation = this.vfsRoot.findChild(this.wsdlFile).toURL();
                    }
                    catch (Exception e) {
                        throw Messages.MESSAGES.cannotFindFile(e, this.wsdlFile);
                    }
                }
                wsdlLocation = UnifiedServiceRefMetaData.getContextClassLoader().getResource(this.wsdlFile);
            }
        }
        return wsdlLocation;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public String getConfigName() {
        return this.configName;
    }

    public void setConfigName(String configName) {
        this.configName = configName;
    }

    public String getWsdlOverride() {
        return this.wsdlOverride;
    }

    public void setWsdlOverride(String wsdlOverride) {
        this.wsdlOverride = wsdlOverride;
    }

    public UnifiedHandlerChainsMetaData getHandlerChains() {
        return this.handlerChains;
    }

    public void setHandlerChains(UnifiedHandlerChainsMetaData handlerChains) {
        this.handlerChains = handlerChains;
    }

    public String getHandlerChain() {
        return this.handlerChain;
    }

    public void setHandlerChain(String handlerChain) {
        this.handlerChain = handlerChain;
    }

    public Map<QName, String> getDeployedServiceAddresses() {
        return this.deployedServiceAddresses;
    }

    public void addDeployedServiceAddresses(Map<QName, String> addressMap) {
        this.deployedServiceAddresses.putAll(addressMap);
    }

    private static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("\nUnifiedServiceRef");
        str.append("\n serviceRefName=" + this.serviceRefName);
        str.append("\n type=" + (Object)((Object)this.type));
        str.append("\n serviceInterface=" + this.serviceInterface);
        str.append("\n serviceImplClass=" + this.serviceImplClass);
        str.append("\n serviceRefType=" + this.serviceRefType);
        str.append("\n serviceQName=" + this.serviceQName);
        str.append("\n wsdlFile=" + this.wsdlFile);
        str.append("\n wsdlOverride=" + this.wsdlOverride);
        str.append("\n mappingFile=" + this.mappingFile);
        str.append("\n configName=" + this.configName);
        str.append("\n configFile=" + this.configFile);
        str.append("\n addressingAnnotationSpecified=" + this.isAddressingAnnotationSpecified);
        str.append("\n addressingEnabled=" + this.addressingEnabled);
        str.append("\n addressingRequired=" + this.addressingRequired);
        str.append("\n addressingResponses=" + this.addressingResponses);
        str.append("\n mtomAnnotationSpecified=" + this.isMtomAnnotationSpecified);
        str.append("\n mtomEnabled=" + this.mtomEnabled);
        str.append("\n mtomThreshold=" + this.mtomThreshold);
        str.append("\n respectBindingAnnotationSpecified=" + this.isRespectBindingAnnotationSpecified);
        str.append("\n respectBindingEnabled=" + this.respectBindingEnabled);
        str.append("\n handlerChains=" + this.handlerChains);
        str.append("\n handlerChain=" + this.handlerChain);
        for (UnifiedHandlerMetaData uhmd : this.handlers) {
            str.append(uhmd.toString());
        }
        for (UnifiedPortComponentRefMetaData pcref : this.portComponentRefs) {
            str.append(pcref.toString());
        }
        return str.toString();
    }
}

