/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.module;

import java.io.Closeable;
import java.io.IOException;
import org.jboss.as.server.ServerMessages;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentMountProvider;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.ExplodedDeploymentMarker;
import org.jboss.as.server.deployment.MountExplodedMarker;
import org.jboss.as.server.deployment.MountType;
import org.jboss.as.server.deployment.module.ModuleRootMarker;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.server.deployment.module.MountHandle;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;

public class DeploymentRootMountProcessor
implements DeploymentUnitProcessor {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        MountHandle mountHandle;
        VirtualFile deploymentRoot;
        DeploymentUnit deploymentUnit;
        block11: {
            deploymentUnit = phaseContext.getDeploymentUnit();
            if (deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT) != null) {
                return;
            }
            DeploymentMountProvider deploymentMountProvider = deploymentUnit.getAttachment(Attachments.SERVER_DEPLOYMENT_REPOSITORY);
            if (deploymentMountProvider == null) {
                throw ServerMessages.MESSAGES.noDeploymentRepositoryAvailable();
            }
            String deploymentName = deploymentUnit.getName();
            VirtualFile deploymentContents = deploymentUnit.getAttachment(Attachments.DEPLOYMENT_CONTENTS);
            if (deploymentContents == null) {
                return;
            }
            if (deploymentContents.isDirectory()) {
                deploymentRoot = deploymentContents;
                mountHandle = null;
                if (deploymentUnit.getParent() == null || ExplodedDeploymentMarker.isExplodedDeployment(deploymentUnit.getParent())) {
                    ExplodedDeploymentMarker.markAsExplodedDeployment(deploymentUnit);
                }
            } else {
                deploymentRoot = VFS.getChild((String)("content/" + deploymentName));
                boolean failed = false;
                Closeable handle = null;
                try {
                    boolean mountExploded = MountExplodedMarker.isMountExploded(deploymentUnit);
                    MountType type = mountExploded ? MountType.EXPANDED : (deploymentName.endsWith(".xml") ? MountType.REAL : MountType.ZIP);
                    handle = deploymentMountProvider.mountDeploymentContent(deploymentContents, deploymentRoot, type);
                    mountHandle = new MountHandle(handle);
                    if (!failed) break block11;
                }
                catch (IOException e) {
                    try {
                        failed = true;
                        throw ServerMessages.MESSAGES.deploymentMountFailed(e);
                    }
                    catch (Throwable throwable) {
                        if (failed) {
                            VFSUtils.safeClose(handle);
                        }
                        throw throwable;
                    }
                }
                VFSUtils.safeClose((Closeable)handle);
            }
        }
        ResourceRoot resourceRoot = new ResourceRoot(deploymentRoot, mountHandle);
        ModuleRootMarker.mark(resourceRoot);
        deploymentUnit.putAttachment(Attachments.DEPLOYMENT_ROOT, resourceRoot);
        deploymentUnit.putAttachment(Attachments.MODULE_SPECIFICATION, new ModuleSpecification());
    }

    @Override
    public void undeploy(DeploymentUnit context) {
        ResourceRoot resourceRoot = context.removeAttachment(Attachments.DEPLOYMENT_ROOT);
        if (resourceRoot != null) {
            MountHandle mountHandle = resourceRoot.getMountHandle();
            VFSUtils.safeClose((Closeable)mountHandle);
        }
    }
}

