/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.attribute;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributeBuilder;
import io.undertow.attribute.ReadOnlyAttributeException;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;

public class LocalServerNameAttribute
implements ExchangeAttribute {
    public static final String LOCAL_SERVER_NAME_SHORT = "%v";
    public static final String LOCAL_SERVER_NAME = "%{LOCAL_SERVER_NAME}";
    public static final ExchangeAttribute INSTANCE = new LocalServerNameAttribute();

    private LocalServerNameAttribute() {
    }

    @Override
    public String readAttribute(HttpServerExchange exchange) {
        return exchange.getRequestHeaders().getFirst(Headers.HOST);
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
        throw new ReadOnlyAttributeException("Local server name", newValue);
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Local server name";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.equals(LocalServerNameAttribute.LOCAL_SERVER_NAME) || token.equals(LocalServerNameAttribute.LOCAL_SERVER_NAME_SHORT)) {
                return INSTANCE;
            }
            return null;
        }
    }
}

