/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.xml.namespace.QName;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.parsing.Namespace;
import org.jboss.as.controller.persistence.BackupXmlConfigurationPersister;
import org.jboss.as.controller.persistence.ConfigurationFile;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.persistence.ExtensibleConfigurationPersister;
import org.jboss.as.controller.persistence.ModelMarshallingContext;
import org.jboss.as.controller.persistence.NullConfigurationPersister;
import org.jboss.as.controller.persistence.SubsystemXmlWriterRegistry;
import org.jboss.as.controller.persistence.XmlConfigurationPersister;
import org.jboss.as.host.controller.HostControllerLogger;
import org.jboss.as.host.controller.parsing.DomainXml;
import org.jboss.as.host.controller.parsing.HostXml;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class ConfigurationPersisterFactory {
    static final String CACHED_DOMAIN_XML = "domain.cached-remote.xml";
    static ConfigurationPersister.PersistenceResource NULL_PERSISTENCE_RESOURCE = new ConfigurationPersister.PersistenceResource(){

        public void commit() {
        }

        public void rollback() {
        }
    };

    public static ExtensibleConfigurationPersister createHostXmlConfigurationPersister(ConfigurationFile file, String defaultHostControllerName) {
        HostXml hostXml = new HostXml(defaultHostControllerName);
        BackupXmlConfigurationPersister persister = new BackupXmlConfigurationPersister(file, new QName(Namespace.CURRENT.getUriString(), "host"), (XMLElementReader)hostXml, (XMLElementWriter)hostXml);
        for (Namespace namespace : Namespace.domainValues()) {
            if (namespace.equals((Object)Namespace.CURRENT)) continue;
            persister.registerAdditionalRootElement(new QName(namespace.getUriString(), "host"), (XMLElementReader)hostXml);
        }
        return persister;
    }

    public static ExtensibleConfigurationPersister createDomainXmlConfigurationPersister(ConfigurationFile file, ExecutorService executorService, ExtensionRegistry extensionRegistry) {
        DomainXml domainXml = new DomainXml(Module.getBootModuleLoader(), executorService, extensionRegistry);
        BackupXmlConfigurationPersister persister = new BackupXmlConfigurationPersister(file, new QName(Namespace.CURRENT.getUriString(), "domain"), (XMLElementReader)domainXml, (XMLElementWriter)domainXml);
        for (Namespace namespace : Namespace.domainValues()) {
            if (namespace.equals((Object)Namespace.CURRENT)) continue;
            persister.registerAdditionalRootElement(new QName(namespace.getUriString(), "domain"), (XMLElementReader)domainXml);
        }
        extensionRegistry.setWriterRegistry((SubsystemXmlWriterRegistry)persister);
        return persister;
    }

    public static ExtensibleConfigurationPersister createRemoteBackupDomainXmlConfigurationPersister(File configDir, ExecutorService executorService, ExtensionRegistry extensionRegistry) {
        DomainXml domainXml = new DomainXml(Module.getBootModuleLoader(), executorService, extensionRegistry);
        File file = new File(configDir, CACHED_DOMAIN_XML);
        BackupRemoteDomainXmlPersister persister = new BackupRemoteDomainXmlPersister(file, new QName(Namespace.CURRENT.getUriString(), "domain"), (XMLElementReader<List<ModelNode>>)domainXml, (XMLElementWriter<ModelMarshallingContext>)domainXml);
        for (Namespace namespace : Namespace.domainValues()) {
            if (namespace.equals((Object)Namespace.CURRENT)) continue;
            persister.registerAdditionalRootElement(new QName(namespace.getUriString(), "domain"), (XMLElementReader)domainXml);
        }
        extensionRegistry.setWriterRegistry((SubsystemXmlWriterRegistry)persister);
        return persister;
    }

    public static ExtensibleConfigurationPersister createCachedRemoteDomainXmlConfigurationPersister(File configDir, ExecutorService executorService, ExtensionRegistry extensionRegistry) {
        DomainXml domainXml = new DomainXml(Module.getBootModuleLoader(), executorService, extensionRegistry);
        File file = new File(configDir, CACHED_DOMAIN_XML);
        CachedRemoteDomainXmlPersister persister = new CachedRemoteDomainXmlPersister(file, new QName(Namespace.CURRENT.getUriString(), "domain"), (XMLElementReader<List<ModelNode>>)domainXml, (XMLElementWriter<ModelMarshallingContext>)domainXml);
        for (Namespace namespace : Namespace.domainValues()) {
            if (namespace.equals((Object)Namespace.CURRENT)) continue;
            persister.registerAdditionalRootElement(new QName(namespace.getUriString(), "domain"), (XMLElementReader)domainXml);
        }
        extensionRegistry.setWriterRegistry((SubsystemXmlWriterRegistry)persister);
        return persister;
    }

    public static ExtensibleConfigurationPersister createTransientDomainXmlConfigurationPersister(ExecutorService executorService, ExtensionRegistry extensionRegistry) {
        DomainXml domainXml = new DomainXml(Module.getBootModuleLoader(), executorService, extensionRegistry);
        NullConfigurationPersister persister = new NullConfigurationPersister((XMLElementWriter)domainXml);
        extensionRegistry.setWriterRegistry((SubsystemXmlWriterRegistry)persister);
        return persister;
    }

    static class CachedRemoteDomainXmlPersister
    extends XmlConfigurationPersister {
        volatile boolean started = false;

        CachedRemoteDomainXmlPersister(File fileName, QName rootElement, XMLElementReader<List<ModelNode>> rootParser, XMLElementWriter<ModelMarshallingContext> rootDeparser) {
            super(fileName, rootElement, rootParser, rootDeparser);
        }

        public ConfigurationPersister.PersistenceResource store(ModelNode model, Set<PathAddress> affectedAddresses) throws ConfigurationPersistenceException {
            if (this.started) {
                HostControllerLogger.ROOT_LOGGER.invalidRemoteBackupPersisterState();
            }
            return NULL_PERSISTENCE_RESOURCE;
        }

        public void successfulBoot() throws ConfigurationPersistenceException {
            this.started = true;
        }
    }

    static class BackupRemoteDomainXmlPersister
    extends XmlConfigurationPersister {
        BackupRemoteDomainXmlPersister(File fileName, QName rootElement, XMLElementReader<List<ModelNode>> rootParser, XMLElementWriter<ModelMarshallingContext> rootDeparser) {
            super(fileName, rootElement, rootParser, rootDeparser);
        }

        public List<ModelNode> load() throws ConfigurationPersistenceException {
            HostControllerLogger.ROOT_LOGGER.invalidRemoteBackupPersisterState();
            return Collections.emptyList();
        }
    }
}

