/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa.entities;

import java.util.HashMap;
import java.util.Map;

public class AttributeMap {
    Map<String, String> attributes = new HashMap<String, String>();

    public void set(String key, String value) {
        this.attributes.put(key, value);
    }

    public void set(String key, Boolean value) {
        this.attributes.put(key, value.toString());
    }

    public void set(String key, Integer value) {
        this.attributes.put(key, value.toString());
    }

    public String get(String key) {
        return this.attributes.get(key);
    }

    public String get(String key, String defaultValue) {
        String value = this.attributes.get(key);
        return value == null ? defaultValue : value;
    }

    public String[] getArray(String key) {
        String value = this.get(key);
        if (value != null) {
            String[] a = value.split(",");
            for (int i = 0; i < a.length; ++i) {
                a[i] = a[i].trim();
            }
            return a;
        }
        return null;
    }

    public Integer getInt(String key) {
        return this.getInt(key, null);
    }

    public Integer getInt(String key, Integer defaultValue) {
        String v = this.get(key, null);
        return v != null ? Integer.parseInt(v) : defaultValue;
    }

    public Long getLong(String key) {
        return this.getLong(key, null);
    }

    public Long getLong(String key, Long defaultValue) {
        String v = this.get(key, null);
        return v != null ? Long.parseLong(v) : defaultValue;
    }

    public Boolean getBoolean(String key) {
        return this.getBoolean(key, null);
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        String v = this.get(key, null);
        return v != null ? Boolean.parseBoolean(v) : defaultValue;
    }
}

