/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.entity.interceptors;

import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ejb3.component.entity.EntityBeanComponent;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;

public class EntityBeanIdentityInterceptorFactory
implements InterceptorFactory {
    public static final EntityBeanIdentityInterceptorFactory INSTANCE = new EntityBeanIdentityInterceptorFactory();

    public Interceptor create(InterceptorFactoryContext context) {
        ComponentView componentView = (ComponentView)context.getContextData().get(ComponentView.class);
        return new EntityIdentityInterceptor(componentView);
    }

    private static class PrimaryKeyHolder {
        private final Object primaryKey;

        public PrimaryKeyHolder(Object primaryKey) {
            this.primaryKey = primaryKey;
        }
    }

    private class EntityIdentityInterceptor
    implements Interceptor {
        private final ComponentView componentView;

        public EntityIdentityInterceptor(ComponentView componentView) {
            this.componentView = componentView;
        }

        public Object processInvocation(InterceptorContext context) throws Exception {
            Object primaryKey = context.getPrivateData(EntityBeanComponent.PRIMARY_KEY_CONTEXT_KEY);
            if (context.getMethod().getName().equals("equals") && context.getParameters().length == 1 && context.getMethod().getParameterTypes()[0] == Object.class) {
                Object other = context.getParameters()[0];
                Class proxyType = this.componentView.getProxyClass();
                if (proxyType.isAssignableFrom(other.getClass())) {
                    return other.equals(new PrimaryKeyHolder(primaryKey));
                }
                if (other instanceof PrimaryKeyHolder) {
                    return primaryKey.equals(((PrimaryKeyHolder)other).primaryKey);
                }
                return false;
            }
            if (context.getMethod().getName().equals("hashCode")) {
                return primaryKey.hashCode();
            }
            return context.proceed();
        }
    }
}

