/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.jackson;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStreamWriter;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.jboss.resteasy.core.MediaTypeMap;

@Provider
@ConstrainedTo(value=RuntimeType.SERVER)
public class Jackson2JsonpInterceptor
implements WriterInterceptor {
    public static final MediaType TEXT_JAVASCRIPT_MEDIA_TYPE = new MediaType("text", "javascript");
    public static final MediaType APPLICATION_JAVASCRIPT_MEDIA_TYPE = new MediaType("application", "javascript");
    public static final MediaType TEXT_JSON_TYPE = new MediaType("text", "json");
    public static final MediaType APPLICATION_PLUS_JSON_TYPE = new MediaType("application", "*+json");
    public static final String DEFAULT_CALLBACK_QUERY_PARAMETER = "callback";
    public static final MediaTypeMap<String> jsonpCompatibleMediaTypes = new MediaTypeMap();
    protected static final ObjectMapper DEFAULT_MAPPER = new ObjectMapper();
    private UriInfo uri;
    private String callbackQueryParameter = "callback";
    protected ObjectMapper objectMapper;
    protected Providers providers;

    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        String function = (String)this.uri.getQueryParameters().getFirst((Object)this.callbackQueryParameter);
        if (function != null && !function.trim().isEmpty() && !jsonpCompatibleMediaTypes.getPossible(context.getMediaType()).isEmpty()) {
            OutputStreamWriter writer = new OutputStreamWriter(context.getOutputStream());
            writer.write(function + "(");
            writer.flush();
            context.proceed();
            writer.write(")");
            writer.flush();
        } else {
            context.proceed();
        }
    }

    protected ObjectMapper getObjectMapper(Class<?> type, MediaType mediaType) {
        if (this.objectMapper != null) {
            return this.objectMapper;
        }
        if (this.providers != null) {
            ContextResolver resolver = this.providers.getContextResolver(ObjectMapper.class, mediaType);
            if (resolver == null) {
                resolver = this.providers.getContextResolver(ObjectMapper.class, null);
            }
            if (resolver != null) {
                return (ObjectMapper)resolver.getContext(type);
            }
        }
        return DEFAULT_MAPPER;
    }

    @Context
    public void setUri(UriInfo uri) {
        this.uri = uri;
    }

    @Context
    public void setProviders(Providers providers) {
        this.providers = providers;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public String getCallbackQueryParameter() {
        return this.callbackQueryParameter;
    }

    public void setCallbackQueryParameter(String callbackQueryParameter) {
        this.callbackQueryParameter = callbackQueryParameter;
    }

    static {
        jsonpCompatibleMediaTypes.add(MediaType.APPLICATION_JSON_TYPE, (Object)MediaType.APPLICATION_JSON_TYPE.toString());
        jsonpCompatibleMediaTypes.add(APPLICATION_JAVASCRIPT_MEDIA_TYPE, (Object)APPLICATION_JAVASCRIPT_MEDIA_TYPE.toString());
        jsonpCompatibleMediaTypes.add(APPLICATION_PLUS_JSON_TYPE, (Object)APPLICATION_PLUS_JSON_TYPE.toString());
        jsonpCompatibleMediaTypes.add(TEXT_JSON_TYPE, (Object)TEXT_JSON_TYPE.toString());
        jsonpCompatibleMediaTypes.add(TEXT_JAVASCRIPT_MEDIA_TYPE, (Object)TEXT_JAVASCRIPT_MEDIA_TYPE.toString());
    }
}

