/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jacorb.config.Configurable;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.giop.ClientGIOPConnection;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.ReplyListener;
import org.jacorb.orb.giop.RequestListener;
import org.jacorb.orb.giop.SelectionStrategy;
import org.jacorb.orb.giop.ServerGIOPConnection;
import org.jacorb.orb.giop.StatisticsProvider;
import org.jacorb.util.ObjectUtil;
import org.omg.ETF.Connection;
import org.omg.ETF.Profile;
import org.slf4j.Logger;

public class GIOPConnectionManager
implements Configurable {
    private Configuration configuration = null;
    private Logger logger = null;
    private final List server_giop_connections = new LinkedList();
    private int max_server_giop_connections = 0;
    private Class statistics_provider_class = null;
    private SelectionStrategy selection_strategy = null;
    private int wait_for_idle_interval = 0;

    public void configure(Configuration myConfiguration) throws ConfigurationException {
        block3: {
            this.configuration = myConfiguration;
            this.logger = this.configuration.getLogger("jacorb.orb.giop.conn");
            this.max_server_giop_connections = this.configuration.getAttributeAsInteger("jacorb.connection.max_server_connections", Integer.MAX_VALUE);
            this.selection_strategy = (SelectionStrategy)this.configuration.getAttributeAsObject("jacorb.connection.selection_strategy_class");
            this.wait_for_idle_interval = this.configuration.getAttributeAsInteger("jacorb.connection.wait_for_idle_interval", 500);
            String statisticsProviderClassName = this.configuration.getAttribute("jacorb.connection.statistics_provider_class", "");
            if (statisticsProviderClassName.length() > 0) {
                try {
                    this.statistics_provider_class = ObjectUtil.classForName(statisticsProviderClassName);
                }
                catch (Exception e) {
                    if (!this.logger.isErrorEnabled()) break block3;
                    this.logger.error("Unable to create class from property >jacorb.connection.statistics_provider_class<: " + e.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerGIOPConnection createServerGIOPConnection(Profile profile, Connection transport, RequestListener request_listener, ReplyListener reply_listener) {
        List list;
        if (this.server_giop_connections.size() >= this.max_server_giop_connections) {
            if (this.selection_strategy == null) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("No. of max server giop connections set, but no SelectionStrategy present");
                }
            } else {
                while (this.server_giop_connections.size() >= this.max_server_giop_connections) {
                    ServerGIOPConnection to_close = null;
                    list = this.server_giop_connections;
                    synchronized (list) {
                        to_close = this.selection_strategy.selectForClose(this.server_giop_connections);
                    }
                    if (to_close != null && to_close.tryClose()) break;
                    try {
                        Thread.sleep(this.wait_for_idle_interval);
                    }
                    catch (InterruptedException e) {}
                }
            }
        }
        ServerGIOPConnection connection = new ServerGIOPConnection(profile, transport, request_listener, reply_listener, this.getStatisticsProvider(), this);
        try {
            connection.configure(this.configuration);
        }
        catch (ConfigurationException ce) {
            this.logger.warn("ConfigurationException", (Throwable)ce);
        }
        list = this.server_giop_connections;
        synchronized (list) {
            this.server_giop_connections.add(connection);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("GIOPConnectionManager: created new " + connection.toString());
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterServerGIOPConnection(ServerGIOPConnection connection) {
        List list = this.server_giop_connections;
        synchronized (list) {
            this.server_giop_connections.remove(connection);
        }
    }

    public GIOPConnection createClientGIOPConnection(Profile profile, Connection transport, RequestListener request_listener, ReplyListener reply_listener) {
        ClientGIOPConnection connection = new ClientGIOPConnection(profile, transport, request_listener, reply_listener, null);
        try {
            connection.configure(this.configuration);
        }
        catch (ConfigurationException ce) {
            this.logger.warn("ConfigurationException", (Throwable)ce);
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        ArrayList connections = null;
        List list = this.server_giop_connections;
        synchronized (list) {
            connections = new ArrayList(this.server_giop_connections);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("GIOPConnectionManager.shutdown(), " + connections.size() + " connections");
        }
        for (ServerGIOPConnection connection : connections) {
            connection.tryClose();
        }
    }

    private StatisticsProvider getStatisticsProvider() {
        StatisticsProvider result;
        block3: {
            result = null;
            if (this.statistics_provider_class != null) {
                try {
                    result = (StatisticsProvider)this.statistics_provider_class.newInstance();
                }
                catch (Exception e) {
                    if (!this.logger.isErrorEnabled()) break block3;
                    this.logger.error("Unable to create instance from Class >" + this.statistics_provider_class + '<');
                }
            }
        }
        return result;
    }
}

