/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.util;

import org.codehaus.jackson.JsonNode;
import org.keycloak.Config;
import org.keycloak.util.StringPropertyReplacer;

public class JsonConfigProvider
implements Config.ConfigProvider {
    private JsonNode config;

    public JsonConfigProvider(JsonNode config) {
        this.config = config;
    }

    public String getProvider(String spi) {
        JsonNode n = this.getNode(spi, "provider");
        return n != null ? StringPropertyReplacer.replaceProperties((String)n.getTextValue()) : null;
    }

    public Config.Scope scope(String ... path) {
        return new JsonScope(this.getNode(path));
    }

    private JsonNode getNode(String ... path) {
        JsonNode n = this.config;
        for (String p : path) {
            if ((n = n.get(p)) != null) continue;
            return null;
        }
        return n;
    }

    public class JsonScope
    implements Config.Scope {
        private JsonNode config;

        public JsonScope(JsonNode config) {
            this.config = config;
        }

        public String get(String key) {
            return this.get(key, null);
        }

        public String get(String key, String defaultValue) {
            if (this.config == null) {
                return defaultValue;
            }
            JsonNode n = this.config.get(key);
            if (n == null) {
                return defaultValue;
            }
            return StringPropertyReplacer.replaceProperties((String)n.getTextValue());
        }

        public String[] getArray(String key) {
            if (this.config == null) {
                return null;
            }
            JsonNode n = this.config.get(key);
            if (n == null) {
                return null;
            }
            if (n.isArray()) {
                String[] a = new String[n.size()];
                for (int i = 0; i < a.length; ++i) {
                    a[i] = StringPropertyReplacer.replaceProperties((String)n.get(i).getTextValue());
                }
                return a;
            }
            return new String[]{StringPropertyReplacer.replaceProperties((String)n.getTextValue())};
        }

        public Integer getInt(String key) {
            return this.getInt(key, null);
        }

        public Integer getInt(String key, Integer defaultValue) {
            if (this.config == null) {
                return defaultValue;
            }
            JsonNode n = this.config.get(key);
            if (n == null) {
                return defaultValue;
            }
            if (n.isTextual()) {
                return Integer.parseInt(StringPropertyReplacer.replaceProperties((String)n.getTextValue()));
            }
            return n.getIntValue();
        }

        public Long getLong(String key) {
            return this.getLong(key, null);
        }

        public Long getLong(String key, Long defaultValue) {
            if (this.config == null) {
                return defaultValue;
            }
            JsonNode n = this.config.get(key);
            if (n == null) {
                return defaultValue;
            }
            if (n.isTextual()) {
                return Long.parseLong(StringPropertyReplacer.replaceProperties((String)n.getTextValue()));
            }
            return n.getLongValue();
        }

        public Boolean getBoolean(String key) {
            return this.getBoolean(key, null);
        }

        public Boolean getBoolean(String key, Boolean defaultValue) {
            if (this.config == null) {
                return defaultValue;
            }
            JsonNode n = this.config.get(key);
            if (n == null) {
                return defaultValue;
            }
            if (n.isTextual()) {
                return Boolean.parseBoolean(StringPropertyReplacer.replaceProperties((String)n.getTextValue()));
            }
            return n.getBooleanValue();
        }
    }
}

