/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.platform.mbean;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryManagerMXBean;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.platform.mbean.AbstractPlatformMBeanAttributeHandler;
import org.jboss.as.platform.mbean.MemoryManagerResourceDefinition;
import org.jboss.as.platform.mbean.PlatformMBeanConstants;
import org.jboss.as.platform.mbean.PlatformMBeanMessages;
import org.jboss.as.platform.mbean.PlatformMBeanUtil;
import org.jboss.dmr.ModelNode;

class MemoryManagerMXBeanAttributeHandler
extends AbstractPlatformMBeanAttributeHandler {
    static final MemoryManagerMXBeanAttributeHandler INSTANCE = new MemoryManagerMXBeanAttributeHandler();

    private MemoryManagerMXBeanAttributeHandler() {
    }

    @Override
    protected void executeReadAttribute(OperationContext context, ModelNode operation) throws OperationFailedException {
        String mmName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
        String name = operation.require("name").asString();
        MemoryManagerMXBean memoryManagerMXBean = null;
        for (MemoryManagerMXBean mbean : ManagementFactory.getMemoryManagerMXBeans()) {
            if (!mmName.equals(PlatformMBeanUtil.escapeMBeanName(mbean.getName()))) continue;
            memoryManagerMXBean = mbean;
        }
        if (memoryManagerMXBean == null) {
            throw PlatformMBeanMessages.MESSAGES.unknownMemoryManager(mmName);
        }
        if (PlatformMBeanUtil.JVM_MAJOR_VERSION > 6 && PlatformMBeanConstants.OBJECT_NAME.getName().equals(name)) {
            String objName = PlatformMBeanUtil.getObjectNameStringWithNameKey("java.lang:type=MemoryManager", mmName);
            context.getResult().set(objName);
        } else if ("name".equals(name)) {
            context.getResult().set(PlatformMBeanUtil.escapeMBeanName(memoryManagerMXBean.getName()));
        } else if (PlatformMBeanConstants.VALID.getName().equals(name)) {
            context.getResult().set(memoryManagerMXBean.isValid());
        } else if ("memory-pool-names".equals(name)) {
            ModelNode result = context.getResult();
            result.setEmptyList();
            for (String pool : memoryManagerMXBean.getMemoryPoolNames()) {
                result.add(PlatformMBeanUtil.escapeMBeanName(pool));
            }
        } else {
            if (MemoryManagerResourceDefinition.MEMORY_MANAGER_READ_ATTRIBUTES.contains(name)) {
                throw PlatformMBeanMessages.MESSAGES.badReadAttributeImpl5(name);
            }
            throw MemoryManagerMXBeanAttributeHandler.unknownAttribute(operation);
        }
    }

    @Override
    protected void executeWriteAttribute(OperationContext context, ModelNode operation) throws OperationFailedException {
        throw MemoryManagerMXBeanAttributeHandler.unknownAttribute(operation);
    }
}

