/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.access.management;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.access.Authorizer;
import org.jboss.as.controller.access.AuthorizerConfiguration;
import org.jboss.as.controller.access.Caller;
import org.jboss.as.controller.access.CombinationPolicy;
import org.jboss.as.controller.access.management.AccessConstraintKey;
import org.jboss.as.controller.access.management.AccessConstraintUtilization;
import org.jboss.as.controller.access.management.AccessConstraintUtilizationImpl;
import org.jboss.as.controller.access.management.AccessConstraintUtilizationRegistry;
import org.jboss.as.controller.access.management.ApplicationTypeAccessConstraintDefinition;
import org.jboss.as.controller.access.rbac.StandardRBACAuthorizer;

public class WritableAuthorizerConfiguration
implements AuthorizerConfiguration,
AccessConstraintUtilizationRegistry {
    private volatile Map<String, RoleMappingImpl> roleMappings = new HashMap<String, RoleMappingImpl>();
    private final Map<Object, RoleMappingImpl> removedRoles = new WeakHashMap<Object, RoleMappingImpl>();
    private final Map<AccessConstraintKey, Map<PathAddress, AccessConstraintUtilization>> accessConstraintUtilization = new HashMap<AccessConstraintKey, Map<PathAddress, AccessConstraintUtilization>>();
    private volatile CombinationPolicy combinationPolicy = CombinationPolicy.PERMISSIVE;
    private volatile boolean useRealmRoles;
    private volatile boolean nonFacadeMBeansSensitive;
    private volatile Authorizer.AuthorizerDescription authorizerDescription;
    private volatile RoleMaps roleMaps;
    private final Set<AuthorizerConfiguration.ScopedRoleListener> scopedRoleListeners = new LinkedHashSet<AuthorizerConfiguration.ScopedRoleListener>();

    public WritableAuthorizerConfiguration(Authorizer.AuthorizerDescription authorizerDescription) {
        this.authorizerDescription = authorizerDescription;
        this.roleMaps = new RoleMaps(authorizerDescription.getStandardRoles(), Collections.emptyMap());
    }

    public synchronized void reset() {
        this.authorizerDescription = StandardRBACAuthorizer.AUTHORIZER_DESCRIPTION;
        this.nonFacadeMBeansSensitive = false;
        this.useRealmRoles = false;
        this.roleMappings = new HashMap<String, RoleMappingImpl>();
        RoleMaps oldRoleMaps = this.roleMaps;
        this.roleMaps = new RoleMaps(this.authorizerDescription.getStandardRoles(), Collections.emptyMap());
        for (AuthorizerConfiguration.ScopedRole role : oldRoleMaps.scopedRoles.values()) {
            for (AuthorizerConfiguration.ScopedRoleListener listener : this.scopedRoleListeners) {
                try {
                    listener.scopedRoleRemoved(role);
                }
                catch (Exception ignored) {}
            }
        }
    }

    @Override
    public synchronized void registerScopedRoleListener(AuthorizerConfiguration.ScopedRoleListener listener) {
        this.scopedRoleListeners.add(listener);
    }

    @Override
    public synchronized void unregisterScopedRoleListener(AuthorizerConfiguration.ScopedRoleListener listener) {
        this.scopedRoleListeners.remove(listener);
    }

    @Override
    public CombinationPolicy getPermissionCombinationPolicy() {
        return this.combinationPolicy;
    }

    @Override
    public boolean isRoleBased() {
        return this.authorizerDescription.isRoleBased();
    }

    @Override
    public boolean isMapUsingRealmRoles() {
        return this.useRealmRoles;
    }

    @Override
    public Set<String> getStandardRoles() {
        return this.roleMaps.standardRoles;
    }

    @Override
    public Map<String, AuthorizerConfiguration.ScopedRole> getScopedRoles() {
        return this.roleMaps.scopedRoles;
    }

    @Override
    public Set<String> getAllRoles() {
        return this.roleMaps.allRoles;
    }

    @Override
    public boolean hasRole(String roleName) {
        Set canonicalRoles = this.roleMaps.canonicalRoles;
        return canonicalRoles.contains(WritableAuthorizerConfiguration.getOfficialForm(roleName));
    }

    @Override
    public Map<String, AuthorizerConfiguration.RoleMapping> getRoleMappings() {
        return Collections.unmodifiableMap(this.roleMappings);
    }

    public synchronized void addScopedRole(AuthorizerConfiguration.ScopedRole toAdd) {
        for (AuthorizerConfiguration.ScopedRoleListener listener : this.scopedRoleListeners) {
            listener.scopedRoleAdded(toAdd);
        }
        HashMap<String, AuthorizerConfiguration.ScopedRole> newScopedRoles = new HashMap<String, AuthorizerConfiguration.ScopedRole>(this.roleMaps.scopedRoles);
        newScopedRoles.put(toAdd.getName(), toAdd);
        this.roleMaps = new RoleMaps(this.roleMaps.standardRoles, newScopedRoles);
    }

    public synchronized void removeScopedRole(String toRemove) {
        HashMap newScopedRoles = new HashMap(this.roleMaps.scopedRoles);
        AuthorizerConfiguration.ScopedRole removed = (AuthorizerConfiguration.ScopedRole)newScopedRoles.remove(toRemove);
        this.roleMaps = new RoleMaps(this.roleMaps.standardRoles, newScopedRoles);
        if (removed != null) {
            for (AuthorizerConfiguration.ScopedRoleListener listener : this.scopedRoleListeners) {
                listener.scopedRoleRemoved(removed);
            }
        }
    }

    @Override
    public boolean isNonFacadeMBeansSensitive() {
        return this.nonFacadeMBeansSensitive;
    }

    public void addRoleMappingImmediate(String roleName) {
        this.roleMappings.put(roleName, new RoleMappingImpl(roleName));
    }

    public synchronized void addRoleMapping(String roleName) {
        HashMap<String, RoleMappingImpl> newRoles = new HashMap<String, RoleMappingImpl>(this.roleMappings);
        if (!newRoles.containsKey(roleName)) {
            newRoles.put(roleName, new RoleMappingImpl(roleName));
            this.roleMappings = Collections.unmodifiableMap(newRoles);
        }
    }

    public synchronized Object removeRoleMapping(String roleName) {
        HashMap<String, RoleMappingImpl> newRoles = new HashMap<String, RoleMappingImpl>(this.roleMappings);
        if (newRoles.containsKey(roleName)) {
            RoleMappingImpl removed = newRoles.remove(roleName);
            Object removalKey = new Object();
            this.removedRoles.put(removalKey, removed);
            this.roleMappings = Collections.unmodifiableMap(newRoles);
            return removalKey;
        }
        return null;
    }

    public synchronized boolean undoRoleMappingRemove(Object removalKey) {
        HashMap<String, RoleMappingImpl> newRoles = new HashMap<String, RoleMappingImpl>(this.roleMappings);
        RoleMappingImpl toRestore = this.removedRoles.remove(removalKey);
        if (toRestore != null && !newRoles.containsKey(toRestore.getName())) {
            newRoles.put(toRestore.getName(), toRestore);
            this.roleMappings = Collections.unmodifiableMap(newRoles);
            return true;
        }
        return false;
    }

    public void setRoleMappingIncludeAll(String roleName, boolean includeAll) {
        RoleMappingImpl role = this.roleMappings.get(roleName);
        role.setIncludeAll(includeAll);
    }

    public boolean addRoleMappingPrincipal(String roleName, AuthorizerConfiguration.PrincipalType principalType, MatchType matchType, String name, String realm, boolean immediate) {
        RoleMappingImpl role = this.roleMappings.get(roleName);
        if (role != null) {
            if (immediate) {
                return role.addPrincipalImmediate(this.createPrincipal(principalType, name, realm), matchType);
            }
            return role.addPrincipal(this.createPrincipal(principalType, name, realm), matchType);
        }
        return false;
    }

    public boolean removeRoleMappingPrincipal(String roleName, AuthorizerConfiguration.PrincipalType principalType, MatchType matchType, String name, String realm) {
        RoleMappingImpl role = this.roleMappings.get(roleName);
        if (role != null) {
            return role.removePrincipal(this.createPrincipal(principalType, name, realm), matchType);
        }
        return false;
    }

    public AuthorizerConfiguration.MappingPrincipal createPrincipal(AuthorizerConfiguration.PrincipalType principalType, String name, String realm) {
        return new MappingPrincipalImpl(principalType, name, realm);
    }

    public void setPermissionCombinationPolicy(CombinationPolicy combinationPolicy) {
        assert (combinationPolicy != null) : "combinationPolicy is null";
        this.combinationPolicy = combinationPolicy;
    }

    void setNonFacadeMBeansSensitive(boolean nonFacadeMBeansSensitive) {
        this.nonFacadeMBeansSensitive = nonFacadeMBeansSensitive;
    }

    synchronized void setAuthorizerDescription(Authorizer.AuthorizerDescription authorizerDescription) {
        this.authorizerDescription = authorizerDescription;
        this.roleMaps = new RoleMaps(authorizerDescription.getStandardRoles(), this.roleMaps.scopedRoles);
    }

    private static String getOfficialForm(String roleName) {
        return roleName == null ? null : roleName.toUpperCase(Locale.ENGLISH);
    }

    @Override
    public synchronized Map<PathAddress, AccessConstraintUtilization> getAccessConstraintUtilizations(AccessConstraintKey accessConstraintKey) {
        Map<PathAddress, AccessConstraintUtilization> result = this.getAccessConstraintUtilizations(accessConstraintKey, false);
        return result == null ? Collections.emptyMap() : Collections.unmodifiableMap(result);
    }

    private Map<PathAddress, AccessConstraintUtilization> getAccessConstraintUtilizations(AccessConstraintKey constraintKey, boolean addIfNull) {
        Map<PathAddress, AccessConstraintUtilization> result = this.accessConstraintUtilization.get(constraintKey);
        if (result == null && addIfNull) {
            result = new HashMap<PathAddress, AccessConstraintUtilization>();
            this.accessConstraintUtilization.put(constraintKey, result);
        }
        return result;
    }

    @Override
    public synchronized void registerAccessConstraintResourceUtilization(AccessConstraintKey key, PathAddress address) {
        AccessConstraintUtilizationImpl acu = this.getAccessConstraintUtilizationImpl(key, address);
        acu.setResourceConstrained(true);
    }

    @Override
    public synchronized void registerAccessConstraintAttributeUtilization(AccessConstraintKey key, PathAddress address, String attribute) {
        AccessConstraintUtilizationImpl acu = this.getAccessConstraintUtilizationImpl(key, address);
        acu.addAttribute(attribute);
    }

    @Override
    public synchronized void registerAccessConstraintOperationUtilization(AccessConstraintKey key, PathAddress address, String operation) {
        AccessConstraintUtilizationImpl acu = this.getAccessConstraintUtilizationImpl(key, address);
        acu.addOperation(operation);
    }

    @Override
    public synchronized void unregisterAccessConstraintUtilizations(PathAddress address) {
        for (Map<PathAddress, AccessConstraintUtilization> map : this.accessConstraintUtilization.values()) {
            map.remove(address);
        }
    }

    private AccessConstraintUtilizationImpl getAccessConstraintUtilizationImpl(AccessConstraintKey key, PathAddress address) {
        Map<PathAddress, AccessConstraintUtilization> map = this.getAccessConstraintUtilizations(key, true);
        AccessConstraintUtilizationImpl acu = (AccessConstraintUtilizationImpl)map.get(address);
        if (acu == null) {
            if (key.isCore() && ApplicationTypeAccessConstraintDefinition.DEPLOYMENT.getName().equals(key.getName()) && ApplicationTypeAccessConstraintDefinition.DEPLOYMENT.getType().equals(key.getType())) assert (!address.toString().contains("subsystem")) : "Invalid use of " + key + " in a subsystem; reserved for core use";
            acu = new AccessConstraintUtilizationImpl(key, address);
            map.put(address, acu);
        }
        return acu;
    }

    private static class RoleMaps {
        private final Set<String> standardRoles;
        private final Map<String, AuthorizerConfiguration.ScopedRole> scopedRoles;
        private final Set<String> allRoles;
        private final Set<String> canonicalRoles;

        private RoleMaps(Set<String> standardRoles, Map<String, AuthorizerConfiguration.ScopedRole> scopedRoles) {
            this.standardRoles = standardRoles;
            this.scopedRoles = scopedRoles;
            HashSet<String> allRoles = new HashSet<String>();
            allRoles.addAll(standardRoles);
            allRoles.addAll(scopedRoles.keySet());
            this.allRoles = Collections.unmodifiableSet(allRoles);
            HashSet<String> canonicalRoles = new HashSet<String>();
            for (String r : allRoles) {
                canonicalRoles.add(WritableAuthorizerConfiguration.getOfficialForm(r));
            }
            this.canonicalRoles = Collections.unmodifiableSet(canonicalRoles);
        }
    }

    private static final class MappingPrincipalImpl
    implements AuthorizerConfiguration.MappingPrincipal {
        private final AuthorizerConfiguration.PrincipalType type;
        private final String realm;
        private final String name;
        private final int hashCode;

        private MappingPrincipalImpl(AuthorizerConfiguration.PrincipalType type, String name, String realm) {
            this.type = type;
            this.name = name;
            this.realm = realm;
            this.hashCode = type.ordinal() * name.hashCode() * (realm == null ? 31 : realm.hashCode());
        }

        @Override
        public AuthorizerConfiguration.PrincipalType getType() {
            return this.type;
        }

        @Override
        public String getRealm() {
            return this.realm;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            return obj instanceof MappingPrincipalImpl && this.equals((MappingPrincipalImpl)obj);
        }

        private boolean equals(MappingPrincipalImpl obj) {
            return this.type == obj.type && this.name.equals(obj.name) && (this.realm == null ? obj.realm == null : this.realm.equals(obj.realm));
        }

        public String toString() {
            return "Principal [type=" + (Object)((Object)this.type) + ", realm=" + this.realm + ", name=" + this.name + "]";
        }
    }

    private static final class RoleMappingImpl
    implements AuthorizerConfiguration.RoleMapping {
        private final String name;
        private boolean includeAll;
        private volatile Set<AuthorizerConfiguration.MappingPrincipal> includes = new HashSet<AuthorizerConfiguration.MappingPrincipal>();
        private volatile Set<AuthorizerConfiguration.MappingPrincipal> excludes = new HashSet<AuthorizerConfiguration.MappingPrincipal>();

        private RoleMappingImpl(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("[Role name='" + this.name + "' ");
            sb.append("{Includes = ");
            for (AuthorizerConfiguration.MappingPrincipal current : this.includes) {
                sb.append(current.toString());
            }
            sb.append("}");
            sb.append("{Excludes = ");
            for (AuthorizerConfiguration.MappingPrincipal current : this.excludes) {
                sb.append(current.toString());
            }
            sb.append("}");
            sb.append("]");
            return sb.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean addPrincipalImmediate(AuthorizerConfiguration.MappingPrincipal principal, MatchType matchType) {
            Set<AuthorizerConfiguration.MappingPrincipal> set = this.getSet(matchType, true);
            try {
                boolean bl = set.add(principal);
                return bl;
            }
            finally {
                this.setSet(set, matchType, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized boolean addPrincipal(AuthorizerConfiguration.MappingPrincipal principal, MatchType matchType) {
            Set<AuthorizerConfiguration.MappingPrincipal> set = this.getSet(matchType, false);
            try {
                boolean bl = set.add(principal);
                return bl;
            }
            finally {
                this.setSet(set, matchType, false);
            }
        }

        private void setIncludeAll(boolean includeAll) {
            this.includeAll = includeAll;
        }

        @Override
        public boolean includeAllAuthedUsers() {
            return this.includeAll;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized boolean removePrincipal(AuthorizerConfiguration.MappingPrincipal principal, MatchType matchType) {
            Set<AuthorizerConfiguration.MappingPrincipal> set = this.getSet(matchType, false);
            try {
                boolean bl = set.remove(principal);
                return bl;
            }
            finally {
                this.setSet(set, matchType, false);
            }
        }

        @Override
        public AuthorizerConfiguration.MappingPrincipal isIncluded(Caller caller) {
            return this.isInSet(caller, this.includes);
        }

        @Override
        public AuthorizerConfiguration.MappingPrincipal isExcluded(Caller caller) {
            return this.isInSet(caller, this.excludes);
        }

        private AuthorizerConfiguration.MappingPrincipal isInSet(Caller caller, Set<AuthorizerConfiguration.MappingPrincipal> theSet) {
            String accountName = null;
            String realm = null;
            Set<String> groups = null;
            for (AuthorizerConfiguration.MappingPrincipal current : theSet) {
                String expectedRealm = current.getRealm();
                switch (current.getType()) {
                    case USER: {
                        if (expectedRealm != null) {
                            accountName = this.getAccountName(caller, accountName);
                            if (!current.getName().equals(accountName) || !expectedRealm.equals(realm = this.getRealmName(caller, realm))) break;
                            return current;
                        }
                        accountName = this.getAccountName(caller, accountName);
                        if (!current.getName().equals(accountName)) break;
                        return current;
                    }
                    case GROUP: {
                        if (!(expectedRealm != null ? (groups = this.getGroups(caller, groups)).contains(current.getName()) && expectedRealm.equals(realm = this.getRealmName(caller, realm)) : (groups = this.getGroups(caller, groups)).contains(current.getName()))) break;
                        return current;
                    }
                }
            }
            return null;
        }

        private String getAccountName(Caller caller, String currentValue) {
            return currentValue != null ? currentValue : caller.getName();
        }

        private String getRealmName(Caller caller, String currentValue) {
            return currentValue != null ? currentValue : caller.getRealm();
        }

        private Set<String> getGroups(Caller caller, Set<String> currentValue) {
            return currentValue != null ? currentValue : caller.getAssociatedGroups();
        }

        private Set<AuthorizerConfiguration.MappingPrincipal> getSet(MatchType matchType, boolean immediate) {
            HashSet set;
            switch (matchType) {
                case INCLUDE: {
                    set = this.includes;
                    break;
                }
                default: {
                    set = this.excludes;
                }
            }
            return immediate ? set : new HashSet(set);
        }

        private void setSet(Set<AuthorizerConfiguration.MappingPrincipal> set, MatchType matchType, boolean immediate) {
            if (!immediate) {
                switch (matchType) {
                    case INCLUDE: {
                        this.includes = Collections.unmodifiableSet(set);
                        break;
                    }
                    case EXCLUDE: {
                        this.excludes = Collections.unmodifiableSet(set);
                    }
                }
            }
        }
    }

    public static enum MatchType {
        EXCLUDE,
        INCLUDE;

    }
}

