/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.lang.reflect.Constructor;
import java.util.StringTokenizer;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.giop.ReplyInputStream;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.Any;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.CompletionStatusHelper;
import org.omg.CORBA.ORB;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.IOP.ServiceContext;

public class SystemExceptionHelper {
    private SystemExceptionHelper() {
    }

    private static final String className(String repId) {
        String id_base = repId.substring(4, repId.lastIndexOf(58));
        return SystemExceptionHelper.ir2scopes("org.omg", id_base.substring(7));
    }

    private static final String ir2scopes(String prefix, String s) {
        if (s.indexOf(47) < 0) {
            return s;
        }
        StringTokenizer strtok = new StringTokenizer(s, "/");
        int count = strtok.countTokens();
        StringBuffer buffer = new StringBuffer();
        buffer.append(prefix);
        int i = 0;
        while (strtok.hasMoreTokens()) {
            String nextToken = strtok.nextToken();
            try {
                if (buffer.length() > 0) {
                    ObjectUtil.classForName(buffer.toString() + "." + nextToken);
                } else {
                    ObjectUtil.classForName(nextToken);
                }
                if (i < count - 1) {
                    buffer.append('.');
                    buffer.append(nextToken);
                    buffer.append("Package");
                } else {
                    buffer.append('.');
                    buffer.append(nextToken);
                }
            }
            catch (ClassNotFoundException cnfe) {
                if (buffer.length() > 0) {
                    buffer.append('.');
                    buffer.append(nextToken);
                }
                buffer.append(nextToken);
            }
            ++i;
        }
        return buffer.toString();
    }

    private static final String repId(Class clazz) {
        String className = clazz.getName();
        String body = className.substring(7);
        return "IDL:omg.org/" + SystemExceptionHelper.scopesToIR(body) + ":1.0";
    }

    private static final String scopesToIR(String s) {
        if (s.indexOf(46) < 0) {
            return s;
        }
        StringTokenizer strtok = new StringTokenizer(s, ".");
        String[] scopes = new String[strtok.countTokens()];
        int i = 0;
        while (strtok.hasMoreTokens()) {
            String nextToken = strtok.nextToken();
            scopes[i] = nextToken.endsWith("Package") ? nextToken.substring(0, nextToken.indexOf("Package")) : nextToken;
            ++i;
        }
        StringBuffer buffer = new StringBuffer();
        if (scopes.length > 1) {
            for (int i2 = 0; i2 < scopes.length - 1; ++i2) {
                buffer.append(scopes[i2]);
                buffer.append('/');
            }
        }
        buffer.append(scopes[scopes.length - 1]);
        return buffer.toString();
    }

    public static void insert(Any any, SystemException exception) {
        any.type(SystemExceptionHelper.type(exception));
        SystemExceptionHelper.write(any.create_output_stream(), exception);
    }

    public static TypeCode type(SystemException exception) {
        String name = exception.getClass().getName();
        name = name.substring(name.lastIndexOf(46) + 1);
        ORB orb = ORB.init();
        TypeCode _type = orb.create_struct_tc("IDL:omg.org/CORBA/" + name + ":1.0", name, new StructMember[]{new StructMember("minor", orb.get_primitive_tc(TCKind.from_int(3)), null), new StructMember("completed", orb.create_enum_tc("IDL:omg.org/CORBA/CompletionStatus:1.0", "CompletionStatus", new String[]{"COMPLETED_YES", "COMPLETED_NO", "COMPLETED_MAYBE"}), null)});
        return _type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SystemException read(InputStream in) {
        String message;
        CompletionStatus completed;
        int minor;
        String className;
        block9: {
            className = SystemExceptionHelper.className(in.read_string());
            minor = in.read_long();
            completed = CompletionStatusHelper.read(in);
            message = null;
            if (in instanceof ReplyInputStream) {
                ReplyInputStream input = (ReplyInputStream)in;
                try {
                    ServiceContext context = input.getServiceContext(14);
                    if (context == null) break block9;
                    CDRInputStream data = new CDRInputStream(null, context.context_data);
                    try {
                        data.openEncapsulatedArray();
                        message = data.read_wstring();
                    }
                    finally {
                        data.close();
                    }
                }
                finally {
                    input.close();
                }
            }
        }
        try {
            Class clazz = ObjectUtil.classForName(className);
            Constructor ctor = clazz.getConstructor(String.class, Integer.TYPE, CompletionStatus.class);
            return (SystemException)ctor.newInstance("Server-side Exception: " + message, ObjectUtil.newInteger(minor), completed);
        }
        catch (Exception e) {
            return (SystemException)new UNKNOWN(className).initCause(e);
        }
    }

    public static void write(OutputStream out, SystemException exception) {
        out.write_string(SystemExceptionHelper.repId(exception.getClass()));
        out.write_long(exception.minor);
        CompletionStatusHelper.write(out, exception.completed);
    }
}

