/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.adapters.jdbc;

import java.io.Serializable;
import java.sql.SQLException;
import java.sql.Wrapper;

public class JBossWrapper
implements Serializable {
    private static final long serialVersionUID = -4097918663681033085L;

    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (iface == null) {
            throw new IllegalArgumentException("Null interface");
        }
        if (iface.isAssignableFrom(this.getClass())) {
            return true;
        }
        Object wrapped = this.unwrapInnerMost(this.getWrappedObject(), iface);
        if (wrapped == null) {
            return false;
        }
        return iface.isAssignableFrom(wrapped.getClass());
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface == null) {
            throw new IllegalArgumentException("Null interface");
        }
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        Object wrapped = this.unwrapInnerMost(this.getWrappedObject(), iface);
        if (wrapped != null && iface.isAssignableFrom(wrapped.getClass())) {
            return iface.cast(wrapped);
        }
        throw new SQLException("Not a wrapper for: " + iface.getName());
    }

    protected Object getWrappedObject() throws SQLException {
        return null;
    }

    private Object unwrapInnerMost(Object o, Class<?> clz) {
        if (o == null) {
            return null;
        }
        if (!(o instanceof Wrapper)) {
            return o;
        }
        Wrapper w = (Wrapper)o;
        try {
            if (!w.isWrapperFor(clz)) {
                return o;
            }
        }
        catch (SQLException se) {
            return o;
        }
        Object result = o;
        try {
            result = ((Wrapper)o).unwrap(clz);
        }
        catch (SQLException se) {
            // empty catch block
        }
        return result;
    }
}

