/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.cache.distributable;

import java.util.Deque;
import java.util.LinkedList;
import org.jboss.as.ejb3.EjbMessages;
import org.wildfly.clustering.ejb.Batch;

public class BatchStack {
    private static final ThreadLocal<Deque<Batch>> BATCH_STACK = new ThreadLocal<Deque<Batch>>(){

        @Override
        protected Deque<Batch> initialValue() {
            return new LinkedList<Batch>();
        }
    };

    public static void pushBatch(Batch batch) {
        BATCH_STACK.get().addLast(batch);
    }

    public static Batch popBatch() {
        Deque<Batch> stack = BATCH_STACK.get();
        if (stack.isEmpty()) {
            throw EjbMessages.MESSAGES.asymmetricCacheUsage();
        }
        return stack.removeLast();
    }

    private BatchStack() {
    }
}

