/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.security;

import java.lang.reflect.Method;
import java.security.PrivilegedExceptionAction;
import org.jboss.weld.security.GetDeclaredMethodAction;

public class MethodLookupAction
extends GetDeclaredMethodAction
implements PrivilegedExceptionAction<Method> {
    public MethodLookupAction(Class<?> javaClass, String methodName, Class<?>[] parameterTypes) {
        super(javaClass, methodName, parameterTypes);
    }

    @Override
    public Method run() throws NoSuchMethodException {
        return this.lookupMethod(this.javaClass, this.methodName, this.parameterTypes);
    }

    private Method lookupMethod(Class<?> javaClass, String methodName, Class<?>[] parameterTypes) throws NoSuchMethodException {
        for (Class<?> inspectedClass = javaClass; inspectedClass != null; inspectedClass = inspectedClass.getSuperclass()) {
            for (Class<?> inspectedInterface : inspectedClass.getInterfaces()) {
                try {
                    return this.lookupMethod(inspectedInterface, methodName, parameterTypes);
                }
                catch (NoSuchMethodException e) {
                }
            }
            try {
                return inspectedClass.getDeclaredMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException nsme) {
                continue;
            }
        }
        throw new NoSuchMethodException();
    }
}

