/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.async;

import java.util.concurrent.locks.AbstractQueuedSynchronizer;

class BufferLock {
    private final Sync sync = new Sync();
    private final Counter counter;
    private final Available available;

    BufferLock(int size) {
        this.counter = size > 0 ? new Counter(size) : null;
        this.available = new Available();
    }

    void writeLock(int count) {
        if (this.counter != null) {
            this.counter.acquireShared(count);
        }
        this.sync.acquireShared(1);
    }

    void writeUnlock() {
        this.sync.releaseShared(1);
        this.available.releaseShared(1);
    }

    void readLock() {
        this.available.acquireShared(1);
        this.sync.acquire(1);
    }

    void readUnlock() {
        this.sync.release(1);
    }

    void reset(int count) {
        if (this.counter != null) {
            this.counter.releaseShared(count);
        }
        this.available.releaseShared(count);
    }

    void add(int count) {
        if (this.counter != null) {
            count = this.counter.add(count);
        }
        this.available.releaseShared(count);
    }

    private static class Sync
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = 2983687000985096017L;

        private Sync() {
        }

        @Override
        protected boolean tryAcquire(int unused) {
            if (!this.compareAndSetState(0, -1)) {
                return false;
            }
            this.setExclusiveOwnerThread(Thread.currentThread());
            return true;
        }

        @Override
        protected boolean tryRelease(int unused) {
            this.setExclusiveOwnerThread(null);
            this.setState(0);
            return true;
        }

        @Override
        protected int tryAcquireShared(int unused) {
            int state;
            do {
                if ((state = this.getState()) >= 0) continue;
                return -1;
            } while (!this.compareAndSetState(state, state + 1));
            return 1;
        }

        @Override
        protected boolean tryReleaseShared(int unused) {
            int state;
            while (!this.compareAndSetState(state = this.getState(), state - 1)) {
            }
            return true;
        }
    }

    private static class Available
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = 6464514100313353749L;

        private Available() {
        }

        @Override
        protected int tryAcquireShared(int unused) {
            return this.getState() > 0 ? 1 : -1;
        }

        @Override
        protected boolean tryReleaseShared(int state) {
            this.setState(state > 0 ? 1 : 0);
            return state > 0;
        }
    }

    private static class Counter
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = 1688655561670368887L;
        private final int size;

        Counter(int size) {
            this.size = size;
        }

        int add(int count) {
            int state;
            while (!this.compareAndSetState(state = this.getState(), state + count)) {
            }
            return state + count;
        }

        @Override
        protected int tryAcquireShared(int count) {
            int state;
            do {
                if ((state = this.getState()) < this.size) continue;
                return -1;
            } while (!this.compareAndSetState(state, state + count));
            return state + count >= this.size ? 0 : 1;
        }

        @Override
        protected boolean tryReleaseShared(int state) {
            this.setState(state);
            return state < this.size;
        }
    }
}

