/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.singleton;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.clustering.msc.AsynchronousService;
import org.jboss.as.clustering.msc.DelegatingServiceBuilder;
import org.jboss.as.clustering.msc.ServiceContainerHelper;
import org.jboss.as.clustering.msc.ServiceControllerFactory;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.clustering.dispatcher.CommandDispatcher;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.dispatcher.CommandResponse;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.provider.ServiceProviderRegistration;
import org.wildfly.clustering.provider.ServiceProviderRegistrationFactory;
import org.wildfly.clustering.server.dispatcher.CommandDispatcherFactoryProvider;
import org.wildfly.clustering.server.group.CacheGroupProvider;
import org.wildfly.clustering.server.provider.ServiceProviderRegistrationFactoryProvider;
import org.wildfly.clustering.server.singleton.SingletonContext;
import org.wildfly.clustering.server.singleton.SingletonLogger;
import org.wildfly.clustering.server.singleton.SingletonMessages;
import org.wildfly.clustering.server.singleton.SingletonValueCommand;
import org.wildfly.clustering.server.singleton.StopSingletonCommand;
import org.wildfly.clustering.singleton.Singleton;
import org.wildfly.clustering.singleton.SingletonElectionPolicy;
import org.wildfly.clustering.singleton.election.SimpleSingletonElectionPolicy;

public class SingletonService<T extends Serializable>
implements Service<T>,
ServiceProviderRegistration.Listener,
SingletonContext<T>,
Singleton {
    public static final String DEFAULT_CONTAINER = "server";
    public static final String DEFAULT_CACHE = "default";
    private final InjectedValue<Group> group = new InjectedValue();
    private final InjectedValue<ServiceProviderRegistrationFactory> registrationFactory = new InjectedValue();
    private final InjectedValue<CommandDispatcherFactory> dispatcherFactory = new InjectedValue();
    private final Service<T> service;
    final ServiceName targetServiceName;
    final ServiceName singletonServiceName;
    private final AtomicBoolean master = new AtomicBoolean(false);
    private final SingletonContext<T> singletonDispatcher = new SingletonDispatcher();
    volatile ServiceProviderRegistration registration;
    volatile CommandDispatcher<SingletonContext<T>> dispatcher;
    volatile boolean started = false;
    private volatile SingletonElectionPolicy electionPolicy = new SimpleSingletonElectionPolicy();
    private volatile ServiceRegistry container;
    volatile int quorum = 1;

    public SingletonService(ServiceName serviceName, Service<T> service) {
        this.singletonServiceName = serviceName;
        this.targetServiceName = serviceName.append(new String[]{"service"});
        this.service = service;
    }

    public ServiceBuilder<T> build(ServiceTarget target) {
        return this.build(target, DEFAULT_CONTAINER);
    }

    public ServiceBuilder<T> build(ServiceTarget target, String containerName) {
        return this.build(target, containerName, DEFAULT_CACHE);
    }

    public ServiceBuilder<T> build(ServiceTarget target, String containerName, String cacheName) {
        ServiceBuilder serviceBuilder = target.addService(this.targetServiceName, this.service).setInitialMode(ServiceController.Mode.NEVER);
        AbstractServiceListener listener = new AbstractServiceListener<T>(){

            public void serviceRemoveRequested(ServiceController<? extends T> controller) {
                ServiceController service = controller.getServiceContainer().getService(SingletonService.this.targetServiceName);
                if (service != null) {
                    service.setMode(ServiceController.Mode.REMOVE);
                }
            }
        };
        final ServiceBuilder singletonBuilder = AsynchronousService.addService((ServiceTarget)target, (ServiceName)this.singletonServiceName, (Service)this).addAliases(new ServiceName[]{this.singletonServiceName.append(new String[]{"singleton"})}).addDependency(CacheGroupProvider.getServiceName(containerName, cacheName), Group.class, this.group).addDependency(ServiceProviderRegistrationFactoryProvider.getServiceName(containerName, cacheName), ServiceProviderRegistrationFactory.class, this.registrationFactory).addDependency(CommandDispatcherFactoryProvider.getServiceName(containerName), CommandDispatcherFactory.class, this.dispatcherFactory).addListener((ServiceListener)listener);
        return new DelegatingServiceBuilder<T>(serviceBuilder, ServiceControllerFactory.SIMPLE){

            public ServiceBuilder<T> addAliases(ServiceName ... aliases) {
                singletonBuilder.addAliases(aliases);
                return this;
            }

            public ServiceBuilder<T> setInitialMode(ServiceController.Mode mode) {
                singletonBuilder.setInitialMode(mode);
                return this;
            }

            public ServiceController<T> install() {
                super.install();
                return singletonBuilder.install();
            }
        };
    }

    public void start(StartContext context) {
        this.container = context.getController().getServiceContainer();
        this.dispatcher = ((CommandDispatcherFactory)this.dispatcherFactory.getValue()).createCommandDispatcher((Object)this.singletonServiceName, (Object)this);
        this.registration = ((ServiceProviderRegistrationFactory)this.registrationFactory.getValue()).createRegistration((Object)this.singletonServiceName, (ServiceProviderRegistration.Listener)this);
        this.started = true;
    }

    public void stop(StopContext context) {
        this.started = false;
        this.registration.close();
        this.dispatcher.close();
    }

    public boolean isMaster() {
        return this.master.get();
    }

    public void setElectionPolicy(SingletonElectionPolicy electionPolicy) {
        this.electionPolicy = electionPolicy;
    }

    public void setQuorum(int quorum) {
        this.quorum = quorum;
    }

    public void providersChanged(Set<Node> nodes) {
        if (this.elected(nodes)) {
            if (!this.master.get()) {
                SingletonLogger.ROOT_LOGGER.electedMaster(this.singletonServiceName.getCanonicalName());
                this.singletonDispatcher.stopOldMaster();
                this.startNewMaster();
            }
        } else if (this.master.get()) {
            SingletonLogger.ROOT_LOGGER.electedSlave(this.singletonServiceName.getCanonicalName());
            this.stopOldMaster();
        }
    }

    private boolean elected(Set<Node> candidates) {
        Node elected;
        int size = candidates.size();
        if (size < this.quorum) {
            SingletonLogger.ROOT_LOGGER.quorumNotReached(this.singletonServiceName.getCanonicalName(), this.quorum);
            return false;
        }
        if (size == this.quorum) {
            SingletonLogger.ROOT_LOGGER.quorumJustReached(this.singletonServiceName.getCanonicalName(), this.quorum);
        }
        if ((elected = this.election(candidates)) != null) {
            SingletonLogger.ROOT_LOGGER.elected(elected.getName(), this.singletonServiceName.getCanonicalName());
        }
        return elected != null ? elected.equals(((Group)this.group.getValue()).getLocalNode()) : false;
    }

    private Node election(Set<Node> candidates) {
        SingletonElectionPolicy policy = this.electionPolicy;
        List nodes = ((Group)this.group.getValue()).getNodes();
        nodes.retainAll(candidates);
        return !nodes.isEmpty() ? policy.elect(nodes) : null;
    }

    private void startNewMaster() {
        this.master.set(true);
        ServiceController service = this.container.getRequiredService(this.targetServiceName);
        try {
            ServiceContainerHelper.start((ServiceController)service);
        }
        catch (StartException e) {
            SingletonLogger.ROOT_LOGGER.serviceStartFailed(e, this.targetServiceName.getCanonicalName());
            ServiceContainerHelper.stop((ServiceController)service);
        }
    }

    public T getValue() {
        if (!this.started) {
            throw new IllegalStateException();
        }
        AtomicReference<T> ref = this.getValueRef();
        if (ref == null) {
            ref = this.singletonDispatcher.getValueRef();
        }
        return (T)((Serializable)ref.get());
    }

    @Override
    public AtomicReference<T> getValueRef() {
        return this.master.get() ? new AtomicReference<Object>(this.service.getValue()) : null;
    }

    @Override
    public void stopOldMaster() {
        if (this.master.compareAndSet(true, false)) {
            ServiceContainerHelper.stop((ServiceController)this.container.getRequiredService(this.targetServiceName));
        }
    }

    class SingletonDispatcher
    implements SingletonContext<T> {
        SingletonDispatcher() {
        }

        @Override
        public void stopOldMaster() {
            try {
                SingletonService.this.dispatcher.executeOnCluster(new StopSingletonCommand(), new Node[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public AtomicReference<T> getValueRef() {
            try {
                Map results = Collections.emptyMap();
                while (results.isEmpty()) {
                    if (!SingletonService.this.started) {
                        throw new IllegalStateException(SingletonMessages.MESSAGES.notStarted(SingletonService.this.singletonServiceName.getCanonicalName()));
                    }
                    results = SingletonService.this.dispatcher.executeOnCluster(new SingletonValueCommand(), new Node[0]);
                    Iterator responses = results.values().iterator();
                    while (responses.hasNext()) {
                        if (((CommandResponse)responses.next()).get() != null) continue;
                        responses.remove();
                    }
                    int count = results.size();
                    if (count > 1) {
                        throw SingletonMessages.MESSAGES.unexpectedResponseCount(SingletonService.this.singletonServiceName.getCanonicalName(), count);
                    }
                    if (count != 0) continue;
                    SingletonLogger.ROOT_LOGGER.noResponseFromMaster(SingletonService.this.singletonServiceName.getCanonicalName());
                    if (SingletonService.this.registration.getProviders().size() < SingletonService.this.quorum) {
                        return new AtomicReference();
                    }
                    Thread.yield();
                }
                return (AtomicReference)((CommandResponse)results.values().iterator().next()).get();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

