/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.pojo.descriptor;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.List;
import org.jboss.as.pojo.PojoMessages;
import org.jboss.as.pojo.descriptor.AbstractConfigVisitorNode;
import org.jboss.as.pojo.descriptor.ConfigVisitor;
import org.jboss.as.pojo.descriptor.ConfigVisitorNode;
import org.jboss.as.pojo.descriptor.ValueConfig;
import org.jboss.as.pojo.service.BeanInfo;

public class PropertyConfig
extends AbstractConfigVisitorNode
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String propertyName;
    private String type;
    private ValueConfig value;
    private transient BeanInfo beanInfo;

    @Override
    public void visit(ConfigVisitor visitor) {
        if (this.value == null) {
            throw PojoMessages.MESSAGES.nullValue();
        }
        this.beanInfo = visitor.getBeanInfo();
        super.visit(visitor);
    }

    @Override
    protected void addChildren(ConfigVisitor visitor, List<ConfigVisitorNode> nodes) {
        nodes.add(this.value);
    }

    @Override
    public Class<?> getType(ConfigVisitor visitor, ConfigVisitorNode previous) {
        Class<?> clazz = PropertyConfig.getType(visitor, this.type);
        if (clazz == null) {
            Method m = this.beanInfo.getGetter(this.propertyName, null);
            return m.getReturnType();
        }
        return clazz;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ValueConfig getValue() {
        return this.value;
    }

    public void setValue(ValueConfig value) {
        this.value = value;
    }
}

