/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.util.BasicAuthHelper;
import org.keycloak.util.JsonSerialization;
import org.keycloak.util.KeycloakUriBuilder;
import org.keycloak.util.StreamUtil;

public class ServerRequest {
    public static void invokeLogout(KeycloakDeployment deployment, String refreshToken) throws IOException, HttpFailure {
        String client_id = deployment.getResourceName();
        Map<String, String> credentials = deployment.getResourceCredentials();
        HttpClient client = deployment.getClient();
        URI uri = deployment.getLogoutUrl().clone().build(new Object[0]);
        ArrayList<BasicNameValuePair> formparams = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, String> entry : credentials.entrySet()) {
            formparams.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
        }
        formparams.add(new BasicNameValuePair("refresh_token", refreshToken));
        HttpResponse response = null;
        HttpPost post = new HttpPost(uri);
        if (!deployment.isPublicClient()) {
            String clientSecret = credentials.get("secret");
            if (clientSecret != null) {
                String authorization = BasicAuthHelper.createHeader((String)client_id, (String)clientSecret);
                post.setHeader("Authorization", authorization);
            }
        } else {
            formparams.add(new BasicNameValuePair("client_id", client_id));
        }
        UrlEncodedFormEntity form = new UrlEncodedFormEntity(formparams, "UTF-8");
        post.setEntity((HttpEntity)form);
        response = client.execute((HttpUriRequest)post);
        int status = response.getStatusLine().getStatusCode();
        HttpEntity entity = response.getEntity();
        if (status != 204) {
            ServerRequest.error(status, entity);
        }
        if (entity == null) {
            return;
        }
        InputStream is = entity.getContent();
        if (is != null) {
            is.close();
        }
    }

    public static AccessTokenResponse invokeAccessCodeToToken(KeycloakDeployment deployment, String code, String redirectUri) throws HttpFailure, IOException {
        String codeUrl = deployment.getCodeUrl();
        String client_id = deployment.getResourceName();
        Map<String, String> credentials = deployment.getResourceCredentials();
        HttpClient client = deployment.getClient();
        return ServerRequest.invokeAccessCodeToToken(client, deployment.isPublicClient(), code, codeUrl, redirectUri, client_id, credentials);
    }

    public static AccessTokenResponse invokeAccessCodeToToken(HttpClient client, boolean publicClient, String code, String codeUrl, String redirectUri, String client_id, Map<String, String> credentials) throws IOException, HttpFailure {
        ArrayList<BasicNameValuePair> formparams = new ArrayList<BasicNameValuePair>();
        redirectUri = ServerRequest.stripOauthParametersFromRedirect(redirectUri);
        formparams.add(new BasicNameValuePair("grant_type", "authorization_code"));
        formparams.add(new BasicNameValuePair("code", code));
        formparams.add(new BasicNameValuePair("redirect_uri", redirectUri));
        HttpResponse response = null;
        HttpPost post = new HttpPost(codeUrl);
        if (!publicClient) {
            String clientSecret = credentials.get("secret");
            if (clientSecret != null) {
                String authorization = BasicAuthHelper.createHeader((String)client_id, (String)clientSecret);
                post.setHeader("Authorization", authorization);
            }
        } else {
            formparams.add(new BasicNameValuePair("client_id", client_id));
        }
        UrlEncodedFormEntity form = new UrlEncodedFormEntity(formparams, "UTF-8");
        post.setEntity((HttpEntity)form);
        response = client.execute((HttpUriRequest)post);
        int status = response.getStatusLine().getStatusCode();
        HttpEntity entity = response.getEntity();
        if (status != 200) {
            ServerRequest.error(status, entity);
        }
        if (entity == null) {
            throw new HttpFailure(status, null);
        }
        InputStream is = entity.getContent();
        try {
            int c;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            while ((c = is.read()) != -1) {
                os.write(c);
            }
            byte[] bytes = os.toByteArray();
            String json = new String(bytes);
            try {
                AccessTokenResponse accessTokenResponse = (AccessTokenResponse)JsonSerialization.readValue((String)json, AccessTokenResponse.class);
                return accessTokenResponse;
            }
            catch (IOException e) {
                throw new IOException(json, e);
            }
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ignored) {}
        }
    }

    public static AccessTokenResponse invokeRefresh(KeycloakDeployment deployment, String refreshToken) throws IOException, HttpFailure {
        String refreshUrl = deployment.getRefreshUrl();
        String client_id = deployment.getResourceName();
        Map<String, String> credentials = deployment.getResourceCredentials();
        HttpClient client = deployment.getClient();
        return ServerRequest.invokeRefresh(client, deployment.isPublicClient(), refreshToken, refreshUrl, client_id, credentials);
    }

    public static AccessTokenResponse invokeRefresh(HttpClient client, boolean publicClient, String refreshToken, String refreshUrl, String client_id, Map<String, String> credentials) throws IOException, HttpFailure {
        ArrayList<BasicNameValuePair> formparams = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, String> entry : credentials.entrySet()) {
            formparams.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
        }
        formparams.add(new BasicNameValuePair("grant_type", "refresh_token"));
        formparams.add(new BasicNameValuePair("refresh_token", refreshToken));
        HttpResponse response = null;
        HttpPost post = new HttpPost(refreshUrl);
        if (!publicClient) {
            String clientSecret = credentials.get("secret");
            if (clientSecret != null) {
                String authorization = BasicAuthHelper.createHeader((String)client_id, (String)clientSecret);
                post.setHeader("Authorization", authorization);
            }
        } else {
            formparams.add(new BasicNameValuePair("client_id", client_id));
        }
        UrlEncodedFormEntity form = new UrlEncodedFormEntity(formparams, "UTF-8");
        post.setEntity((HttpEntity)form);
        response = client.execute((HttpUriRequest)post);
        int status = response.getStatusLine().getStatusCode();
        HttpEntity entity = response.getEntity();
        if (status != 200) {
            ServerRequest.error(status, entity);
        }
        if (entity == null) {
            throw new HttpFailure(status, null);
        }
        InputStream is = entity.getContent();
        try {
            int c;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            while ((c = is.read()) != -1) {
                os.write(c);
            }
            byte[] bytes = os.toByteArray();
            String json = new String(bytes);
            try {
                AccessTokenResponse accessTokenResponse = (AccessTokenResponse)JsonSerialization.readValue((String)json, AccessTokenResponse.class);
                return accessTokenResponse;
            }
            catch (IOException e) {
                throw new IOException(json, e);
            }
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ignored) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void error(int status, HttpEntity entity) throws HttpFailure, IOException {
        String body = null;
        if (entity != null) {
            InputStream is = entity.getContent();
            try {
                body = StreamUtil.readString((InputStream)is);
            }
            catch (IOException e) {
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException ignored) {}
            }
        }
        throw new HttpFailure(status, body);
    }

    protected static String stripOauthParametersFromRedirect(String uri) {
        KeycloakUriBuilder builder = KeycloakUriBuilder.fromUri((String)uri).replaceQueryParam("code", null).replaceQueryParam("state", null);
        return builder.build(new Object[0]).toString();
    }

    public static class HttpFailure
    extends Exception {
        private int status;
        private String error;

        public HttpFailure(int status, String error) {
            this.status = status;
            this.error = error;
        }

        public int getStatus() {
            return this.status;
        }

        public String getError() {
            return this.error;
        }
    }
}

