/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec.transport;

import java.util.AbstractList;
import java.util.List;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.amqp.transport.Disposition;
import org.apache.qpid.proton.amqp.transport.Role;
import org.apache.qpid.proton.codec.AbstractDescribedType;
import org.apache.qpid.proton.codec.DecodeException;
import org.apache.qpid.proton.codec.Decoder;
import org.apache.qpid.proton.codec.DescribedTypeConstructor;
import org.apache.qpid.proton.codec.EncoderImpl;

public final class DispositionType
extends AbstractDescribedType<Disposition, List>
implements DescribedTypeConstructor<Disposition> {
    private static final Object[] DESCRIPTORS = new Object[]{UnsignedLong.valueOf((long)21L), Symbol.valueOf((String)"amqp:disposition:list")};
    private static final UnsignedLong DESCRIPTOR = UnsignedLong.valueOf((long)21L);

    private DispositionType(EncoderImpl encoder) {
        super(encoder);
    }

    @Override
    public UnsignedLong getDescriptor() {
        return DESCRIPTOR;
    }

    @Override
    protected List wrap(Disposition val) {
        return new DispositionWrapper(val);
    }

    @Override
    public Disposition newInstance(Object described) {
        List l = (List)described;
        Disposition o = new Disposition();
        if (l.isEmpty()) {
            throw new DecodeException("The first field cannot be omitted");
        }
        switch (6 - l.size()) {
            case 0: {
                Boolean batchable = (Boolean)l.get(5);
                o.setBatchable(batchable == null ? false : batchable);
            }
            case 1: {
                o.setState((DeliveryState)l.get(4));
            }
            case 2: {
                Boolean settled = (Boolean)l.get(3);
                o.setSettled(settled == null ? false : settled);
            }
            case 3: {
                o.setLast((UnsignedInteger)l.get(2));
            }
            case 4: {
                o.setFirst((UnsignedInteger)l.get(1));
            }
            case 5: {
                o.setRole(Boolean.TRUE.equals(l.get(0)) ? Role.RECEIVER : Role.SENDER);
            }
        }
        return o;
    }

    @Override
    public Class<Disposition> getTypeClass() {
        return Disposition.class;
    }

    public static void register(Decoder decoder, EncoderImpl encoder) {
        DispositionType type = new DispositionType(encoder);
        for (Object descriptor : DESCRIPTORS) {
            decoder.register(descriptor, type);
        }
        encoder.register(type);
    }

    private static final class DispositionWrapper
    extends AbstractList {
        private Disposition _disposition;

        public DispositionWrapper(Disposition disposition) {
            this._disposition = disposition;
        }

        @Override
        public Object get(int index) {
            switch (index) {
                case 0: {
                    return this._disposition.getRole().getValue();
                }
                case 1: {
                    return this._disposition.getFirst();
                }
                case 2: {
                    return this._disposition.getLast();
                }
                case 3: {
                    return this._disposition.getSettled();
                }
                case 4: {
                    return this._disposition.getState();
                }
                case 5: {
                    return this._disposition.getBatchable();
                }
            }
            throw new IllegalStateException("Unknown index " + index);
        }

        @Override
        public int size() {
            return this._disposition.getBatchable() ? 6 : (this._disposition.getState() != null ? 5 : (this._disposition.getSettled() ? 4 : (this._disposition.getLast() != null ? 3 : 2)));
        }
    }
}

