/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching;

import java.io.IOException;
import java.io.SyncFailedException;
import java.util.Collection;
import java.util.Set;
import org.jboss.as.patching.ContentConflictsException;
import org.jboss.as.patching.PatchingException;
import org.jboss.as.patching.metadata.ContentItem;
import org.jboss.as.patching.validation.PatchingArtifact;
import org.jboss.logging.Messages;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageBundle;
import org.jboss.logging.annotations.Param;

@MessageBundle(projectCode="JBAS")
public interface PatchMessages {
    public static final PatchMessages MESSAGES = (PatchMessages)Messages.getBundle(PatchMessages.class);

    @Message(id=0, value="Filesystem path of a pristine unzip of the distribution of the version of the software to which the generated patch applies")
    public String argAppliesToDist();

    @Message(id=0, value="Display this message and exit")
    public String argHelp();

    @Message(id=0, value="Filesystem location to which the generated patch file should be written")
    public String argOutputFile();

    @Message(id=0, value="Filesystem path of the patch generation configuration file to use")
    public String argPatchConfig();

    @Message(id=0, value="Filesystem path of a pristine unzip of a distribution of software which contains the changes that should be incorporated in the patch")
    public String argUpdatedDist();

    @Message(id=0, value="Usage: %s [args...]%nwhere args include:")
    public String patchGeneratorUsageHeadline(String var1);

    @Message(id=0, value="Print version and exit")
    public String argVersion();

    @Message(id=0, value="Conflicts detected")
    public String detectedConflicts();

    @Message(id=0, value="failed to resolve a jboss.home.dir use the --distribution attribute to point to a valid installation")
    public IllegalStateException cliFailedToResolveDistribution();

    @Message(id=0, value="No layers directory found at %s")
    public IllegalStateException installationNoLayersConfigFound(String var1);

    @Message(id=0, value="Cannot find layer '%s' under directory %s")
    public IllegalStateException installationMissingLayer(String var1, String var2);

    @Message(id=0, value="no associated module or bundle repository with layer '%s'")
    public IllegalStateException installationInvalidLayerConfiguration(String var1);

    @Message(id=0, value="Duplicate %s '%s'")
    public IllegalStateException installationDuplicateLayer(String var1, String var2);

    @Message(id=0, value="null input stream")
    public IllegalArgumentException nullInputStream();

    @Message(id=0, value="null output stream")
    public IllegalArgumentException nullOutputStream();

    @Message(id=0, value="Not a directory %s")
    public IllegalStateException notADirectory(String var1);

    @Message(id=0, value="patch types don't match")
    public IllegalStateException patchTypesDontMatch();

    @Message(id=0, value="invalid rollback information")
    public PatchingException invalidRollbackInformation();

    @Message(id=16840, value="Patch does not apply - expected (%s), but was (%s)")
    public PatchingException doesNotApply(String var1, String var2);

    @Message(id=16841, value="Failed to delete (%s)")
    public IOException failedToDelete(String var1);

    @Message(id=16842, value="Failed to create directory (%s)")
    public IOException cannotCreateDirectory(String var1);

    @Message(id=16843, value="Argument expected for option %s")
    public String argumentExpected(String var1);

    @Message(id=16844, value="Missing required argument(s): %s")
    public String missingRequiredArgs(Set<String> var1);

    @Message(id=16845, value="File at path specified by argument %s does not exist")
    public String fileDoesNotExist(String var1);

    @Message(id=16846, value="File at path specified by argument %s is not a directory")
    public String fileIsNotADirectory(String var1);

    @Message(id=16847, value="File at path specified by argument %s is a directory")
    public String fileIsADirectory(String var1);

    @Message(id=16848, value="Cannot rollback patch (%s)")
    public PatchingException cannotRollbackPatch(String var1);

    @Message(id=16849, value="Patch '%s' already applied")
    public PatchingException alreadyApplied(String var1);

    @Message(id=16850, value="There is no layer called %s installed")
    public PatchingException noSuchLayer(String var1);

    @Message(id=16851, value="Failed to resolve a valid patch descriptor for %s %s")
    public PatchingException failedToResolvePatch(String var1, String var2);

    @Message(id=16852, value="Requires patch '%s'")
    public PatchingException requiresPatch(String var1);

    @Message(id=16853, value="Patch is incompatible with patch '%s'")
    public PatchingException incompatiblePatch(String var1);

    @Message(id=16854, value="Conflicts detected")
    public ContentConflictsException conflictsDetected(@Param Collection<ContentItem> var1);

    @Message(id=16855, value="copied content does not match expected hash for item: %s")
    public SyncFailedException wrongCopiedContent(ContentItem var1);

    @Message(id=16856, value="invalid patch name '%s'")
    public IllegalArgumentException illegalPatchName(String var1);

    @Message(id=16857, value="Cannot rollback. No patches applied.")
    public IllegalArgumentException noPatchesApplied();

    @Message(id=16858, value="Patch '%s' not found in history.")
    public PatchingException patchNotFoundInHistory(String var1);

    @Message(id=16860, value="missing: '%s'")
    public String missingArtifact(PatchingArtifact.ArtifactState var1);

    @Message(id=16861, value="inconsistent state: '%s'")
    public String inconsistentArtifact(PatchingArtifact.ArtifactState var1);

    @Message(id=16862, value="in error: '%s'")
    public String artifactInError(PatchingArtifact.ArtifactState var1);
}

