/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.annotations.repository.jandex;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import org.jboss.jandex.Indexer;
import org.jboss.jca.common.annotations.repository.jandex.AnnotationRepositoryImpl;
import org.jboss.jca.common.spi.annotations.repository.AnnotationRepository;
import org.jboss.jca.common.spi.annotations.repository.AnnotationScanner;
import org.jboss.logging.Logger;

public class AnnotationScannerImpl
implements AnnotationScanner {
    private static Logger log = Logger.getLogger(AnnotationScannerImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnnotationRepository scan(URL[] urls, ClassLoader cl) {
        Indexer indexer = new Indexer();
        if (urls != null && urls.length > 0) {
            for (URL url : urls) {
                String externalForm = url.toExternalForm();
                if (externalForm.endsWith(".class")) {
                    InputStream is = null;
                    try {
                        is = new FileInputStream(new File(url.toURI()));
                        indexer.index(is);
                        continue;
                    }
                    catch (Throwable t) {
                        log.error((Object)("Unable to process: " + externalForm), t);
                        continue;
                    }
                    finally {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException ioe) {}
                        }
                    }
                }
                if (!externalForm.endsWith(".jar")) continue;
                ZipFile jarFile = null;
                try {
                    jarFile = new JarFile(new File(url.toURI()));
                    Enumeration<JarEntry> entries = ((JarFile)jarFile).entries();
                    while (entries.hasMoreElements()) {
                        JarEntry jarEntry = entries.nextElement();
                        if (!jarEntry.getName().endsWith(".class")) continue;
                        InputStream is = null;
                        try {
                            is = ((JarFile)jarFile).getInputStream(jarEntry);
                            indexer.index(is);
                        }
                        catch (Throwable t) {
                            log.error((Object)("Unable to process: " + jarEntry.getName()), t);
                        }
                        finally {
                            if (is == null) continue;
                            try {
                                is.close();
                            }
                            catch (IOException ioe) {}
                        }
                    }
                }
                catch (Throwable t) {
                    log.error((Object)("Unable to process: " + externalForm), t);
                }
                finally {
                    if (jarFile != null) {
                        try {
                            jarFile.close();
                        }
                        catch (IOException ioe) {}
                    }
                }
            }
        }
        return new AnnotationRepositoryImpl(indexer.complete(), cl);
    }
}

