/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core;

import io.undertow.websockets.core.StreamSinkFrameChannel;
import io.undertow.websockets.core.WebSocketCallback;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketFrameType;
import java.io.Closeable;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.xnio.Buffers;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;

public class WebSockets {
    private static final Charset utf8 = Charset.forName("UTF-8");

    public static void sendText(String message, WebSocketChannel wsChannel, WebSocketCallback<Void> callback) {
        ByteBuffer data = ByteBuffer.wrap(message.getBytes(utf8));
        WebSockets.sendInternal(new ByteBuffer[]{data}, WebSocketFrameType.TEXT, wsChannel, callback);
    }

    public static void sendTextBlocking(String message, WebSocketChannel wsChannel) throws IOException {
        ByteBuffer data = ByteBuffer.wrap(message.getBytes(utf8));
        WebSockets.sendBlockingInternal(new ByteBuffer[]{data}, WebSocketFrameType.TEXT, wsChannel);
    }

    public static void sendPing(ByteBuffer data, WebSocketChannel wsChannel, WebSocketCallback<Void> callback) {
        WebSockets.sendInternal(new ByteBuffer[]{data}, WebSocketFrameType.PING, wsChannel, callback);
    }

    public static void sendPing(ByteBuffer[] data, WebSocketChannel wsChannel, WebSocketCallback<Void> callback) {
        WebSockets.sendInternal(data, WebSocketFrameType.PING, wsChannel, callback);
    }

    public static void sendPingBlocking(ByteBuffer data, WebSocketChannel wsChannel) throws IOException {
        WebSockets.sendBlockingInternal(new ByteBuffer[]{data}, WebSocketFrameType.PING, wsChannel);
    }

    public static void sendPingBlocking(ByteBuffer[] data, WebSocketChannel wsChannel) throws IOException {
        WebSockets.sendBlockingInternal(data, WebSocketFrameType.PING, wsChannel);
    }

    public static void sendPong(ByteBuffer data, WebSocketChannel wsChannel, WebSocketCallback<Void> callback) {
        WebSockets.sendInternal(new ByteBuffer[]{data}, WebSocketFrameType.PONG, wsChannel, callback);
    }

    public static void sendPong(ByteBuffer[] data, WebSocketChannel wsChannel, WebSocketCallback<Void> callback) {
        WebSockets.sendInternal(data, WebSocketFrameType.PONG, wsChannel, callback);
    }

    public static void sendPongBlocking(ByteBuffer data, WebSocketChannel wsChannel) throws IOException {
        WebSockets.sendBlockingInternal(new ByteBuffer[]{data}, WebSocketFrameType.PONG, wsChannel);
    }

    public static void sendPongBlocking(ByteBuffer[] data, WebSocketChannel wsChannel) throws IOException {
        WebSockets.sendBlockingInternal(data, WebSocketFrameType.PONG, wsChannel);
    }

    public static void sendBinary(ByteBuffer data, WebSocketChannel wsChannel, WebSocketCallback<Void> callback) {
        WebSockets.sendInternal(new ByteBuffer[]{data}, WebSocketFrameType.BINARY, wsChannel, callback);
    }

    public static void sendBinary(ByteBuffer[] data, WebSocketChannel wsChannel, WebSocketCallback<Void> callback) {
        WebSockets.sendInternal(data, WebSocketFrameType.BINARY, wsChannel, callback);
    }

    public static void sendBinaryBlocking(ByteBuffer data, WebSocketChannel wsChannel) throws IOException {
        WebSockets.sendBlockingInternal(new ByteBuffer[]{data}, WebSocketFrameType.BINARY, wsChannel);
    }

    public static void sendBinaryBlocking(ByteBuffer[] data, WebSocketChannel wsChannel) throws IOException {
        WebSockets.sendBlockingInternal(data, WebSocketFrameType.BINARY, wsChannel);
    }

    public static void sendClose(ByteBuffer data, WebSocketChannel wsChannel, WebSocketCallback<Void> callback) {
        WebSockets.sendInternal(new ByteBuffer[]{data}, WebSocketFrameType.CLOSE, wsChannel, callback);
    }

    public static void sendClose(ByteBuffer[] data, WebSocketChannel wsChannel, WebSocketCallback<Void> callback) {
        WebSockets.sendInternal(data, WebSocketFrameType.CLOSE, wsChannel, callback);
    }

    public static void sendCloseBlocking(ByteBuffer data, WebSocketChannel wsChannel) throws IOException {
        WebSockets.sendBlockingInternal(new ByteBuffer[]{data}, WebSocketFrameType.CLOSE, wsChannel);
    }

    public static void sendCloseBlocking(ByteBuffer[] data, WebSocketChannel wsChannel) throws IOException {
        WebSockets.sendBlockingInternal(data, WebSocketFrameType.CLOSE, wsChannel);
    }

    private static void sendInternal(ByteBuffer[] data, WebSocketFrameType type, WebSocketChannel wsChannel, WebSocketCallback<Void> callback) {
        try {
            long totalData = Buffers.remaining((Buffer[])data);
            StreamSinkFrameChannel channel = wsChannel.send(type, totalData);
            WebSockets.sendData(data, wsChannel, callback, channel, null);
        }
        catch (IOException e) {
            if (callback != null) {
                callback.onError(wsChannel, null, e);
            }
            IoUtils.safeClose((Closeable)((Object)wsChannel));
        }
    }

    private static <T> void sendData(final ByteBuffer[] data, final WebSocketChannel wsChannel, final WebSocketCallback<T> callback, StreamSinkFrameChannel channel, final T context) throws IOException {
        boolean hasRemaining = true;
        while (hasRemaining) {
            long res = channel.write(data);
            hasRemaining = Buffers.hasRemaining((Buffer[])data);
            if (res != 0L || !hasRemaining) continue;
            channel.getWriteSetter().set((ChannelListener)new ChannelListener<StreamSinkFrameChannel>(){

                public void handleEvent(StreamSinkFrameChannel channel) {
                    do {
                        try {
                            long res = channel.write(data);
                            if (res == 0L) {
                                return;
                            }
                        }
                        catch (IOException e) {
                            WebSockets.handleIoException(channel, e, callback, context, wsChannel);
                            return;
                        }
                    } while (Buffers.hasRemaining((Buffer[])data));
                    channel.suspendWrites();
                    try {
                        WebSockets.flushChannelAsync(wsChannel, callback, channel, context);
                    }
                    catch (IOException e) {
                        WebSockets.handleIoException(channel, e, callback, context, wsChannel);
                    }
                }
            });
            channel.resumeWrites();
            return;
        }
        WebSockets.flushChannelAsync(wsChannel, callback, channel, context);
    }

    private static <T> void handleIoException(StreamSinkFrameChannel channel, IOException e, WebSocketCallback<T> callback, T context, WebSocketChannel wsChannel) {
        if (callback != null) {
            callback.onError(channel.getWebSocketChannel(), context, e);
        }
        IoUtils.safeClose((Closeable)((Object)wsChannel));
        channel.suspendWrites();
    }

    private static <T> void flushChannelAsync(final WebSocketChannel wsChannel, final WebSocketCallback<T> callback, StreamSinkFrameChannel channel, final T context) throws IOException {
        final WebSocketFrameType type = channel.getType();
        channel.shutdownWrites();
        if (!channel.flush()) {
            channel.getWriteSetter().set(ChannelListeners.flushingChannelListener((ChannelListener)new ChannelListener<StreamSinkFrameChannel>(){

                public void handleEvent(StreamSinkFrameChannel channel) {
                    if (callback != null) {
                        callback.complete(wsChannel, context);
                    }
                    if (type == WebSocketFrameType.CLOSE && wsChannel.isCloseFrameReceived()) {
                        IoUtils.safeClose((Closeable)((Object)wsChannel));
                    }
                }
            }, (ChannelExceptionHandler)new ChannelExceptionHandler<StreamSinkFrameChannel>(){

                public void handleException(StreamSinkFrameChannel channel, IOException exception) {
                    if (callback != null) {
                        callback.onError(wsChannel, context, exception);
                    }
                    if (type == WebSocketFrameType.CLOSE && wsChannel.isCloseFrameReceived()) {
                        IoUtils.safeClose((Closeable)((Object)wsChannel));
                    }
                }
            }));
            channel.resumeWrites();
            return;
        }
        if (callback != null) {
            callback.complete(wsChannel, context);
        }
        if (type == WebSocketFrameType.CLOSE && wsChannel.isCloseFrameReceived()) {
            IoUtils.safeClose((Closeable)((Object)wsChannel));
        }
    }

    private static void sendBlockingInternal(ByteBuffer[] data, WebSocketFrameType type, WebSocketChannel wsChannel) throws IOException {
        long totalData = Buffers.remaining((Buffer[])data);
        StreamSinkFrameChannel channel = wsChannel.send(type, totalData);
        for (ByteBuffer buf : data) {
            while (buf.hasRemaining()) {
                int res = channel.write(buf);
                if (res != 0) continue;
                channel.awaitWritable();
            }
        }
        channel.shutdownWrites();
        while (!channel.flush()) {
            channel.awaitWritable();
        }
        if (type == WebSocketFrameType.CLOSE && wsChannel.isCloseFrameReceived()) {
            IoUtils.safeClose((Closeable)((Object)wsChannel));
        }
    }

    private WebSockets() {
    }

    public static ByteBuffer mergeBuffers(ByteBuffer ... payload) {
        int size = (int)Buffers.remaining((Buffer[])payload);
        if (size == 0) {
            return Buffers.EMPTY_BYTE_BUFFER;
        }
        ByteBuffer buffer = ByteBuffer.allocate(size);
        for (ByteBuffer buf : payload) {
            buffer.put(buf);
        }
        buffer.flip();
        return buffer;
    }
}

