/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.sts.registry;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.picketlink.identity.federation.core.sts.registry.AbstractJDBCRegistry;
import org.picketlink.identity.federation.core.sts.registry.RevocationRegistry;

public class OJDBCRevocationRegistry
extends AbstractJDBCRegistry
implements RevocationRegistry {
    private static final String EXISTS_TABLE_SQL = "SELECT COUNT(*) FROM STS_REVOCATION_REGISTRY WHERE TOKEN_ID = ? AND TOKEN_TYPE = ?";
    private static final String INSERT_TABLE_SQL = "INSERT INTO STS_REVOCATION_REGISTRY (TOKEN_ID, TOKEN_TYPE, CREATED_DATE) VALUES (?,?,?)";

    public OJDBCRevocationRegistry() {
        super("java:jboss", "jdbc/picketlink-sts");
    }

    public OJDBCRevocationRegistry(String initial, String jndiName) {
        super(initial, jndiName);
    }

    public OJDBCRevocationRegistry(String jndiName) {
        super("java:jboss", jndiName);
    }

    @Override
    public boolean isRevoked(String tokenType, String tokenID) {
        boolean bl;
        if (this.dataSource == null) {
            throw logger.datasourceIsNull();
        }
        Connection conn = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            conn = this.dataSource.getConnection();
            preparedStatement = conn.prepareStatement(EXISTS_TABLE_SQL);
            preparedStatement.setString(1, tokenID);
            preparedStatement.setString(2, tokenType);
            resultSet = preparedStatement.executeQuery();
            bl = resultSet.getInt(1) > 0;
        }
        catch (SQLException e) {
            try {
                throw logger.runtimeException("revokeToken", (Throwable)e);
            }
            catch (Throwable throwable) {
                this.safeClose(resultSet);
                this.safeClose(preparedStatement);
                this.safeClose(conn);
                throw throwable;
            }
        }
        this.safeClose(resultSet);
        this.safeClose(preparedStatement);
        this.safeClose(conn);
        return bl;
    }

    @Override
    public void revokeToken(String tokenType, String tokenID) {
        if (this.dataSource == null) {
            throw logger.datasourceIsNull();
        }
        Connection conn = null;
        PreparedStatement preparedStatement = null;
        try {
            conn = this.dataSource.getConnection();
            Date tokenCreationDate = Calendar.getInstance().getTime();
            preparedStatement = conn.prepareStatement(INSERT_TABLE_SQL);
            preparedStatement.setString(1, tokenID);
            preparedStatement.setString(2, tokenType);
            preparedStatement.setTimestamp(3, new Timestamp(tokenCreationDate.getTime()), Calendar.getInstance(TimeZone.getTimeZone("UTC")));
            preparedStatement.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw logger.runtimeException("revokeToken", (Throwable)e);
            }
            catch (Throwable throwable) {
                this.safeClose(preparedStatement);
                this.safeClose(conn);
                throw throwable;
            }
        }
        this.safeClose(preparedStatement);
        this.safeClose(conn);
    }
}

