/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ModelVersionRange;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.CombinedTransformer;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.PathAddressTransformer;
import org.jboss.as.controller.transform.ResourceTransformationContext;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescription;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.jboss.as.security.ACLResourceDefinition;
import org.jboss.as.security.AuditResourceDefinition;
import org.jboss.as.security.AuthorizationResourceDefinition;
import org.jboss.as.security.ClassicAuthenticationResourceDefinition;
import org.jboss.as.security.IdentityTrustResourceDefinition;
import org.jboss.as.security.JASPIAuthenticationResourceDefinition;
import org.jboss.as.security.JSSEResourceDefinition;
import org.jboss.as.security.MappingResourceDefinition;
import org.jboss.as.security.Namespace;
import org.jboss.as.security.SecurityDomainResourceDefinition;
import org.jboss.as.security.SecuritySubsystemParser;
import org.jboss.as.security.SecuritySubsystemRootResourceDefinition;
import org.jboss.as.security.VaultResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class SecurityExtension
implements Extension {
    public static final ServiceName JBOSS_SECURITY = ServiceName.JBOSS.append(new String[]{"security"});
    public static final String SUBSYSTEM_NAME = "security";
    static final PathElement PATH_SUBSYSTEM = PathElement.pathElement((String)"subsystem", (String)"security");
    private static final String RESOURCE_NAME = SecurityExtension.class.getPackage().getName() + ".LocalDescriptions";
    private static final int MANAGEMENT_API_MAJOR_VERSION = 1;
    private static final int MANAGEMENT_API_MINOR_VERSION = 3;
    private static final int MANAGEMENT_API_MICRO_VERSION = 0;
    private static final SecuritySubsystemParser PARSER = SecuritySubsystemParser.getInstance();
    static final PathElement ACL_PATH = PathElement.pathElement((String)"acl", (String)"classic");
    static final PathElement PATH_IDENTITY_TRUST_CLASSIC = PathElement.pathElement((String)"identity-trust", (String)"classic");
    static final PathElement PATH_JASPI_AUTH = PathElement.pathElement((String)"authentication", (String)"jaspi");
    static final PathElement PATH_CLASSIC_AUTHENTICATION = PathElement.pathElement((String)"authentication", (String)"classic");
    static final PathElement SECURITY_DOMAIN_PATH = PathElement.pathElement((String)"security-domain");
    static final PathElement PATH_AUTHORIZATION_CLASSIC = PathElement.pathElement((String)"authorization", (String)"classic");
    static final PathElement PATH_MAPPING_CLASSIC = PathElement.pathElement((String)"mapping", (String)"classic");
    static final PathElement PATH_AUDIT_CLASSIC = PathElement.pathElement((String)"audit", (String)"classic");
    static final PathElement PATH_LOGIN_MODULE_STACK = PathElement.pathElement((String)"login-module-stack");
    static final PathElement VAULT_PATH = PathElement.pathElement((String)"vault", (String)"classic");
    static final PathElement JSSE_PATH = PathElement.pathElement((String)"jsse", (String)"classic");
    private static final PathAddressTransformer CURRENT_PATH_TRANSFORMER = new PathAddressTransformer(){

        public PathAddress transform(PathElement current, PathAddressTransformer.Builder builder) {
            return builder.getCurrent();
        }
    };

    static StandardResourceDescriptionResolver getResourceDescriptionResolver(String keyPrefix) {
        return new StandardResourceDescriptionResolver(keyPrefix, RESOURCE_NAME, SecurityExtension.class.getClassLoader(), true, true);
    }

    static StandardResourceDescriptionResolver getResourceDescriptionResolver(String ... keyPrefix) {
        StringBuilder prefix = new StringBuilder();
        for (String kp : keyPrefix) {
            if (prefix.length() > 0) {
                prefix.append('.');
            }
            prefix.append(kp);
        }
        return new StandardResourceDescriptionResolver(prefix.toString(), RESOURCE_NAME, SecurityExtension.class.getClassLoader(), true, false);
    }

    public void initialize(ExtensionContext context) {
        boolean registerRuntimeOnly = context.isRuntimeOnlyRegistrationValid();
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, 1, 3, 0);
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel((ResourceDefinition)SecuritySubsystemRootResourceDefinition.INSTANCE);
        registration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
        ManagementResourceRegistration securityDomain = registration.registerSubModel((ResourceDefinition)new SecurityDomainResourceDefinition(registerRuntimeOnly));
        securityDomain.registerSubModel((ResourceDefinition)JASPIAuthenticationResourceDefinition.INSTANCE);
        securityDomain.registerSubModel((ResourceDefinition)ClassicAuthenticationResourceDefinition.INSTANCE);
        securityDomain.registerSubModel((ResourceDefinition)AuthorizationResourceDefinition.INSTANCE);
        securityDomain.registerSubModel((ResourceDefinition)MappingResourceDefinition.INSTANCE);
        securityDomain.registerSubModel((ResourceDefinition)ACLResourceDefinition.INSTANCE);
        securityDomain.registerSubModel((ResourceDefinition)AuditResourceDefinition.INSTANCE);
        securityDomain.registerSubModel((ResourceDefinition)IdentityTrustResourceDefinition.INSTANCE);
        securityDomain.registerSubModel((ResourceDefinition)JSSEResourceDefinition.INSTANCE);
        registration.registerSubModel((ResourceDefinition)VaultResourceDefinition.INSTANCE);
        subsystem.registerXMLElementWriter((XMLElementWriter)PARSER);
        if (context.isRegisterTransformers()) {
            this.registerTransformers(subsystem);
        }
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.SECURITY_1_0.getUriString(), (XMLElementReader)PARSER);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.SECURITY_1_1.getUriString(), (XMLElementReader)PARSER);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.SECURITY_1_2.getUriString(), (XMLElementReader)PARSER);
    }

    private void registerTransformers(SubsystemRegistration subsystemRegistration) {
        this.registerTransformers_1_1_0(subsystemRegistration);
        this.registerTransformers_1_2_0(subsystemRegistration);
    }

    private void registerTransformers_1_1_0(SubsystemRegistration subsystemRegistration) {
        ResourceTransformationDescriptionBuilder builder = TransformationDescriptionBuilder.Factory.createSubsystemInstance();
        builder.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new AttributeDefinition[]{SecuritySubsystemRootResourceDefinition.DEEP_COPY_SUBJECT_MODE});
        ResourceTransformationDescriptionBuilder securityDomain = builder.addChildResource(SECURITY_DOMAIN_PATH);
        ((AttributeTransformationDescriptionBuilder)securityDomain.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new AttributeDefinition[]{SecurityDomainResourceDefinition.CACHE_TYPE})).end();
        ModulesToAttributeTransformer authClassicLoginModule = new ModulesToAttributeTransformer("login-module", "login-modules");
        this.registerModuleTransformer(securityDomain, PATH_CLASSIC_AUTHENTICATION, authClassicLoginModule, ChildResourceTransformersRegistrar.createBuilder().addRejectExpressions("flag", "module-options").build());
        ModulesToAttributeTransformer policyModule = new ModulesToAttributeTransformer("policy-module", "policy-modules");
        this.registerModuleTransformer(securityDomain, PATH_AUTHORIZATION_CLASSIC, policyModule, ChildResourceTransformersRegistrar.createBuilder().addRejectExpressions("flag", "module-options").build());
        ModulesToAttributeTransformer mappingModule = new ModulesToAttributeTransformer("mapping-module", "mapping-modules");
        this.registerModuleTransformer(securityDomain, PATH_MAPPING_CLASSIC, mappingModule, ChildResourceTransformersRegistrar.createBuilder().addRejectExpressions("type", "module-options").build());
        ModulesToAttributeTransformer providerModule = new ModulesToAttributeTransformer("provider-module", "provider-modules");
        this.registerModuleTransformer(securityDomain, PATH_AUDIT_CLASSIC, providerModule, ChildResourceTransformersRegistrar.createBuilder().addRejectExpressions("module-options").build());
        ModulesToAttributeTransformer identityTrustModule = new ModulesToAttributeTransformer("trust-module", "trust-modules");
        this.registerModuleTransformer(securityDomain, PATH_IDENTITY_TRUST_CLASSIC, identityTrustModule, ChildResourceTransformersRegistrar.createBuilder().addRejectExpressions("flag", "module-options").build());
        ModulesToAttributeTransformer aclModule = new ModulesToAttributeTransformer("acl-module", "acl-modules");
        this.registerModuleTransformer(securityDomain, ACL_PATH, aclModule, ChildResourceTransformersRegistrar.createBuilder().addRejectExpressions("flag", "module-options").build());
        JaspiModulesToAttributeTransformer authModule = new JaspiModulesToAttributeTransformer("auth-module", "auth-modules");
        ResourceTransformationDescriptionBuilder jaspiReg = this.registerModuleTransformer(securityDomain, PATH_JASPI_AUTH, authModule, ChildResourceTransformersRegistrar.createBuilder().addRejectExpressions("flag", "module-options").addRejectIfDefined("module").build());
        JaspiModulesToAttributeTransformer authLoginModule = new JaspiModulesToAttributeTransformer("login-module", "login-modules");
        this.registerModuleTransformer(jaspiReg, PATH_LOGIN_MODULE_STACK, authLoginModule, null);
        ((AttributeTransformationDescriptionBuilder)builder.addChildResource(VAULT_PATH).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new AttributeDefinition[]{VaultResourceDefinition.OPTIONS})).end();
        ((AttributeTransformationDescriptionBuilder)securityDomain.addChildResource(JSSE_PATH).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new AttributeDefinition[]{JSSEResourceDefinition.ADDITIONAL_PROPERTIES})).end();
        TransformationDescription.Tools.register((TransformationDescription)builder.build(), (SubsystemRegistration)subsystemRegistration, (ModelVersionRange)ModelVersion.create((int)1, (int)1, (int)0));
    }

    private void registerTransformers_1_2_0(SubsystemRegistration subsystemRegistration) {
        ResourceTransformationDescriptionBuilder builder = TransformationDescriptionBuilder.Factory.createSubsystemInstance();
        ResourceTransformationDescriptionBuilder securityDomain = builder.addChildResource(SECURITY_DOMAIN_PATH);
        AttributeToModulesTransformer loginModule = new AttributeToModulesTransformer("login-modules");
        this.registerModuleTransformer(securityDomain, PATH_CLASSIC_AUTHENTICATION, loginModule);
        AttributeToModulesTransformer policyModule = new AttributeToModulesTransformer("policy-modules");
        this.registerModuleTransformer(securityDomain, PATH_AUTHORIZATION_CLASSIC, policyModule);
        AttributeToModulesTransformer mappingModule = new AttributeToModulesTransformer("mapping-modules");
        this.registerModuleTransformer(securityDomain, PATH_MAPPING_CLASSIC, mappingModule);
        AttributeToModulesTransformer providerModule = new AttributeToModulesTransformer("provider-modules");
        this.registerModuleTransformer(securityDomain, PATH_AUDIT_CLASSIC, providerModule);
        AttributeToModulesTransformer identityTrustModule = new AttributeToModulesTransformer("trust-modules");
        this.registerModuleTransformer(securityDomain, PATH_IDENTITY_TRUST_CLASSIC, identityTrustModule);
        AttributeToModulesTransformer aclModule = new AttributeToModulesTransformer("acl-modules");
        ResourceTransformationDescriptionBuilder aclBuilder = this.registerModuleTransformer(securityDomain, ACL_PATH, aclModule);
        aclBuilder.addChildRedirection(PathElement.pathElement((String)"acl-module"), PathElement.pathElement((String)"login-module"));
        AttributeToModulesTransformer authModule = new AttributeToModulesTransformer("auth-modules");
        ResourceTransformationDescriptionBuilder jaspiReg = this.registerModuleTransformer(securityDomain, PATH_JASPI_AUTH, authModule);
        ((AttributeTransformationDescriptionBuilder)jaspiReg.addChildResource(PathElement.pathElement((String)"auth-module")).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.DEFINED, new String[]{"module"})).end();
        this.registerModuleTransformer(jaspiReg, PATH_LOGIN_MODULE_STACK, loginModule);
        TransformationDescription.Tools.register((TransformationDescription)builder.build(), (SubsystemRegistration)subsystemRegistration, (ModelVersionRange)ModelVersion.create((int)1, (int)2, (int)0));
    }

    private ResourceTransformationDescriptionBuilder registerModuleTransformer(ResourceTransformationDescriptionBuilder parent, PathElement childPath, final ModulesToAttributeTransformer transformer, ChildResourceTransformersRegistrar childRegistrar) {
        OperationTransformer addOrWriteTransformer = new OperationTransformer(){

            public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation) throws OperationFailedException {
                return transformer.transformParentOperation(context, address, operation);
            }
        };
        ResourceTransformationDescriptionBuilder child = parent.addChildResource(childPath).setCustomResourceTransformer((ResourceTransformer)transformer).addOperationTransformationOverride("add").setCustomOperationTransformer(addOrWriteTransformer).inheritResourceAttributeDefinitions().end().addOperationTransformationOverride("write-attribute").setCustomOperationTransformer(addOrWriteTransformer).inheritResourceAttributeDefinitions().end().addOperationTransformationOverride("undefine-attribute").setCustomOperationTransformer(addOrWriteTransformer).inheritResourceAttributeDefinitions().end().addOperationTransformationOverride("remove").setCustomOperationTransformer(new OperationTransformer(){

            public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation) throws OperationFailedException {
                return new OperationTransformer.TransformedOperation(operation, OperationTransformer.TransformedOperation.ORIGINAL_RESULT);
            }
        }).end();
        ResourceTransformationDescriptionBuilder childRedirectionBuilder = child.addChildRedirection(PathElement.pathElement((String)transformer.getResourceName()), CURRENT_PATH_TRANSFORMER).setCustomResourceTransformer(ResourceTransformer.DISCARD).addOperationTransformationOverride("add").setCustomOperationTransformer((OperationTransformer)transformer).inheritResourceAttributeDefinitions().end().addOperationTransformationOverride("write-attribute").setCustomOperationTransformer((OperationTransformer)transformer).inheritResourceAttributeDefinitions().end().addOperationTransformationOverride("remove").setCustomOperationTransformer((OperationTransformer)transformer).inheritResourceAttributeDefinitions().end();
        if (childRegistrar != null) {
            childRegistrar.registerTransformers(childRedirectionBuilder);
        }
        return child;
    }

    private ResourceTransformationDescriptionBuilder registerModuleTransformer(ResourceTransformationDescriptionBuilder parent, PathElement childPath, AttributeToModulesTransformer transformer) {
        return parent.addChildResource(childPath).addOperationTransformationOverride("add").inheritResourceAttributeDefinitions().setCustomOperationTransformer((OperationTransformer)transformer).end();
    }

    private static class ChildResourceTransformersRegistrar {
        private String[] reject;
        private String[] defined;

        public ChildResourceTransformersRegistrar(String[] reject, String[] defined) {
            this.reject = reject;
            this.defined = defined;
        }

        void registerTransformers(ResourceTransformationDescriptionBuilder builder) {
            if (this.reject != null) {
                builder.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, this.reject);
            }
            if (this.defined != null) {
                builder.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.DEFINED, this.defined);
            }
        }

        static Builder createBuilder() {
            return new Builder();
        }

        static class Builder {
            private List<String> reject;
            private List<String> defined;

            Builder() {
            }

            Builder addRejectExpressions(String ... attributes) {
                this.reject = this.addToList(this.reject, attributes);
                return this;
            }

            Builder addRejectIfDefined(String ... attributes) {
                this.defined = this.addToList(this.defined, attributes);
                return this;
            }

            ChildResourceTransformersRegistrar build() {
                return new ChildResourceTransformersRegistrar(this.reject == null ? null : this.reject.toArray(new String[this.reject.size()]), this.defined == null ? null : this.defined.toArray(new String[this.defined.size()]));
            }

            private List<String> addToList(List<String> attrs, String ... attributes) {
                if (attrs == null) {
                    attrs = new ArrayList<String>();
                }
                for (String attr : attributes) {
                    attrs.add(attr);
                }
                return attrs;
            }
        }
    }

    private static class AttributeToModulesTransformer
    implements OperationTransformer {
        private final String attributeName;

        private AttributeToModulesTransformer(String attributeName) {
            this.attributeName = attributeName;
        }

        public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation) throws OperationFailedException {
            ModelNode transformedOp;
            if (!operation.has(this.attributeName)) {
                transformedOp = operation;
            } else if (!operation.hasDefined(this.attributeName)) {
                transformedOp = operation.clone();
                transformedOp.remove(this.attributeName);
            } else {
                PathAddress pa = PathAddress.pathAddress((ModelNode)operation.get("address"));
                transformedOp = Util.createEmptyOperation((String)"composite", null);
                ModelNode steps = transformedOp.get("steps");
                ModelNode clone = operation.clone();
                clone.remove(this.attributeName);
                steps.add(clone);
                ModelNode writeOp = Util.createEmptyOperation((String)"write-attribute", (PathAddress)pa);
                writeOp.get("name").set(this.attributeName);
                writeOp.get("value").set(operation.get(this.attributeName));
                steps.add(writeOp);
            }
            return new OperationTransformer.TransformedOperation(transformedOp, OperationResultTransformer.ORIGINAL_RESULT);
        }
    }

    private static class JaspiModulesToAttributeTransformer
    extends ModulesToAttributeTransformer {
        final boolean loginModule;

        private JaspiModulesToAttributeTransformer(String resourceName, String oldName) {
            super(resourceName, oldName);
            this.loginModule = oldName.equals("login-modules");
        }

        @Override
        public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation) throws OperationFailedException {
            PathAddress jaspiAddress = this.getJaspiAuthenticationAddress(address);
            ModelNode authModulesModel = new ModelNode();
            this.transformModulesToAttributes(jaspiAddress, "auth-module", "auth-modules", context, authModulesModel);
            ModelNode authModules = authModulesModel.get("auth-modules");
            if (authModules.asList().size() == 0) {
                return new OperationTransformer.TransformedOperation(Util.createRemoveOperation((PathAddress)jaspiAddress), OperationResultTransformer.ORIGINAL_RESULT);
            }
            ArrayList<ModelNode> list = new ArrayList<ModelNode>();
            ModelNode addJaspi = Util.createAddOperation((PathAddress)jaspiAddress);
            addJaspi.get("auth-modules").set(authModules);
            list.add(addJaspi);
            Resource jaspiResource = context.readResourceFromRoot(jaspiAddress);
            for (Resource.ResourceEntry entry : jaspiResource.getChildren("login-module-stack")) {
                PathAddress stackAddress = jaspiAddress.append(new PathElement[]{PathElement.pathElement((String)"login-module-stack", (String)entry.getName())});
                ModelNode loginModulesModel = new ModelNode();
                this.transformModulesToAttributes(stackAddress, "login-module", "login-modules", context, loginModulesModel);
                ModelNode loginModules = loginModulesModel.get("login-modules");
                if (loginModules.asList().size() <= 0) continue;
                ModelNode addStack = Util.createAddOperation((PathAddress)stackAddress);
                addStack.get("login-modules").set(loginModules);
                list.add(addStack);
            }
            return new OperationTransformer.TransformedOperation(this.createComposite(jaspiAddress, list.toArray(new ModelNode[list.size()])), OperationResultTransformer.ORIGINAL_RESULT);
        }

        private PathAddress getJaspiAuthenticationAddress(PathAddress address) {
            PathAddress jaspi = PathAddress.EMPTY_ADDRESS;
            for (PathElement element : address) {
                jaspi = jaspi.append(new PathElement[]{element});
                if (!element.equals(PATH_JASPI_AUTH)) continue;
                break;
            }
            return jaspi;
        }
    }

    private static class ModulesToAttributeTransformer
    implements CombinedTransformer {
        protected final String resourceName;
        protected final String attributeName;

        private ModulesToAttributeTransformer(String resourceName, String oldName) {
            this.resourceName = resourceName;
            this.attributeName = oldName;
        }

        String getResourceName() {
            return this.resourceName;
        }

        public void transformResource(ResourceTransformationContext context, PathAddress address, Resource resource) throws OperationFailedException {
            ModelNode model = new ModelNode();
            this.transformModulesToAttributes(address, this.resourceName, this.attributeName, (TransformationContext)context, model);
            resource.writeModel(model);
            ResourceTransformationContext childContext = context.addTransformedResource(PathAddress.EMPTY_ADDRESS, resource);
            childContext.processChildren(resource);
        }

        public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation) throws OperationFailedException {
            ModelNode model = new ModelNode();
            this.transformModulesToAttributes(address, this.resourceName, this.attributeName, context, model);
            ModelNode modules = model.get(this.attributeName);
            int len = modules.asList().size();
            if (len == 0) {
                return new OperationTransformer.TransformedOperation(Util.createRemoveOperation((PathAddress)address), OperationResultTransformer.ORIGINAL_RESULT);
            }
            ModelNode add = Util.createAddOperation((PathAddress)address);
            add.get(this.attributeName).set(modules);
            return new OperationTransformer.TransformedOperation(this.createComposite(address, add), OperationResultTransformer.ORIGINAL_RESULT);
        }

        void transformModulesToAttributes(PathAddress address, String newName, String oldName, TransformationContext context, ModelNode model) {
            ModelNode modules = model.get(oldName).setEmptyList();
            Set children = context.readResourceFromRoot(address).getChildren(newName);
            if (children != null) {
                for (Resource.ResourceEntry entry : children) {
                    Resource moduleResource = context.readResourceFromRoot(address.append(new PathElement[]{entry.getPathElement()}));
                    modules.add(moduleResource.getModel());
                }
            }
        }

        ModelNode createComposite(PathAddress address, ModelNode ... steps) {
            ModelNode composite = Util.createEmptyOperation((String)"composite", (PathAddress)PathAddress.EMPTY_ADDRESS);
            ModelNode stepsNode = composite.get("steps");
            stepsNode.add(Util.createRemoveOperation((PathAddress)address));
            for (ModelNode step : steps) {
                stepsNode.add(step);
            }
            return composite;
        }

        OperationTransformer.TransformedOperation transformParentOperation(TransformationContext context, PathAddress address, ModelNode operation) throws OperationFailedException {
            String op = operation.get("operation").asString();
            if ("add".equals(op)) {
                if (operation.hasDefined(this.attributeName)) {
                    return new OperationTransformer.TransformedOperation(operation, OperationTransformer.TransformedOperation.ORIGINAL_RESULT);
                }
            } else if (op.equals("write-attribute") || op.equals("undefine-attribute")) {
                return this.transformOperation(context, address, operation);
            }
            return OperationTransformer.DISCARD.transformOperation(context, address, operation);
        }
    }
}

