/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.PropertiesAttributeDefinition;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class PersistentResourceXMLDescription {
    protected final PersistentResourceDefinition resourceDefinition;
    protected final String xmlElementName;
    protected final String xmlWrapperElement;
    protected final LinkedHashMap<String, AttributeDefinition> attributes;
    protected final List<PersistentResourceXMLDescription> children;
    protected final boolean useValueAsElementName;
    protected final boolean noAddOperation;
    protected final AdditionalOperationsGenerator additionalOperationsGenerator;
    private boolean flushRequired = true;
    private final Map<String, AttributeParser> attributeParsers;

    protected PersistentResourceXMLDescription(PersistentResourceDefinition resourceDefinition, String xmlElementName, String xmlWrapperElement, LinkedHashMap<String, AttributeDefinition> attributes, List<PersistentResourceXMLDescription> children, boolean useValueAsElementName, boolean noAddOperation, AdditionalOperationsGenerator additionalOperationsGenerator, Map<String, AttributeParser> attributeParsers) {
        this.resourceDefinition = resourceDefinition;
        this.xmlElementName = xmlElementName;
        this.xmlWrapperElement = xmlWrapperElement;
        this.attributes = attributes;
        this.children = children;
        this.useValueAsElementName = useValueAsElementName;
        this.noAddOperation = noAddOperation;
        this.additionalOperationsGenerator = additionalOperationsGenerator;
        this.attributeParsers = attributeParsers;
    }

    public void parse(XMLExtendedStreamReader reader, PathAddress parentAddress, List<ModelNode> list) throws XMLStreamException {
        if (this.xmlWrapperElement != null) {
            if (reader.getLocalName().equals(this.xmlWrapperElement)) {
                if (reader.hasNext() && reader.nextTag() == 2) {
                    return;
                }
            } else {
                throw ParseUtils.unexpectedElement(reader);
            }
        }
        boolean wildcard = this.resourceDefinition.getPathElement().isWildcard();
        String name = null;
        ModelNode op = Util.createAddOperation();
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attributeName = reader.getAttributeLocalName(i);
            String value = reader.getAttributeValue(i);
            if (wildcard && "name".equals(attributeName)) {
                name = value;
                continue;
            }
            if (this.attributes.containsKey(attributeName)) {
                AttributeParser parser;
                AttributeDefinition def = this.attributes.get(attributeName);
                AttributeParser attributeParser = parser = this.attributeParsers.containsKey(attributeName) ? this.attributeParsers.get(attributeName) : def.getParser();
                assert (parser != null);
                parser.parseAndSetParameter(def, value, op, (XMLStreamReader)reader);
                continue;
            }
            throw ParseUtils.unexpectedAttribute(reader, i);
        }
        for (AttributeDefinition attributeDefinition : this.attributes.values()) {
            if (!(attributeDefinition instanceof PropertiesAttributeDefinition)) continue;
            PropertiesAttributeDefinition attribute = (PropertiesAttributeDefinition)attributeDefinition;
            attribute.parse(reader, op);
            this.flushRequired = false;
        }
        if (wildcard && name == null) {
            throw ControllerMessages.MESSAGES.missingRequiredAttributes(new StringBuilder("name"), reader.getLocation());
        }
        PathElement path = wildcard ? PathElement.pathElement(this.resourceDefinition.getPathElement().getKey(), name) : this.resourceDefinition.getPathElement();
        PathAddress address = parentAddress.append(path);
        if (!this.noAddOperation) {
            op.get("address").set(address.toModelNode());
            list.add(op);
        }
        if (this.additionalOperationsGenerator != null) {
            this.additionalOperationsGenerator.additionalOperations(address, op, list);
        }
        this.parseChildren(reader, address, list);
        if (this.xmlWrapperElement != null) {
            ParseUtils.requireNoContent(reader);
        }
    }

    private Map<String, PersistentResourceXMLDescription> getChildrenMap() {
        HashMap<String, PersistentResourceXMLDescription> res = new HashMap<String, PersistentResourceXMLDescription>();
        for (PersistentResourceXMLDescription child : this.children) {
            if (child.xmlWrapperElement != null) {
                res.put(child.xmlWrapperElement, child);
                continue;
            }
            res.put(child.xmlElementName, child);
        }
        return res;
    }

    public void parseChildren(XMLExtendedStreamReader reader, PathAddress parentAddress, List<ModelNode> list) throws XMLStreamException {
        if (this.children.size() == 0) {
            if (this.flushRequired) {
                ParseUtils.requireNoContent(reader);
            }
        } else {
            Map<String, PersistentResourceXMLDescription> children = this.getChildrenMap();
            while (reader.hasNext() && reader.nextTag() != 2) {
                PersistentResourceXMLDescription child = children.get(reader.getLocalName());
                if (child != null) {
                    child.parse(reader, parentAddress, list);
                    continue;
                }
                throw ParseUtils.unexpectedElement(reader);
            }
        }
    }

    public void persist(XMLExtendedStreamWriter writer, ModelNode model) throws XMLStreamException {
        this.persist(writer, model, null);
    }

    private void writeStartElement(XMLExtendedStreamWriter writer, String namespaceURI, String localName) throws XMLStreamException {
        if (namespaceURI != null) {
            writer.writeStartElement(namespaceURI, localName);
        } else {
            writer.writeStartElement(localName);
        }
    }

    public void startSubsystemElement(XMLExtendedStreamWriter writer, String namespaceURI, boolean empty) throws XMLStreamException {
        if (writer.getNamespaceContext().getPrefix(namespaceURI) == null) {
            writer.setDefaultNamespace(namespaceURI);
            if (empty) {
                writer.writeEmptyElement(Element.SUBSYSTEM.getLocalName());
            } else {
                writer.writeStartElement(Element.SUBSYSTEM.getLocalName());
            }
            writer.writeNamespace(null, namespaceURI);
        } else if (empty) {
            writer.writeEmptyElement(namespaceURI, Element.SUBSYSTEM.getLocalName());
        } else {
            writer.writeStartElement(namespaceURI, Element.SUBSYSTEM.getLocalName());
        }
    }

    public void persist(XMLExtendedStreamWriter writer, ModelNode model, String namespaceURI) throws XMLStreamException {
        boolean writeWrapper;
        boolean wildcard = this.resourceDefinition.getPathElement().isWildcard();
        model = wildcard ? model.get(this.resourceDefinition.getPathElement().getKey()) : model.get(this.resourceDefinition.getPathElement().getKeyValuePair());
        boolean isSubsystem = this.resourceDefinition.getPathElement().getKey().equals("subsystem");
        if (!(isSubsystem || model.isDefined() || this.useValueAsElementName)) {
            return;
        }
        boolean bl = writeWrapper = this.xmlWrapperElement != null;
        if (writeWrapper) {
            this.writeStartElement(writer, namespaceURI, this.xmlWrapperElement);
        }
        if (wildcard) {
            for (Property p : model.asPropertyList()) {
                if (this.useValueAsElementName) {
                    this.writeStartElement(writer, namespaceURI, p.getName());
                } else {
                    this.writeStartElement(writer, namespaceURI, this.xmlElementName);
                    writer.writeAttribute("name", p.getName());
                }
                for (Map.Entry<String, AttributeDefinition> def : this.attributes.entrySet()) {
                    def.getValue().getAttributeMarshaller().marshallAsAttribute(def.getValue(), p.getValue(), false, (XMLStreamWriter)writer);
                }
                this.persistChildren(writer, p.getValue());
                writer.writeEndElement();
            }
        } else {
            if (this.useValueAsElementName) {
                this.writeStartElement(writer, namespaceURI, this.resourceDefinition.getPathElement().getValue());
            } else if (isSubsystem) {
                this.startSubsystemElement(writer, namespaceURI, this.children.isEmpty());
            } else {
                this.writeStartElement(writer, namespaceURI, this.xmlElementName);
            }
            for (Map.Entry<String, AttributeDefinition> def : this.attributes.entrySet()) {
                def.getValue().getAttributeMarshaller().marshallAsAttribute(def.getValue(), model, true, (XMLStreamWriter)writer);
            }
            this.persistChildren(writer, model);
            if (!isSubsystem || !this.children.isEmpty()) {
                writer.writeEndElement();
            }
        }
        if (writeWrapper) {
            writer.writeEndElement();
        }
    }

    public void persistChildren(XMLExtendedStreamWriter writer, ModelNode model) throws XMLStreamException {
        for (PersistentResourceXMLDescription child : this.children) {
            child.persist(writer, model);
        }
    }

    public static PersistentResourceXMLBuilder builder(PersistentResourceDefinition resource) {
        return new PersistentResourceXMLBuilder(resource);
    }

    public static interface AdditionalOperationsGenerator {
        public void additionalOperations(PathAddress var1, ModelNode var2, List<ModelNode> var3);
    }

    public static class PersistentResourceXMLBuilder {
        protected final PersistentResourceDefinition resourceDefinition;
        protected String xmlElementName;
        protected String xmlWrapperElement;
        protected boolean useValueAsElementName;
        protected boolean noAddOperation;
        protected AdditionalOperationsGenerator additionalOperationsGenerator;
        protected final LinkedHashMap<String, AttributeDefinition> attributes = new LinkedHashMap();
        protected final List<PersistentResourceXMLBuilder> children = new ArrayList<PersistentResourceXMLBuilder>();
        protected final LinkedHashMap<String, AttributeParser> attributeParsers = new LinkedHashMap();

        protected PersistentResourceXMLBuilder(PersistentResourceDefinition resourceDefinition) {
            this.resourceDefinition = resourceDefinition;
            this.xmlElementName = resourceDefinition.getPathElement().isWildcard() ? resourceDefinition.getPathElement().getKey() : resourceDefinition.getPathElement().getValue();
        }

        public PersistentResourceXMLBuilder addChild(PersistentResourceXMLBuilder builder) {
            this.children.add(builder);
            return this;
        }

        public PersistentResourceXMLBuilder addAttribute(AttributeDefinition attribute) {
            this.attributes.put(attribute.getXmlName(), attribute);
            return this;
        }

        public PersistentResourceXMLBuilder addAttribute(AttributeDefinition attribute, AttributeParser attributeParser) {
            this.attributes.put(attribute.getXmlName(), attribute);
            this.attributeParsers.put(attribute.getXmlName(), attributeParser);
            return this;
        }

        public PersistentResourceXMLBuilder addAttributes(AttributeDefinition ... attributes) {
            for (AttributeDefinition at : attributes) {
                this.attributes.put(at.getXmlName(), at);
            }
            return this;
        }

        @Deprecated
        public PersistentResourceXMLBuilder addAttributes(Collection<? extends AttributeDefinition> attributes) {
            for (AttributeDefinition attributeDefinition : attributes) {
                this.attributes.put(attributeDefinition.getXmlName(), attributeDefinition);
            }
            return this;
        }

        public PersistentResourceXMLBuilder setXmlWrapperElement(String xmlWrapperElement) {
            this.xmlWrapperElement = xmlWrapperElement;
            return this;
        }

        public PersistentResourceXMLBuilder setXmlElementName(String xmlElementName) {
            this.xmlElementName = xmlElementName;
            return this;
        }

        public PersistentResourceXMLBuilder setUseValueAsElementName(boolean useValueAsElementName) {
            this.useValueAsElementName = useValueAsElementName;
            return this;
        }

        public PersistentResourceXMLBuilder setNoAddOperation(boolean noAddOperation) {
            this.noAddOperation = noAddOperation;
            return this;
        }

        public PersistentResourceXMLBuilder setAdditionalOperationsGenerator(AdditionalOperationsGenerator additionalOperationsGenerator) {
            this.additionalOperationsGenerator = additionalOperationsGenerator;
            return this;
        }

        public PersistentResourceXMLDescription build() {
            ArrayList<PersistentResourceXMLDescription> builtChildren = new ArrayList<PersistentResourceXMLDescription>();
            for (PersistentResourceXMLBuilder b : this.children) {
                builtChildren.add(b.build());
            }
            return new PersistentResourceXMLDescription(this.resourceDefinition, this.xmlElementName, this.xmlWrapperElement, this.attributes, builtChildren, this.useValueAsElementName, this.noAddOperation, this.additionalOperationsGenerator, this.attributeParsers);
        }
    }
}

