/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr.annotated;

import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.servlet.util.ImmediateInstanceHandle;
import io.undertow.websockets.jsr.Encoding;
import io.undertow.websockets.jsr.EncodingFactory;
import io.undertow.websockets.jsr.JsrWebSocketLogger;
import io.undertow.websockets.jsr.JsrWebSocketMessages;
import io.undertow.websockets.jsr.annotated.AnnotatedEndpoint;
import io.undertow.websockets.jsr.annotated.BoundMethod;
import io.undertow.websockets.jsr.annotated.BoundParameter;
import io.undertow.websockets.jsr.annotated.EmptyEndpointConfig;
import java.io.InputStream;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.websocket.CloseReason;
import javax.websocket.DecodeException;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.PongMessage;
import javax.websocket.Session;
import javax.websocket.server.PathParam;

public class AnnotatedEndpointFactory
implements InstanceFactory<Endpoint> {
    private final InstanceFactory<?> underlyingFactory;
    private final Class<?> endpointClass;
    private final BoundMethod OnOpen;
    private final BoundMethod OnClose;
    private final BoundMethod OnError;
    private final BoundMethod textMessage;
    private final BoundMethod binaryMessage;
    private final BoundMethod pongMessage;

    private AnnotatedEndpointFactory(Class<?> endpointClass, InstanceFactory<?> underlyingFactory, BoundMethod OnOpen, BoundMethod OnClose, BoundMethod OnError, BoundMethod textMessage, BoundMethod binaryMessage, BoundMethod pongMessage) {
        this.underlyingFactory = underlyingFactory;
        this.endpointClass = endpointClass;
        this.OnOpen = OnOpen;
        this.OnClose = OnClose;
        this.OnError = OnError;
        this.textMessage = textMessage;
        this.binaryMessage = binaryMessage;
        this.pongMessage = pongMessage;
    }

    public static AnnotatedEndpointFactory create(Class<?> endpointClass, InstanceFactory<?> underlyingInstance, EncodingFactory encodingFactory, Set<String> paths) throws DeploymentException {
        HashSet<Class<OnError>> found = new HashSet<Class<OnError>>();
        BoundMethod OnOpen2 = null;
        BoundMethod OnClose2 = null;
        BoundMethod OnError2 = null;
        BoundMethod textMessage = null;
        BoundMethod binaryMessage = null;
        BoundMethod pongMessage = null;
        Class<?> c = endpointClass;
        do {
            for (Method method : c.getDeclaredMethods()) {
                Class<?> param;
                int i;
                if (method.isAnnotationPresent(OnOpen.class)) {
                    if (found.contains(OnOpen.class)) {
                        throw JsrWebSocketMessages.MESSAGES.moreThanOneAnnotation(OnOpen.class);
                    }
                    found.add(OnOpen.class);
                    OnOpen2 = new BoundMethod(method, null, false, 0L, new BoundSingleParameter(method, Session.class, true), new BoundSingleParameter(method, EndpointConfig.class, true), AnnotatedEndpointFactory.createBoundPathParameters(method, paths, endpointClass));
                }
                if (method.isAnnotationPresent(OnClose.class)) {
                    if (found.contains(OnClose.class)) {
                        throw JsrWebSocketMessages.MESSAGES.moreThanOneAnnotation(OnClose.class);
                    }
                    found.add(OnClose.class);
                    OnClose2 = new BoundMethod(method, null, false, 0L, new BoundSingleParameter(method, Session.class, true), new BoundSingleParameter(method, CloseReason.class, true), AnnotatedEndpointFactory.createBoundPathParameters(method, paths, endpointClass));
                }
                if (method.isAnnotationPresent(OnError.class)) {
                    if (found.contains(OnError.class)) {
                        throw JsrWebSocketMessages.MESSAGES.moreThanOneAnnotation(OnError.class);
                    }
                    found.add(OnError.class);
                    OnError2 = new BoundMethod(method, null, false, 0L, new BoundSingleParameter(method, Session.class, true), new BoundSingleParameter(method, Throwable.class, false), AnnotatedEndpointFactory.createBoundPathParameters(method, paths, endpointClass));
                }
                if (!method.isAnnotationPresent(OnMessage.class)) continue;
                long maxMessageSize = method.getAnnotation(OnMessage.class).maxMessageSize();
                boolean messageHandled = false;
                Class<?>[] parameterTypes = method.getParameterTypes();
                for (i = 0; i < parameterTypes.length; ++i) {
                    if (AnnotatedEndpointFactory.hasAnnotation(PathParam.class, method.getParameterAnnotations()[i])) continue;
                    param = parameterTypes[i];
                    if (param.equals(byte[].class)) {
                        if (binaryMessage != null) {
                            throw JsrWebSocketMessages.MESSAGES.moreThanOneAnnotation(OnMessage.class);
                        }
                        binaryMessage = new BoundMethod(method, byte[].class, false, maxMessageSize, new BoundSingleParameter(method, Session.class, true), new BoundSingleParameter(method, Boolean.TYPE, true), new BoundSingleParameter(i, byte[].class), AnnotatedEndpointFactory.createBoundPathParameters(method, paths, endpointClass));
                        messageHandled = true;
                        break;
                    }
                    if (param.equals(ByteBuffer.class)) {
                        if (binaryMessage != null) {
                            throw JsrWebSocketMessages.MESSAGES.moreThanOneAnnotation(OnMessage.class);
                        }
                        binaryMessage = new BoundMethod(method, ByteBuffer.class, false, maxMessageSize, new BoundSingleParameter(method, Session.class, true), new BoundSingleParameter(method, Boolean.TYPE, true), new BoundSingleParameter(i, ByteBuffer.class), AnnotatedEndpointFactory.createBoundPathParameters(method, paths, endpointClass));
                        messageHandled = true;
                        break;
                    }
                    if (param.equals(InputStream.class)) {
                        if (binaryMessage != null) {
                            throw JsrWebSocketMessages.MESSAGES.moreThanOneAnnotation(OnMessage.class);
                        }
                        binaryMessage = new BoundMethod(method, InputStream.class, false, maxMessageSize, new BoundSingleParameter(method, Session.class, true), new BoundSingleParameter(method, Boolean.TYPE, true), new BoundSingleParameter(i, InputStream.class), AnnotatedEndpointFactory.createBoundPathParameters(method, paths, endpointClass));
                        messageHandled = true;
                        break;
                    }
                    if (param.equals(String.class) && AnnotatedEndpointFactory.getPathParam(method, i) == null) {
                        if (textMessage != null) {
                            throw JsrWebSocketMessages.MESSAGES.moreThanOneAnnotation(OnMessage.class);
                        }
                        textMessage = new BoundMethod(method, String.class, false, maxMessageSize, new BoundSingleParameter(method, Session.class, true), new BoundSingleParameter(method, Boolean.TYPE, true), new BoundSingleParameter(i, String.class), AnnotatedEndpointFactory.createBoundPathParameters(method, paths, endpointClass));
                        messageHandled = true;
                        break;
                    }
                    if (param.equals(Reader.class) && AnnotatedEndpointFactory.getPathParam(method, i) == null) {
                        if (textMessage != null) {
                            throw JsrWebSocketMessages.MESSAGES.moreThanOneAnnotation(OnMessage.class);
                        }
                        textMessage = new BoundMethod(method, Reader.class, false, maxMessageSize, new BoundSingleParameter(method, Session.class, true), new BoundSingleParameter(method, Boolean.TYPE, true), new BoundSingleParameter(i, Reader.class), AnnotatedEndpointFactory.createBoundPathParameters(method, paths, endpointClass));
                        messageHandled = true;
                        break;
                    }
                    if (!param.equals(PongMessage.class)) continue;
                    if (pongMessage != null) {
                        throw JsrWebSocketMessages.MESSAGES.moreThanOneAnnotation(OnMessage.class);
                    }
                    pongMessage = new BoundMethod(method, PongMessage.class, false, maxMessageSize, new BoundSingleParameter(method, Session.class, true), new BoundSingleParameter(i, PongMessage.class), AnnotatedEndpointFactory.createBoundPathParameters(method, paths, endpointClass));
                    messageHandled = true;
                    break;
                }
                if (!messageHandled) {
                    for (i = 0; i < parameterTypes.length; ++i) {
                        if (AnnotatedEndpointFactory.hasAnnotation(PathParam.class, method.getParameterAnnotations()[i])) continue;
                        param = parameterTypes[i];
                        if (encodingFactory.canDecodeText(param)) {
                            if (textMessage != null) {
                                throw JsrWebSocketMessages.MESSAGES.moreThanOneAnnotation(OnMessage.class);
                            }
                            textMessage = new BoundMethod(method, param, true, maxMessageSize, new BoundSingleParameter(method, Session.class, true), new BoundSingleParameter(method, Boolean.TYPE, true), new BoundSingleParameter(i, param), AnnotatedEndpointFactory.createBoundPathParameters(method, paths, endpointClass));
                            messageHandled = true;
                            break;
                        }
                        if (!encodingFactory.canDecodeBinary(param)) continue;
                        if (binaryMessage != null) {
                            throw JsrWebSocketMessages.MESSAGES.moreThanOneAnnotation(OnMessage.class);
                        }
                        binaryMessage = new BoundMethod(method, param, true, maxMessageSize, new BoundSingleParameter(method, Session.class, true), new BoundSingleParameter(method, Boolean.TYPE, true), new BoundSingleParameter(i, param), AnnotatedEndpointFactory.createBoundPathParameters(method, paths, endpointClass));
                        messageHandled = true;
                        break;
                    }
                }
                if (messageHandled) continue;
                throw JsrWebSocketMessages.MESSAGES.couldNotFindMessageParameter(method);
            }
        } while ((c = c.getSuperclass()) != Object.class && c != null);
        return new AnnotatedEndpointFactory(endpointClass, underlyingInstance, OnOpen2, OnClose2, OnError2, textMessage, binaryMessage, pongMessage);
    }

    private static BoundPathParameters createBoundPathParameters(Method method, Set<String> paths, Class<?> endpointClass) throws DeploymentException {
        return new BoundPathParameters(AnnotatedEndpointFactory.pathParams(method), method, endpointClass, paths);
    }

    private static String[] pathParams(Method method) {
        String[] params = new String[method.getParameterTypes().length];
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            PathParam param = AnnotatedEndpointFactory.getPathParam(method, i);
            if (param == null) continue;
            params[i] = param.value();
        }
        return params;
    }

    private static PathParam getPathParam(Method method, int parameter) {
        for (Annotation annotation : method.getParameterAnnotations()[parameter]) {
            if (!annotation.annotationType().equals(PathParam.class)) continue;
            return (PathParam)annotation;
        }
        return null;
    }

    private static boolean hasAnnotation(Class<? extends Annotation> annotationType, Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().equals(annotationType)) continue;
            return true;
        }
        return false;
    }

    public InstanceHandle<Endpoint> createInstance() throws InstantiationException {
        final InstanceHandle instance = this.underlyingFactory.createInstance();
        final AnnotatedEndpoint endpoint = new AnnotatedEndpoint(instance, this.OnOpen, this.OnClose, this.OnError, this.textMessage, this.binaryMessage, this.pongMessage);
        return new InstanceHandle<Endpoint>(){

            public Endpoint getInstance() {
                return endpoint;
            }

            public void release() {
                instance.release();
            }
        };
    }

    public Endpoint createInstanceForExisting(Object instance) {
        return new AnnotatedEndpoint((InstanceHandle<?>)new ImmediateInstanceHandle(instance), this.OnOpen, this.OnClose, this.OnError, this.textMessage, this.binaryMessage, this.pongMessage);
    }

    private static class BoundPathParameters
    implements BoundParameter {
        private final Class<?> endpointClass;
        private final Set<String> paths;
        private final String[] positions;
        private final Encoding[] encoders;
        private final Class[] types;

        public BoundPathParameters(String[] positions, Method method, Class<?> endpointClass, Set<String> paths) throws DeploymentException {
            this.positions = positions;
            this.endpointClass = endpointClass;
            this.paths = paths;
            this.encoders = new Encoding[positions.length];
            this.types = new Class[positions.length];
            for (int i = 0; i < positions.length; ++i) {
                Class<?> type = method.getParameterTypes()[i];
                Annotation[] annotations = method.getParameterAnnotations()[i];
                for (int j = 0; j < annotations.length; ++j) {
                    PathParam param;
                    if (!(annotations[j] instanceof PathParam) || paths.contains((param = (PathParam)annotations[j]).value())) continue;
                    JsrWebSocketLogger.ROOT_LOGGER.pathTemplateNotFound(endpointClass, param, method, paths);
                }
                if (positions[i] == null || type == null || type == String.class) continue;
                if (EncodingFactory.DEFAULT.canEncodeText(type)) {
                    this.encoders[i] = EncodingFactory.DEFAULT.createEncoding(EmptyEndpointConfig.INSTANCE);
                    this.types[i] = type;
                    continue;
                }
                throw JsrWebSocketMessages.MESSAGES.couldNotFindDecoderForType(type, method);
            }
        }

        @Override
        public Set<Integer> positions() {
            HashSet<Integer> ret = new HashSet<Integer>();
            for (int i = 0; i < this.positions.length; ++i) {
                if (this.positions[i] == null) continue;
                ret.add(i);
            }
            return ret;
        }

        @Override
        public void populate(Object[] params, Map<Class<?>, Object> value) throws DecodeException {
            Map data = (Map)value.get(Map.class);
            for (int i = 0; i < this.positions.length; ++i) {
                String name = this.positions[i];
                if (name == null) continue;
                Encoding encoding = this.encoders[i];
                params[i] = encoding == null ? data.get(name) : encoding.decodeText(this.types[i], (String)data.get(name));
            }
        }

        @Override
        public Class<?> getType() {
            return Map.class;
        }
    }

    private static class BoundSingleParameter
    implements BoundParameter {
        private final int position;
        private final Class<?> type;

        public BoundSingleParameter(int position, Class<?> type) {
            this.position = position;
            this.type = type;
        }

        public BoundSingleParameter(Method method, Class<?> type, boolean optional) {
            this.type = type;
            int pos = -1;
            for (int i = 0; i < method.getParameterTypes().length; ++i) {
                boolean pathParam = false;
                for (Annotation annotation : method.getParameterAnnotations()[i]) {
                    if (!annotation.annotationType().equals(PathParam.class)) continue;
                    pathParam = true;
                    break;
                }
                if (pathParam || !method.getParameterTypes()[i].equals(type)) continue;
                if (pos != -1) {
                    throw JsrWebSocketMessages.MESSAGES.moreThanOneParameterOfType(type, method);
                }
                pos = i;
            }
            if (pos != -1) {
                this.position = pos;
            } else if (optional) {
                this.position = -1;
            } else {
                throw JsrWebSocketMessages.MESSAGES.parameterNotFound(type, method);
            }
        }

        @Override
        public Set<Integer> positions() {
            if (this.position == -1) {
                return Collections.emptySet();
            }
            return Collections.singleton(this.position);
        }

        @Override
        public void populate(Object[] params, Map<Class<?>, Object> value) {
            if (this.position == -1) {
                return;
            }
            params[this.position] = value.get(this.type);
        }

        @Override
        public Class<?> getType() {
            return this.type;
        }
    }
}

