/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import javax.jms.XASession;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;
import org.apache.cxf.service.model.EndpointInfo;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.jms.support.JmsUtils;

public class JCATransactionalMessageListenerContainer
extends DefaultMessageListenerContainer {
    static final ThreadLocal<Map<Class<?>, ?>> ENDPOINT_LOCAL = new ThreadLocal();
    static final String MESSAGE_ENDPOINT_FACTORY = "MessageEndpointFactory";
    static final String MDB_TRANSACTED_METHOD = "MDBTransactedMethod";
    private MessageEndpointFactory factory;
    private Method method;

    public JCATransactionalMessageListenerContainer(EndpointInfo ei) {
        this.factory = (MessageEndpointFactory)ei.getProperty(MESSAGE_ENDPOINT_FACTORY, MessageEndpointFactory.class);
        this.method = (Method)ei.getProperty(MDB_TRANSACTED_METHOD, Method.class);
        this.setCacheLevel(1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean receiveAndExecute(Object invoker, Session session, MessageConsumer consumer) throws JMSException {
        Session s;
        XASession xa;
        MessageConsumer mc;
        boolean messageReceived;
        block5: {
            messageReceived = false;
            MessageEndpoint ep = null;
            mc = null;
            xa = null;
            s = null;
            try {
                xa = (XASession)this.createSession(this.getSharedConnection());
                XAResource xar = xa.getXAResource();
                s = xa.getSession();
                mc = s.createConsumer(this.getDestination());
                ep = this.factory.createEndpoint(xar);
                HashMap<Class<MessageEndpoint>, MessageEndpoint> mp = new HashMap<Class<MessageEndpoint>, MessageEndpoint>();
                mp.put(MessageEndpoint.class, ep);
                ENDPOINT_LOCAL.set(mp);
                ep.beforeDelivery(this.method);
                messageReceived = this.doReceiveAndExecute(invoker, s, mc, null);
                ep.afterDelivery();
                if (ep == null) break block5;
            }
            catch (Exception ex) {
                try {
                    throw new JMSException(ex.getMessage());
                }
                catch (Throwable throwable) {
                    if (ep != null) {
                        ep.release();
                    }
                    JmsUtils.closeMessageConsumer(mc);
                    JmsUtils.closeSession((Session)xa);
                    JmsUtils.closeSession(s);
                    throw throwable;
                }
            }
            ep.release();
        }
        JmsUtils.closeMessageConsumer((MessageConsumer)mc);
        JmsUtils.closeSession((Session)xa);
        JmsUtils.closeSession((Session)s);
        return messageReceived;
    }
}

